/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.sessionconsole;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.tools.beans.MessageDialog;
import org.eclipse.persistence.tools.sessionconsole.LoginEditorPanel;

public class LoginEditorDialog
extends JDialog {
    private boolean wasCanceled = true;
    private JButton ivjCancelButton = null;
    private LoginEditorPanel ivjLoginEditorPanel1 = null;
    private JPanel ivjMainPanel = null;
    private JButton ivjOKButton = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public LoginEditorDialog() {
        this.initialize();
    }

    public LoginEditorDialog(Frame owner) {
        super(owner);
    }

    public LoginEditorDialog(Frame owner, String title) {
        super(owner, title);
    }

    public LoginEditorDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public LoginEditorDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public static void centerComponent(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = component.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        component.setLocation(screenSize.width - size.width, screenSize.height - size.height);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.markCanceled();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.loginOK();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new JButton();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setText("Cancel");
                this.ivjCancelButton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancelButton;
    }

    public DatabaseLogin getLogin() {
        return this.getLoginEditorPanel1().getLogin();
    }

    private LoginEditorPanel getLoginEditorPanel1() {
        if (this.ivjLoginEditorPanel1 == null) {
            try {
                this.ivjLoginEditorPanel1 = new LoginEditorPanel();
                this.ivjLoginEditorPanel1.setName("LoginEditorPanel1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoginEditorPanel1;
    }

    private JPanel getMainPanel() {
        if (this.ivjMainPanel == null) {
            try {
                this.ivjMainPanel = new JPanel();
                this.ivjMainPanel.setName("MainPanel");
                this.ivjMainPanel.setLayout(new GridBagLayout());
                this.ivjMainPanel.setBackground(SystemColor.control);
                GridBagConstraints constraintsLoginEditorPanel1 = new GridBagConstraints();
                constraintsLoginEditorPanel1.gridx = 0;
                constraintsLoginEditorPanel1.gridy = 0;
                constraintsLoginEditorPanel1.fill = 1;
                constraintsLoginEditorPanel1.weightx = 1.0;
                constraintsLoginEditorPanel1.weighty = 1.0;
                this.getMainPanel().add((Component)this.getLoginEditorPanel1(), constraintsLoginEditorPanel1);
                GridBagConstraints constraintsOKButton = new GridBagConstraints();
                constraintsOKButton.gridx = 0;
                constraintsOKButton.gridy = 0;
                constraintsOKButton.anchor = 17;
                constraintsOKButton.ipadx = 20;
                constraintsOKButton.insets = new Insets(0, 2, 2, 0);
                this.getMainPanel().add((Component)this.getOKButton(), constraintsOKButton);
                GridBagConstraints constraintsCancelButton = new GridBagConstraints();
                constraintsCancelButton.gridx = 0;
                constraintsCancelButton.gridy = 0;
                constraintsCancelButton.gridheight = 2;
                constraintsCancelButton.fill = 3;
                constraintsCancelButton.anchor = 13;
                constraintsCancelButton.insets = new Insets(0, 0, 2, 2);
                this.getMainPanel().add((Component)this.getCancelButton(), constraintsCancelButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMainPanel;
    }

    private JButton getOKButton() {
        if (this.ivjOKButton == null) {
            try {
                this.ivjOKButton = new JButton();
                this.ivjOKButton.setName("OKButton");
                this.ivjOKButton.setText("OK");
                this.ivjOKButton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOKButton;
    }

    private void handleException(Throwable exception) {
        MessageDialog.displayException(exception, this);
    }

    private void initConnections() throws Exception {
        this.getCancelButton().addActionListener(this.ivjEventHandler);
        this.getOKButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("LoginEditorDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(609, 387);
            this.setModal(false);
            this.setTitle("TopLink Login Editor");
            this.setContentPane(this.getMainPanel());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        LoginEditorDialog.centerComponent(this);
    }

    public static DatabaseLogin launch(Frame parent, DatabaseLogin login) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            LoginEditorDialog aLoginEditorDialog = new LoginEditorDialog();
            aLoginEditorDialog.getLoginEditorPanel1().setLogin(login);
            aLoginEditorDialog.setModal(true);
            aLoginEditorDialog.setVisible(true);
            if (aLoginEditorDialog.wasCanceled()) {
                return null;
            }
            return aLoginEditorDialog.getLogin();
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void loginOK() {
        this.setWasCanceled(false);
        this.dispose();
    }

    public void markCanceled() {
        this.setWasCanceled(true);
        this.dispose();
    }

    protected void setWasCanceled(boolean wasCanceled) {
        this.wasCanceled = wasCanceled;
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LoginEditorDialog.this.getCancelButton()) {
                LoginEditorDialog.this.connEtoC1(e);
            }
            if (e.getSource() == LoginEditorDialog.this.getOKButton()) {
                LoginEditorDialog.this.connEtoC2();
            }
        }
    }
}

