/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.ApplicationAccessWLS;
import org.eclipse.persistence.sdo.helper.ApplicationResolver;
import org.eclipse.persistence.sdo.helper.MapKeyLookupResult;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDODataFactoryDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;

public class SDOHelperContext
implements HelperContext {
    private static final Logger LOGGER = Logger.getLogger(SDOHelperContext.class.getName());
    protected CopyHelper copyHelper;
    protected DataFactory dataFactory;
    protected DataHelper dataHelper;
    protected EqualityHelper equalityHelper;
    protected XMLHelper xmlHelper;
    protected TypeHelper typeHelper;
    protected XSDHelper xsdHelper;
    private String identifier;
    private Map<String, Object> properties;
    private boolean isStrictTypeCheckingEnabled = PrivilegedAccessHelper.getSystemPropertyBoolean("eclipselink.sdo.strict.type.checking", true);
    public static final String STRICT_TYPE_CHECKING_PROPERTY_NAME = "eclipselink.sdo.strict.type.checking";
    private static ConcurrentHashMap<Object, ConcurrentHashMap<String, HelperContext>> helperContexts = new ConcurrentHashMap();
    private static ConcurrentHashMap<Object, ConcurrentHashMap<String, String>> aliasMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Object, HelperContextResolver> HELPER_CONTEXT_RESOLVERS = new ConcurrentHashMap();
    private static WeakHashMap<ClassLoader, WeakHashMap<String, WeakReference<HelperContext>>> userSetHelperContexts = new WeakHashMap();
    private static ConcurrentHashMap<String, ClassLoader> appNameToClassLoaderMap = new ConcurrentHashMap();
    private static String OC4J_CLASSLOADER_NAME = "oracle";
    private static String WLS_CLASSLOADER_NAME = "weblogic";
    private static String WAS_CLASSLOADER_NAME = "com.ibm.ws";
    private static String JBOSS_CLASSLOADER_NAME = "jboss";
    private static String GLOBAL_HELPER_IDENTIFIER = "";
    private static final int WLS_IDENTIFIER = 0;
    private static final int JBOSS_IDENTIFIER = 1;
    private static final int COUNTER_LIMIT = 20;
    private static volatile ApplicationAccessWLS applicationAccessWLS = null;
    private static MBeanServer wlsMBeanServer = null;
    private static ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_RUNTIME_SERVICE = "RuntimeService";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_APP_RUNTIMES = "ApplicationRuntimes";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD = "ExecuteThread";
    private static final String WLS_MBEAN_SERVER = "MBeanServer";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME = "ApplicationName";
    private static final String WLS_APPLICATION_VERSION = "ApplicationVersion";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final String WLS_ACTIVE_VERSION_STATE = "ActiveVersionState";
    private static final Class[] WLS_PARAMETER_TYPES = new Class[0];
    private static final String WAS_NEWLINE = "\n";
    private static final String WAS_APP_COLON = "[app:";
    private static final String WAS_CLOSE_BRACKET = "]";
    private static MBeanServer jbossMBeanServer = null;
    private static String JBOSS_SERVICE_CONTROLLER = "jboss.system:service=ServiceController";
    private static String JBOSS_TYPE_STOP = "org.jboss.system.ServiceMBean.stop";
    private static String JBOSS_ID_KEY = "id";
    private static final String JBOSS_DEFAULT_DOMAIN_NAME = "jboss";
    private static final String JBOSS_VFSZIP = "vfszip:";
    private static final String JBOSS_VFSFILE = "vfsfile:";
    private static final String JBOSS_EAR = ".ear";
    private static final String JBOSS_JAR = ".jar";
    private static final String JBOSS_WAR = ".war";
    private static final int JBOSS_VFSZIP_OFFSET = "vfszip:".length();
    private static final int JBOSS_VFSFILE_OFFSET = "vfsfile:".length();
    private static final int JBOSS_EAR_OFFSET = ".ear".length();
    private static final int JBOSS_TRIM_COUNT = 2;
    private static ApplicationResolver appResolver;
    private static boolean isAppResolverSet;
    private static final HelperContextResolver DEFAULT_HCR;

    static {
        isAppResolverSet = false;
        DEFAULT_HCR = new DefaultHelperContextResolver();
    }

    public static void setApplicationResolver(ApplicationResolver aResolver) {
        if (SDOHelperContext.isApplicationResolverSet()) {
            throw SDOException.attemptToResetApplicationResolver();
        }
        appResolver = aResolver;
        isAppResolverSet = true;
    }

    public static boolean isApplicationResolverSet() {
        return isAppResolverSet;
    }

    public SDOHelperContext() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(String identifier) {
        this(identifier, Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(ClassLoader aClassLoader) {
        this.identifier = GLOBAL_HELPER_IDENTIFIER;
        this.initialize(aClassLoader);
    }

    public SDOHelperContext(String identifier, ClassLoader aClassLoader) {
        this.identifier = identifier;
        this.initialize(aClassLoader);
    }

    protected void initialize(ClassLoader aClassLoader) {
        this.copyHelper = new SDOCopyHelper(this);
        this.dataFactory = new SDODataFactoryDelegate(this);
        this.dataHelper = new SDODataHelper(this);
        this.equalityHelper = new SDOEqualityHelper(this);
        this.xmlHelper = new SDOXMLHelperDelegate(this, aClassLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public void reset() {
        ((SDOTypeHelper)this.getTypeHelper()).reset();
        ((SDOXMLHelper)this.getXMLHelper()).reset();
        ((SDOXSDHelper)this.getXSDHelper()).reset();
    }

    public CopyHelper getCopyHelper() {
        return this.copyHelper;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public DataHelper getDataHelper() {
        return this.dataHelper;
    }

    public EqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public XMLHelper getXMLHelper() {
        return this.xmlHelper;
    }

    public XSDHelper getXSDHelper() {
        return this.xsdHelper;
    }

    public ExternalizableDelegator.Resolvable createResolvable() {
        return new SDOResolvable(this);
    }

    public ExternalizableDelegator.Resolvable createResolvable(Object target) {
        return new SDOResolvable(target, this);
    }

    public static void putHelperContext(ClassLoader key, HelperContext value) {
        if (key == null || value == null) {
            return;
        }
        WeakHashMap<String, WeakReference<Object>> currentMap = userSetHelperContexts.get(key);
        if (currentMap == null) {
            currentMap = new WeakHashMap();
            userSetHelperContexts.put(key, currentMap);
        }
        currentMap.put(((SDOHelperContext)value).getIdentifier(), new WeakReference<HelperContext>(value));
    }

    private static HelperContext getUserSetHelperContext(String identifier, ClassLoader key) {
        if (key == null) {
            return null;
        }
        WeakHashMap<String, WeakReference<HelperContext>> currentMap = userSetHelperContexts.get(key);
        if (currentMap == null) {
            return null;
        }
        WeakReference<HelperContext> ref = currentMap.get(identifier);
        if (ref == null) {
            return null;
        }
        return (HelperContext)ref.get();
    }

    public static void removeHelperContext(ClassLoader key) {
        if (key == null) {
            return;
        }
        userSetHelperContexts.remove(key);
    }

    public static void removeHelperContext(String identifier, ClassLoader key) {
        if (key == null) {
            return;
        }
        WeakHashMap<String, WeakReference<HelperContext>> currentMap = userSetHelperContexts.get(key);
        if (currentMap != null) {
            currentMap.remove(key);
        }
    }

    public static HelperContext getHelperContext() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        HelperContext hCtx = SDOHelperContext.getUserSetHelperContext(GLOBAL_HELPER_IDENTIFIER, contextClassLoader);
        if (hCtx != null) {
            return hCtx;
        }
        return SDOHelperContext.getHelperContext(GLOBAL_HELPER_IDENTIFIER);
    }

    public static HelperContext getHelperContext(String identifier) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return SDOHelperContext.getHelperContext(identifier, contextClassLoader);
    }

    public static HelperContext getHelperContext(String identifier, ClassLoader classLoader) {
        HelperContext helperContext;
        ConcurrentMap<String, String> aliasEntries = SDOHelperContext.getAliasMap();
        if (aliasEntries.containsKey(identifier)) {
            identifier = (String)aliasEntries.get(identifier);
        }
        if ((helperContext = SDOHelperContext.getUserSetHelperContext(identifier, classLoader)) != null) {
            return helperContext;
        }
        ConcurrentMap<String, HelperContext> contextMap = SDOHelperContext.getContextMap();
        helperContext = (HelperContext)contextMap.get(identifier);
        if (helperContext == null) {
            LOGGER.fine("helperContext not found.");
            helperContext = SDOHelperContext.getHelperContextResolver().getHelperContext(identifier, classLoader);
            HelperContext existingContext = contextMap.putIfAbsent(identifier, helperContext);
            if (existingContext != null) {
                LOGGER.fine(String.format("contextMap already has context for id: %s. Existing one will be used.", identifier));
                helperContext = existingContext;
            }
        }
        return helperContext;
    }

    static ConcurrentMap<String, HelperContext> getContextMap() {
        ClassLoader currentAppLoader;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String classLoaderName = contextClassLoader.getClass().getName();
        MapKeyLookupResult hCtxMapKey = SDOHelperContext.getContextMapKey(contextClassLoader, classLoaderName);
        String appName = hCtxMapKey.getApplicationName();
        ClassLoader appLoader = hCtxMapKey.getLoader();
        Object contextMapKey = appName != null ? appName : appLoader;
        ConcurrentHashMap<String, Object> contextMap = helperContexts.get(contextMapKey);
        if (contextMap != null && appName != null && classLoaderName.contains(WAS_CLASSLOADER_NAME) && (currentAppLoader = appNameToClassLoaderMap.get(appName)) != null && currentAppLoader != appLoader) {
            appNameToClassLoaderMap.remove(appName, currentAppLoader);
            helperContexts.remove(appName, contextMap);
            contextMap = null;
        }
        if (contextMap == null) {
            contextMap = new ConcurrentHashMap();
            ConcurrentHashMap<String, HelperContext> existingMap = helperContexts.putIfAbsent(contextMapKey, contextMap);
            if (existingMap != null) {
                contextMap = existingMap;
            } else if (appName != null) {
                appNameToClassLoaderMap.put(appName, appLoader);
                if (classLoaderName.contains(WLS_CLASSLOADER_NAME)) {
                    helperContexts.put(appLoader, contextMap);
                    SDOHelperContext.addWLSNotificationListener(appName);
                } else if (classLoaderName.contains(JBOSS_CLASSLOADER_NAME)) {
                    SDOHelperContext.addJBossNotificationListener();
                }
            }
        }
        return contextMap;
    }

    public static void putHelperContext(HelperContext ctx) {
        String identifier = ((SDOHelperContext)ctx).getIdentifier();
        if (GLOBAL_HELPER_IDENTIFIER.equals(identifier)) {
            return;
        }
        SDOHelperContext.getContextMap().put(identifier, ctx);
        SDOHelperContext.getAliasMap().remove(identifier);
    }

    private static void resetHelperContext(String key) {
        boolean successHc = SDOHelperContext.removeAppFromMap(helperContexts, key);
        boolean successHcr = SDOHelperContext.removeAppFromMap(HELPER_CONTEXT_RESOLVERS, key);
        if (LOGGER.isLoggable(Level.WARNING) && !successHc && !successHcr) {
            LOGGER.warning("No entries found in maps for application:" + key);
        }
        appNameToClassLoaderMap.remove(key);
        aliasMap.remove(key);
    }

    private static boolean removeAppFromMap(Map map, String appName) {
        Object result = map.remove(appName);
        if (result != null) {
            return true;
        }
        ClassLoader appLoader = appNameToClassLoaderMap.get(appName);
        result = appLoader != null ? map.remove(appLoader) : map.remove(Thread.currentThread().getContextClassLoader());
        return result != null;
    }

    private static Object getMapKey() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String classLoaderName = contextClassLoader.getClass().getName();
        MapKeyLookupResult hCtxMapKey = SDOHelperContext.getContextMapKey(contextClassLoader, classLoaderName);
        String appName = hCtxMapKey.getApplicationName();
        ClassLoader appLoader = hCtxMapKey.getLoader();
        return appName != null ? appName : appLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static MapKeyLookupResult getContextMapKey(ClassLoader classLoader, String classLoaderName) {
        if (classLoaderName.startsWith(OC4J_CLASSLOADER_NAME)) {
            if (classLoader.getParent() == null) return new MapKeyLookupResult(classLoader);
            if (classLoader.toString().indexOf(".web.") == -1) {
                if (classLoader.toString().indexOf(".wrappers") == -1) return new MapKeyLookupResult(classLoader);
            }
            classLoader = classLoader.getParent();
            return new MapKeyLookupResult(classLoader);
        }
        if (classLoaderName.contains(WLS_CLASSLOADER_NAME)) {
            Object appName;
            if (applicationAccessWLS == null) {
                Class<SDOHelperContext> clazz = SDOHelperContext.class;
                // MONITORENTER : org.eclipse.persistence.sdo.helper.SDOHelperContext.class
                if (applicationAccessWLS == null) {
                    applicationAccessWLS = new ApplicationAccessWLS();
                }
                // MONITOREXIT : clazz
            }
            if ((appName = applicationAccessWLS.getApplicationName(classLoader)) != null) {
                return new MapKeyLookupResult(appName.toString(), classLoader);
            }
            Object executeThread = SDOHelperContext.getExecuteThread();
            if (executeThread != null) {
                try {
                    Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), WLS_APPLICATION_NAME_GET_METHOD_NAME, WLS_PARAMETER_TYPES, false);
                    appName = PrivilegedAccessHelper.invokeMethod(getMethod, executeThread);
                }
                catch (Exception e) {
                    throw SDOException.errorInvokingWLSMethodReflectively(WLS_APPLICATION_NAME_GET_METHOD_NAME, WLS_EXECUTE_THREAD, e);
                }
            }
            if (appName == null && appResolver != null) {
                appName = appResolver.getApplicationName();
            }
            if (appName == null) return new MapKeyLookupResult(classLoader);
            return new MapKeyLookupResult(appName.toString(), classLoader);
        }
        if (classLoaderName.contains(WAS_CLASSLOADER_NAME)) {
            return SDOHelperContext.getContextMapKeyForWAS(classLoader);
        }
        if (!classLoaderName.contains(JBOSS_CLASSLOADER_NAME)) return new MapKeyLookupResult(classLoader);
        return SDOHelperContext.getContextMapKeyForJBoss(classLoader);
    }

    private static MBeanServer getWLSMBeanServer() {
        if (wlsMBeanServer == null) {
            InitialContext weblogicContext = null;
            try {
                weblogicContext = new InitialContext();
                try {
                    wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_ENV_CONTEXT_LOOKUP);
                }
                catch (NamingException namingException) {
                    try {
                        wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_CONTEXT_LOOKUP);
                    }
                    catch (NamingException ne) {
                        throw SDOException.errorPerformingWLSLookup(WLS_MBEAN_SERVER, ne);
                    }
                }
            }
            catch (NamingException nex) {
                throw SDOException.errorCreatingWLSInitialContext(nex);
            }
        }
        return wlsMBeanServer;
    }

    private static Object getExecuteThread() {
        if (SDOHelperContext.getWLSMBeanServer() != null) {
            if (wlsThreadPoolRuntime == null) {
                ObjectName service = null;
                ObjectName serverRuntime = null;
                try {
                    service = new ObjectName(WLS_SERVICE_KEY);
                }
                catch (Exception x) {
                    throw SDOException.errorGettingWLSObjectName("RuntimeService [com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean]", x);
                }
                try {
                    serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                }
                catch (Exception x) {
                    throw SDOException.errorGettingWLSObjectName(WLS_SERVER_RUNTIME, x);
                }
                try {
                    wlsThreadPoolRuntime = (ObjectName)wlsMBeanServer.getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception x) {
                    throw SDOException.errorGettingWLSObjectName(WLS_THREADPOOL_RUNTIME, x);
                }
            }
            try {
                return wlsMBeanServer.invoke(wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
            }
            catch (Exception x) {
                throw SDOException.errorInvokingWLSMethodReflectively(WLS_EXECUTE_THREAD_GET_METHOD_NAME, WLS_THREADPOOL_RUNTIME, x);
            }
        }
        return null;
    }

    private static void addWLSNotificationListener(String applicationName) {
        block5: {
            try {
                if (SDOHelperContext.getWLSMBeanServer() == null) break block5;
                ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                ObjectName serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                ObjectName[] appRuntimes = (ObjectName[])wlsMBeanServer.getAttribute(serverRuntime, WLS_APP_RUNTIMES);
                int i = 0;
                while (i < appRuntimes.length) {
                    block6: {
                        try {
                            ObjectName appRuntime = appRuntimes[i];
                            Object appName = wlsMBeanServer.getAttribute(appRuntime, WLS_APPLICATION_NAME);
                            Object appVersion = wlsMBeanServer.getAttribute(appRuntime, WLS_APPLICATION_VERSION);
                            String appIdentifier = null;
                            if (appName == null || (appIdentifier = appVersion != null ? String.valueOf(appName.toString()) + "#" + appVersion.toString() : appName.toString()) == null || !appIdentifier.equals(applicationName)) break block6;
                            wlsMBeanServer.addNotificationListener(appRuntime, new MyNotificationListener(applicationName, 0), null, null);
                            break;
                        }
                        catch (Exception ex) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block6;
                            LOGGER.fine("Failed to retrieve application name in runtime " + appRuntimes[i].toString() + ":\n" + Helper.printStackTraceToString(ex));
                        }
                    }
                    ++i;
                }
            }
            catch (Exception x) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                LOGGER.warning("Failed to add notification listener for application " + applicationName + ":\n" + Helper.printStackTraceToString(x));
            }
        }
    }

    private static void addJBossNotificationListener() {
        if (jbossMBeanServer == null) {
            ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer server : mbeanServers) {
                if (!server.getDefaultDomain().equals(JBOSS_DEFAULT_DOMAIN_NAME)) continue;
                jbossMBeanServer = server;
                try {
                    jbossMBeanServer.addNotificationListener(new ObjectName(JBOSS_SERVICE_CONTROLLER), new MyNotificationListener(1), (NotificationFilter)new MyNotificationFilter(), null);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    public static HelperContextResolver getHelperContextResolver() {
        Object key = SDOHelperContext.getMapKey();
        HelperContextResolver result = HELPER_CONTEXT_RESOLVERS.get(key);
        if (result == null) {
            result = DEFAULT_HCR;
            HELPER_CONTEXT_RESOLVERS.putIfAbsent(key, result);
        }
        return result;
    }

    public static void setHelperContextResolver(Object helperContextResolver) {
        Object key = SDOHelperContext.getMapKey();
        if (helperContextResolver == null) {
            HELPER_CONTEXT_RESOLVERS.put(key, DEFAULT_HCR);
        } else {
            HELPER_CONTEXT_RESOLVERS.put(key, new ReflectionHelperContextResolver(helperContextResolver));
        }
    }

    public static void setHelperContextResolver(HelperContextResolver helperContextResolver) {
        Object key = SDOHelperContext.getMapKey();
        if (helperContextResolver == null) {
            HELPER_CONTEXT_RESOLVERS.put(key, DEFAULT_HCR);
        } else {
            HELPER_CONTEXT_RESOLVERS.put(key, helperContextResolver);
        }
    }

    public static void removeHelerContextResolver() {
        HELPER_CONTEXT_RESOLVERS.remove(SDOHelperContext.getMapKey());
    }

    public void makeDefaultContext() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        MapKeyLookupResult hCtxMapKey = SDOHelperContext.getContextMapKey(contextClassLoader, contextClassLoader.getClass().getName());
        String appName = hCtxMapKey.getApplicationName();
        ClassLoader appLoader = hCtxMapKey.getLoader();
        Object contextMapKey = appName != null ? appName : appLoader;
        ConcurrentHashMap<String, Object> contexts = helperContexts.get(contextMapKey);
        if (contexts == null) {
            contexts = new ConcurrentHashMap();
            ConcurrentHashMap<String, Object> existingContexts = helperContexts.putIfAbsent(contextMapKey, contexts);
            if (existingContexts != null) {
                contexts = existingContexts;
            } else if (appName != null) {
                appNameToClassLoaderMap.put(appName, appLoader);
            }
        }
        this.identifier = GLOBAL_HELPER_IDENTIFIER;
        contexts.put(GLOBAL_HELPER_IDENTIFIER, this);
    }

    private static String getApplicationNameFromWASClassLoader(ClassLoader loader) {
        String firstLine;
        int appPos;
        String applicationName = null;
        String loaderString = loader.toString().trim();
        while (loaderString.startsWith(WAS_NEWLINE) && loaderString.length() > 0) {
            loaderString = loaderString.substring(1).trim();
        }
        String[] loaderStringLines = loaderString.split(WAS_NEWLINE, 2);
        if (loaderStringLines.length > 0 && (appPos = (firstLine = loaderStringLines[0].trim()).indexOf(WAS_APP_COLON)) >= 0 && appPos + WAS_APP_COLON.length() < firstLine.length()) {
            String appNameSegment = firstLine.substring(appPos + WAS_APP_COLON.length());
            int closingBracketPosition = appNameSegment.indexOf(WAS_CLOSE_BRACKET);
            applicationName = closingBracketPosition > 0 ? appNameSegment.substring(0, closingBracketPosition) : appNameSegment;
        }
        return applicationName;
    }

    private static MapKeyLookupResult getContextMapKeyForWAS(ClassLoader loader) {
        ClassLoader applicationLoader = loader;
        String applicationName = null;
        int i = 0;
        while (i < 20) {
            ClassLoader parent;
            if (SDOHelperContext.wasClassLoaderHasApplicationName(loader)) {
                applicationLoader = loader;
            }
            if ((parent = loader.getParent()) == null || parent == loader) {
                applicationName = SDOHelperContext.getApplicationNameFromWASClassLoader(applicationLoader);
                break;
            }
            loader = parent;
            ++i;
        }
        if (applicationName != null) {
            return new MapKeyLookupResult(applicationName, applicationLoader);
        }
        return new MapKeyLookupResult(applicationLoader);
    }

    private static boolean wasClassLoaderHasApplicationName(ClassLoader loader) {
        String firstLine;
        int appPos;
        String loaderString = loader.toString().trim();
        while (loaderString.startsWith(WAS_NEWLINE) && loaderString.length() > 0) {
            loaderString = loaderString.substring(1).trim();
        }
        String[] loaderStringLines = loaderString.split(WAS_NEWLINE, 2);
        return loaderStringLines.length > 0 && (appPos = (firstLine = loaderStringLines[0].trim()).indexOf(WAS_APP_COLON)) >= 0 && appPos + WAS_APP_COLON.length() < firstLine.length();
    }

    private static String getApplicationNameFromJBossClassLoader(String loaderToString) {
        String appNameSegment = null;
        int idx = loaderToString.indexOf(JBOSS_VFSZIP);
        if (idx != -1) {
            appNameSegment = loaderToString.substring(idx + JBOSS_VFSZIP_OFFSET, loaderToString.length() - 2);
            if (appNameSegment.indexOf(JBOSS_WAR) != -1 && appNameSegment.indexOf(JBOSS_EAR) != -1) {
                appNameSegment = appNameSegment.substring(0, appNameSegment.indexOf(JBOSS_EAR) + JBOSS_EAR_OFFSET);
            } else if (appNameSegment.indexOf(JBOSS_JAR) != -1 && appNameSegment.indexOf(JBOSS_EAR) != -1) {
                appNameSegment = appNameSegment.substring(0, appNameSegment.indexOf(JBOSS_EAR) + JBOSS_EAR_OFFSET);
            }
        } else {
            idx = loaderToString.indexOf(JBOSS_VFSFILE);
            if (idx != -1) {
                appNameSegment = loaderToString.substring(idx + JBOSS_VFSFILE_OFFSET, loaderToString.length() - 2);
            }
        }
        return appNameSegment != null ? new File(appNameSegment).getName() : null;
    }

    private static MapKeyLookupResult getContextMapKeyForJBoss(ClassLoader loader) {
        ClassLoader applicationLoader = loader;
        String archiveFileName = null;
        int i = 0;
        while (i < 20) {
            ClassLoader parent;
            if (SDOHelperContext.jBossClassLoaderHasArchiveFileInfo(loader)) {
                applicationLoader = loader;
            }
            if ((parent = loader.getParent()) == null || parent == loader) {
                archiveFileName = SDOHelperContext.getApplicationNameFromJBossClassLoader(applicationLoader.toString());
                break;
            }
            loader = parent;
            ++i;
        }
        if (archiveFileName != null) {
            return new MapKeyLookupResult(archiveFileName, applicationLoader);
        }
        return new MapKeyLookupResult(applicationLoader);
    }

    private static boolean jBossClassLoaderHasArchiveFileInfo(ClassLoader loader) {
        return loader.toString().indexOf(JBOSS_VFSZIP) != -1 || loader.toString().indexOf(JBOSS_VFSFILE) != -1;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static boolean hasHelperContext(String identifier) {
        WeakHashMap<String, WeakReference<HelperContext>> userSetMap;
        String id = identifier;
        Object appKey = SDOHelperContext.getMapKey();
        ConcurrentMap<String, String> aliasEntries = SDOHelperContext.getAliasMap(appKey);
        if (aliasEntries.containsKey(identifier)) {
            id = (String)aliasEntries.get(identifier);
        }
        if ((userSetMap = userSetHelperContexts.get(appKey)) != null && userSetMap.containsKey(id)) {
            return true;
        }
        ConcurrentHashMap<String, HelperContext> contextMap = helperContexts.get(appKey);
        return contextMap != null && contextMap.containsKey(id);
    }

    public static void addAlias(String identifier, String alias) {
        SDOHelperContext.getAliasMap().put(alias, identifier);
    }

    private static ConcurrentMap<String, String> getAliasMap() {
        return SDOHelperContext.getAliasMap(SDOHelperContext.getMapKey());
    }

    private static ConcurrentMap<String, String> getAliasMap(Object mapKey) {
        ConcurrentHashMap<String, String> existingMap;
        ConcurrentHashMap<String, String> alias = aliasMap.get(mapKey);
        if (alias == null && (existingMap = aliasMap.putIfAbsent(mapKey, alias = new ConcurrentHashMap())) != null) {
            alias = existingMap;
        }
        return alias;
    }

    private Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.getProperties().remove(name);
        } else {
            this.getProperties().put(name, value);
        }
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public boolean isStrictTypeCheckingEnabled() {
        return this.isStrictTypeCheckingEnabled;
    }

    public void setStrictTypeCheckingEnabled(boolean enabled) {
        this.isStrictTypeCheckingEnabled = enabled;
    }

    private static class DefaultHelperContextResolver
    implements HelperContextResolver {
        private DefaultHelperContextResolver() {
        }

        @Override
        public HelperContext getHelperContext(String id, ClassLoader classLoader) {
            LOGGER.fine(String.format("DefaultHelperContextResolver: new HelperContext will be created for id: %s and classLoader: %s", id, classLoader));
            return new SDOHelperContext(id, classLoader);
        }
    }

    public static interface HelperContextResolver {
        public HelperContext getHelperContext(String var1, ClassLoader var2);
    }

    public static class MyNotificationFilter
    extends NotificationFilterSupport {
        MyNotificationFilter() {
            super.enableType(JBOSS_TYPE_STOP);
        }
    }

    private static class MyNotificationListener
    implements NotificationListener {
        int server;
        String appName;

        public MyNotificationListener(int server) {
            this.server = server;
        }

        public MyNotificationListener(String appName, int server) {
            this.server = server;
            this.appName = appName;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            switch (this.server) {
                case 0: {
                    AttributeChangeNotification acn;
                    if (!(notification instanceof AttributeChangeNotification) || !(acn = (AttributeChangeNotification)notification).getAttributeName().equals(SDOHelperContext.WLS_ACTIVE_VERSION_STATE) || !acn.getNewValue().equals(0)) break;
                    SDOHelperContext.resetHelperContext(this.appName);
                    break;
                }
                case 1: {
                    this.appName = SDOHelperContext.getApplicationNameFromJBossClassLoader(((ObjectName)notification.getUserData()).getKeyProperty(JBOSS_ID_KEY));
                    if (!helperContexts.containsKey(this.appName)) break;
                    SDOHelperContext.resetHelperContext(this.appName);
                }
            }
        }
    }

    private static class ReflectionHelperContextResolver
    implements HelperContextResolver {
        private Method method;
        private Object target;

        public ReflectionHelperContextResolver(Object target) {
            this.target = target;
            try {
                this.method = this.findMethod(target.getClass(), "getHelperContext", new Class[]{String.class, ClassLoader.class});
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new IllegalStateException(e);
            }
        }

        private Method findMethod(Class clazz, String methodName, Class[] params) throws PrivilegedActionException, NoSuchMethodException {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, params, true));
            }
            return PrivilegedAccessHelper.getMethod(clazz, methodName, params, true);
        }

        @Override
        public HelperContext getHelperContext(String id, ClassLoader classLoader) {
            try {
                return (HelperContext)this.method.invoke(this.target, id, classLoader);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                return DEFAULT_HCR.getHelperContext(id, classLoader);
            }
        }
    }
}

