/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CachedUpdateCallsQueryClearTest
extends TestCase {
    public CachedUpdateCallsQueryClearTest() {
        this.setDescription("Test that the DescriptorQueryManager's cached update calls query attribute is de-referenced");
    }

    public void setup() {
        this.getDatabaseSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getDatabaseSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getDatabaseSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject(Employee.class, new ExpressionBuilder().get("lastName").equal((Object)"Smitty"));
        CachedUpdateCallsQueryClearTest.assertNotNull((Object)employee);
        employee.setLastName("Archibald");
        uow.commit();
    }

    public void verify() {
        ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        DescriptorQueryManager descriptorQueryManager = descriptor.getDescriptorQueryManager();
        Vector<DatabaseField> fields = new Vector<DatabaseField>(2);
        fields.add(descriptor.getMappingForAttributeName("lastName").getField());
        fields.add(descriptor.getOptimisticLockingPolicy().getWriteLockField());
        Vector cachedUpdateCalls = descriptorQueryManager.getCachedUpdateCalls(fields);
        CachedUpdateCallsQueryClearTest.assertNotNull((Object)cachedUpdateCalls);
        CachedUpdateCallsQueryClearTest.assertFalse((boolean)cachedUpdateCalls.isEmpty());
        for (DatasourceCall call : cachedUpdateCalls) {
            if (call.getQuery() == null) continue;
            throw new TestErrorException("DatasourceCall's query is not null: " + call);
        }
    }

    public void reset() {
        this.getDatabaseSession().rollbackTransaction();
        this.getDatabaseSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

