/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.readonly;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Charity {
    public Number id;
    public String name;
    public int donationsRaised;

    public static Charity greenPeace() {
        Charity example = new Charity();
        example.setName("Green Peace");
        example.donationsRaised = 2000000;
        return example;
    }

    public static Charity redCross() {
        Charity example = new Charity();
        example.setName("Red Cross");
        example.donationsRaised = 20000000;
        return example;
    }

    public static Charity unitedWay() {
        Charity example = new Charity();
        example.setName("United Way");
        example.donationsRaised = 200000000;
        return example;
    }

    public static Vector charities() {
        Vector<Charity> charities = new Vector<Charity>();
        charities.addElement(Charity.greenPeace());
        charities.addElement(Charity.redCross());
        charities.addElement(Charity.unitedWay());
        return charities;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Charity.class);
        descriptor.setTableName("CHARITY");
        descriptor.addPrimaryKeyFieldName("CHARITY_ID");
        descriptor.setSequenceNumberName("CHARITY_SEQ");
        descriptor.setSequenceNumberFieldName("CHARITY_ID");
        descriptor.addDirectMapping("id", "CHARITY_ID");
        descriptor.addDirectMapping("name", "NAME");
        descriptor.addDirectMapping("donationsRaised", "DONATIONS_RAISED");
        return descriptor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Charity other = (Charity)obj;
        return this.getName().equals(other.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("CHARITY");
        definition.addIdentityField("CHARITY_ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 50);
        definition.addField("DONATIONS_RAISED", "INT");
        return definition;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ") ";
    }
}

