/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.beans;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.tools.beans.ExpressionNode;

public class ExpressionTreeModel
implements TreeModel {
    protected ExpressionNode root;

    public ExpressionTreeModel(ExpressionNode expression) {
        this.root = expression;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        if ((parent = ((ExpressionNode)parent).getExpression()) instanceof CompoundExpression) {
            CompoundExpression expression = (CompoundExpression)parent;
            if (index == 0) {
                return new ExpressionNode(expression.getFirstChild());
            }
            if (index == 1) {
                return new ExpressionNode(expression.getSecondChild());
            }
        } else if (parent instanceof FunctionExpression) {
            FunctionExpression expression = (FunctionExpression)parent;
            return new ExpressionNode((Expression)expression.getChildren().elementAt(index));
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if ((parent = ((ExpressionNode)parent).getExpression()) instanceof CompoundExpression) {
            return 2;
        }
        if (parent instanceof FunctionExpression) {
            FunctionExpression expression = (FunctionExpression)parent;
            return expression.getChildren().size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        parent = ((ExpressionNode)parent).getExpression();
        child = ((ExpressionNode)child).getExpression();
        if (parent instanceof CompoundExpression) {
            CompoundExpression expression = (CompoundExpression)parent;
            if (expression.getFirstChild() == child) {
                return 0;
            }
            if (expression.getSecondChild() == child) {
                return 1;
            }
        } else if (parent instanceof FunctionExpression) {
            FunctionExpression expression = (FunctionExpression)parent;
            return expression.getChildren().indexOf(child);
        }
        return 0;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !((node = ((ExpressionNode)node).getExpression()) instanceof CompoundExpression) && !(node instanceof FunctionExpression);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listner) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

