/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.URLArchive;

public class InMemoryArchive
extends URLArchive {
    private InputStream stream = null;

    private InMemoryArchive() {
        super(null, null);
        String persistenceFactoryResource = String.valueOf(InMemoryArchive.class.getName().replace('.', '/')) + ".class";
        URL myURL = InMemoryArchive.class.getClassLoader().getResource(persistenceFactoryResource);
        try {
            myURL = PersistenceUnitProcessor.computePURootURL(myURL, persistenceFactoryResource);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.rootURL = myURL;
    }

    public InMemoryArchive(InputStream stream) {
        this();
        this.stream = stream;
    }

    @Override
    public InputStream getDescriptorStream() throws IOException {
        return this.stream;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.stream.close();
        }
        catch (IOException iOException) {}
        this.stream = null;
    }
}

