/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappedSuperClass;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMRepository;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.w3c.dom.Node;

/**
 * This unit-tests tests the behavior of {@link ExternalORMConfiguration}.
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class ORMConfigurationTests extends AbstractExternalFormTests<ExternalORMConfiguration> {

	public static ORMConfiguration buildExternalForm() throws IOException {
		ORMRepository repository = new ORMRepository();
		return repository.buildORMConfiguration(null, defaultVersion());
	}

	public static ORMDocumentType defaultVersion() {
		return ORMDocumentType.ECLIPELINK_2_6;
	}

	private String buildAccessMethodsTester() {
		return "access-methods";
	}

	private TextNodeTester<ExternalORMConfiguration, AccessType> buildAccessTester() {
		return AccessTypeTests.buildAccessTextNodeTester();
	}

	private TextNodeTester<ExternalORMConfiguration, String> buildCatalogTester() {
		return new TextNodeTester<ExternalORMConfiguration, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return "CATALOG_DEFAULT";
			}
			@Override
			public String getNodeName() {
				return ExternalORMConfiguration.CATALOG;
			}
			@Override
			public String getValue(ExternalORMConfiguration form) {
				return form.getCatalogName();
			}
			@Override
			public String getValue1() {
				return "CATALOG_VALUE_1";
			}
			@Override
			public String getValue2() {
				return "CATALOG_VALUE_2";
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalORMConfiguration form, String value) {
				form.setCatalogName(value);
			}
			@Override
			public String toString(String value) {
				return value;
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalClassConverter, String> buildConverterTester() {
		return ConverterTests.buildConverterTester();
	}

	private TextNodeTester<ExternalORMConfiguration, String> buildDescriptionTester() {
		return new TextNodeTester<ExternalORMConfiguration, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return "default description";
			}
			@Override
			public String getNodeName() {
				return ExternalORMConfiguration.DESCRIPTION;
			}
			@Override
			public String getValue(ExternalORMConfiguration form) {
				return form.getDescription();
			}
			@Override
			public String getValue1() {
				return "testing ORM configuration";
			}
			@Override
			public String getValue2() {
				return "something";
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalORMConfiguration form, String value) {
				form.setDescription(value);
			}
			@Override
			public String toString(String value) {
				return value;
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalEmbeddable, String> buildEmbeddableTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalEmbeddable, String>() {
			@Override
			public ExternalEmbeddable addChild(ExternalORMConfiguration form, String value) {
				return form.addEmbeddable(value);
			}
			@Override
			public ExternalEmbeddable getChild(ExternalORMConfiguration form, int index) {
				return form.getEmbeddable(index);
			}
			@Override
			public ExternalEmbeddable getChildForm(List<ExternalEmbeddable> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalEmbeddable> getChildren(ExternalORMConfiguration form) {
				return form.embeddables();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.embeddablesSize();
			}
			@Override
			public String getChildValue(ExternalEmbeddable childForm) {
				return childForm.getClassName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "org.eclipse.persistence.tools.mappings.Embeddable_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalEmbeddable.EMBEDDABLE;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeEmbeddable(index);
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalEntity, String> buildEntityTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalEntity, String>() {
			@Override
			public ExternalEntity addChild(ExternalORMConfiguration form, String value) {
				return form.addEntity(value);
			}
			@Override
			public ExternalEntity getChild(ExternalORMConfiguration form, int index) {
				return form.getEntity(index);
			}
			@Override
			public ExternalEntity getChildForm(List<ExternalEntity> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalEntity> getChildren(ExternalORMConfiguration form) {
				return form.entities();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.entitiesSize();
			}
			@Override
			public String getChildValue(ExternalEntity childForm) {
				return childForm.getClassName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "org.eclipse.persistence.tools.mappings.Entity_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalEntity.ENTITY;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeEntity(index);
			}
		};
	}

	private String buildHashPartitioningTester() {
		return "hash-partitioning";
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalMappedSuperClass, String> buildMappedSuperclassTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalMappedSuperClass, String>() {
			@Override
			public ExternalMappedSuperClass addChild(ExternalORMConfiguration form, String value) {
				return form.addMappedSuperClass(value);
			}
			@Override
			public ExternalMappedSuperClass getChild(ExternalORMConfiguration form, int index) {
				return form.getMappedSuperClass(index);
			}
			@Override
			public ExternalMappedSuperClass getChildForm(List<ExternalMappedSuperClass> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalMappedSuperClass> getChildren(ExternalORMConfiguration form) {
				return form.mappedSuperClasses();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.mappedSuperClassesSize();
			}
			@Override
			public String getChildValue(ExternalMappedSuperClass childForm) {
				return childForm.getClassName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "org.eclipse.persistence.tools.mappings.MappedSuperclass_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalMappedSuperClass.MAPPED_SUPERCLASS;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeMappedSuperClass(index);
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalNativeQuery, String> buildNamedNativeQueryTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalNativeQuery, String>() {
			@Override
			public ExternalNativeQuery addChild(ExternalORMConfiguration form, String value) {
				return form.addNamedNativeQuery(value);
			}
			@Override
			public ExternalNativeQuery getChild(ExternalORMConfiguration form, int index) {
				return form.getNamedNativeQuery(index);
			}
			@Override
			public ExternalNativeQuery getChildForm(List<ExternalNativeQuery> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalNativeQuery> getChildren(ExternalORMConfiguration form) {
				return form.namedNativeQueries();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.namedNativeQueriesSize();
			}
			@Override
			public String getChildValue(ExternalNativeQuery childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "NAMED_NATIVE_QUERY_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalNativeQuery.NAMED_NATIVE_QUERY;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeNativeQuery(index);
			}
		};
	}

	private String buildNamedPlsqlStoredFunctionQueryTester() {
		return "named-plsql-stored-function-query";
	}

	private String buildNamedPlsqlStoredProcedureQueryTester() {
		return "named-plsql-stored-procedure-query";
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalBasicNamedQuery, String> buildNamedQueryTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalBasicNamedQuery, String>() {
			@Override
			public ExternalBasicNamedQuery addChild(ExternalORMConfiguration form, String value) {
				return form.addNamedQuery(value);
			}
			@Override
			public ExternalBasicNamedQuery getChild(ExternalORMConfiguration form, int index) {
				return form.getNamedQuery(index);
			}
			@Override
			public ExternalBasicNamedQuery getChildForm(List<ExternalBasicNamedQuery> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalBasicNamedQuery> getChildren(ExternalORMConfiguration form) {
				return form.namedQueries();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.namedQueriesSize();
			}
			@Override
			public String getChildValue(ExternalBasicNamedQuery childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "NAMED_QUERY_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalBasicNamedQuery.NAMED_QUERY;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeNamedQuery(index);
			}
		};
	}

	private String buildNamedStoredFunctionQueryTester() {
		return "named-stored-function-query";
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalNamedStoredProcedureQuery, String> buildNamedStoredProcedureQueryTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalNamedStoredProcedureQuery, String>() {
			@Override
			public ExternalNamedStoredProcedureQuery addChild(ExternalORMConfiguration form, String value) {
				return form.addNamedStoredProcedureQuery(value);
			}
			@Override
			public ExternalNamedStoredProcedureQuery getChild(ExternalORMConfiguration form, int index) {
				return form.getNamedStoredProcedureQuery(index);
			}
			@Override
			public ExternalNamedStoredProcedureQuery getChildForm(List<ExternalNamedStoredProcedureQuery> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalNamedStoredProcedureQuery> getChildren(ExternalORMConfiguration form) {
				return form.storedProcedureQueries();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.storedProcedureQueriesSize();
			}
			@Override
			public String getChildValue(ExternalNamedStoredProcedureQuery childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "NAMED_STORED_PROCEDURE_QUERY_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalNamedStoredProcedureQuery.NAMED_STORED_PROCEDURE_QUERY;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeStoredProcedureQuery(index);
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalObjectTypeConverter, String> buildObjectTypeConverterTester() {
		return ConverterTests.buildObjectTypeConverterTester();
	}

	private String buildOracleArrayTester() {
		return "oracle-array";
	}

	private String buildOracleObjectTester() {
		return "oracle-object";
	}

	private ExternalFormBuilder<ORMConfiguration> buildORMConfigurationBuilder() {
		return new ExternalFormBuilder<ORMConfiguration>() {
			@Override
			public ORMConfiguration buildExternalForm() throws IOException {
				return ORMConfigurationTests.buildExternalForm();
			}
			@Override
			public ORMConfiguration buildExternalForm(ExternalForm parentForm) {
				return null;
			}
			@Override
			public int getDefaultAttributeCount() {
				return 4;
			}
			@Override
			public Node getNode(ORMConfiguration form) {
				return form.getElement();
			}
			@Override
			public String getNodeName() {
				return ORMConfiguration.ENTITY_MAPPINGS;
			}
			@Override
			public List<String> getTreeNodeNames() {
				return Collections.singletonList(getNodeName());
			}
		};
	}

	private TextNodeTester<ExternalORMConfiguration, String> buildPackageTester() {
		return new TextNodeTester<ExternalORMConfiguration, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return "org.eclipse.persistence";
			}
			@Override
			public String getNodeName() {
				return ExternalORMConfiguration.PACKAGE;
			}
			@Override
			public String getValue(ExternalORMConfiguration form) {
				return form.getPackageName();
			}
			@Override
			public String getValue1() {
				return "org.test";
			}
			@Override
			public String getValue2() {
				return "java.io";
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalORMConfiguration form, String value) {
				form.setPackageName(value);
			}
			@Override
			public String toString(String value) {
				return value;
			}
		};
	}

	private String buildPartitioningTester() {
		return "partitioning";
	}

	private ChildNodeTester<ExternalORMConfiguration, ExternalPersistenceUnit> buildPersistenceUnitMetadataTester() {
		return new ChildNodeTester<ExternalORMConfiguration, ExternalPersistenceUnit>() {
			@Override
			public ExternalPersistenceUnit addChild(ExternalORMConfiguration form) {
				return form.addPersistenceUnitMetaData();
			}
			@Override
			public ExternalPersistenceUnit getChild(ExternalORMConfiguration form) {
				return form.getPersistenceUnitMetaData();
			}
			@Override
			public String getNodeName() {
				return ExternalPersistenceUnit.PERSISTENCE_UNIT_METADATA;
			}
			@Override
			public boolean hasChild(ExternalORMConfiguration form) {
				return form.hasPersistenceUnitMetaData();
			}
			@Override
			public void removeChild(ExternalORMConfiguration form) {
				form.removePersistenceUnitMetaData();
			}
		};
	}

	private String buildPinnedPartitioningTester() {
		return "pinned-partitioning";
	}

	private String buildPlsqlRecordTester() {
		return "plsql-record";
	}

	private String buildPlsqlTableTester() {
		return "plsql-table";
	}

	private String buildRangePartitioningTester() {
		return "range-partitioning";
	}

	private String buildReplicationPartitioningTester() {
		return "replication-partitioning";
	}

	private String buildRoundRobinPartitioningTester() {
		return "round-robin-partitioning";
	}

	private TextNodeTester<ExternalORMConfiguration, String> buildSchemaTester() {
		return new TextNodeTester<ExternalORMConfiguration, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return "SCHEMA_DEFAULT";
			}
			@Override
			public String getNodeName() {
				return ExternalORMConfiguration.SCHEMA;
			}
			@Override
			public String getValue(ExternalORMConfiguration form) {
				return form.getSchemaName();
			}
			@Override
			public String getValue1() {
				return "HR";
			}
			@Override
			public String getValue2() {
				return "eclipselink";
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalORMConfiguration form, String value) {
				form.setSchemaName(value);
			}
			@Override
			public String toString(String value) {
				return value;
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalSequenceGenerator, String> buildSequenceGeneratorTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalSequenceGenerator, String>() {
			@Override
			public ExternalSequenceGenerator addChild(ExternalORMConfiguration form, String value) {
				return form.addSequenceGenerator(value);
			}
			@Override
			public ExternalSequenceGenerator getChild(ExternalORMConfiguration form, int index) {
				return form.getSequenceGenerator(index);
			}
			@Override
			public ExternalSequenceGenerator getChildForm(List<ExternalSequenceGenerator> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalSequenceGenerator> getChildren(ExternalORMConfiguration form) {
				return form.sequenceGenerators();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.sequenceGeneratorsSize();
			}
			@Override
			public String getChildValue(ExternalSequenceGenerator childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "SEQUENCE_GENERATOR_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalSequenceGenerator.SEQUENCE_GENERATOR;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeSequenceGenerator(index);
			}
		};
	}

	private String buildSerializedConverterTester() {
		return "serialized-converter";
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalSQLResultSetMapping, String> buildSqlResultSetMappingTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalSQLResultSetMapping, String>() {
			@Override
			public ExternalSQLResultSetMapping addChild(ExternalORMConfiguration form, String value) {
				return form.addSqlResultSetMapping(value);
			}
			@Override
			public ExternalSQLResultSetMapping getChild(ExternalORMConfiguration form, int index) {
				return form.getSqlResultSetMapping(index);
			}
			@Override
			public ExternalSQLResultSetMapping getChildForm(List<ExternalSQLResultSetMapping> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalSQLResultSetMapping> getChildren(ExternalORMConfiguration form) {
				return form.sqlResultSetMappings();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.sqlResultSetMappingsSize();
			}
			@Override
			public String getChildValue(ExternalSQLResultSetMapping childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "SQL_RESULT_SET_MAPPING_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalSQLResultSetMapping.SQL_RESULT_SET_MAPPING;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeSqlResultSetMapping(index);
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalStructConverter, String> buildStructConverterTester() {
		return ConverterTests.buildStructConverterTester();
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalTableGenerator, String> buildTableGeneratorTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalTableGenerator, String>() {
			@Override
			public ExternalTableGenerator addChild(ExternalORMConfiguration form, String value) {
				return form.addTableGenerator(value);
			}
			@Override
			public ExternalTableGenerator getChild(ExternalORMConfiguration form, int index) {
				return form.getTableGenerator(index);
			}
			@Override
			public ExternalTableGenerator getChildForm(List<ExternalTableGenerator> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalTableGenerator> getChildren(ExternalORMConfiguration form) {
				return form.tableGenerators();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.tableGeneratorsSize();
			}
			@Override
			public String getChildValue(ExternalTableGenerator childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "TABLE_GENERATOR_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalTableGenerator.TABLE_GENERATOR;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeTableGenerator(index);
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalTenantDiscriminatorColumn, String> buildTenantDiscriminatorColumnTester() {
		return new ChildListNodeTester<ExternalORMConfiguration, ExternalTenantDiscriminatorColumn, String>() {
			@Override
			public ExternalTenantDiscriminatorColumn addChild(ExternalORMConfiguration form, String value) {
				ExternalTenantDiscriminatorColumn column = form.addDiscriminatorColumn();
				column.setName(value);
				return column;
			}
			@Override
			public ExternalTenantDiscriminatorColumn getChild(ExternalORMConfiguration form, int index) {
				return form.getDiscriminatorColumn(index);
			}
			@Override
			public ExternalTenantDiscriminatorColumn getChildForm(List<ExternalTenantDiscriminatorColumn> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalTenantDiscriminatorColumn> getChildren(ExternalORMConfiguration form) {
				return form.discriminatorColumns();
			}
			@Override
			public int getChildrenSize(ExternalORMConfiguration form) {
				return form.discriminatorColumnSize();
			}
			@Override
			public String getChildValue(ExternalTenantDiscriminatorColumn childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return Integer.toString(index);
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalTenantDiscriminatorColumn.TENANT_DISCRIMINATOR_COLUMN;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(ExternalORMConfiguration form, int index) {
				form.removeDiscriminatorColumn(index);
			}
		};
	}

	private ChildListNodeTester<ExternalORMConfiguration, ExternalTypeConverter, String> buildTypeConverterTester() {
		return ConverterTests.buildTypeConverterTester();
	}

	private String buildUnionPartitioningTester() {
		return "union-partitioning";
	}

	private String buildUuidGeneratorTester() {
		return "uuid-generator";
	}

	private String buildValuePartitioningTester() {
		return "value-partitioning";
	}

	private AttributeNodeTester<ExternalORMConfiguration, ORMDocumentType> buildVersionTester() {
		return new AttributeNodeTester<ExternalORMConfiguration, ORMDocumentType>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return true;
			}
			@Override
			public ORMDocumentType getDefaultValue() {
				return defaultVersion();
			}
			@Override
			public String getNodeName() {
				return ORMConfiguration.XSD_VERSION;
			}
			@Override
			public ORMDocumentType getValue(ExternalORMConfiguration form) {
				return form.getDocumentType();
			}
			@Override
			public ORMDocumentType getValue1() {
				return ORMDocumentType.ECLIPELINK_2_2;
			}
			@Override
			public ORMDocumentType getValue2() {
				return ORMDocumentType.JPA_1_0;
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return false;
			}
			@Override
			public void setValue(ExternalORMConfiguration form, ORMDocumentType value) {
				form.setDocumentType(value);
			}
			@Override
			public String toString(ORMDocumentType value) {
				return value.getVersion();
			}
		};
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void populate(RootNodeTester tester) {

		tester.setBuilder(buildORMConfigurationBuilder());

		// Attributes
		tester.addAttribute(buildVersionTester());

		// Child nodes
		tester.addTextNode(buildDescriptionTester());
		tester.addNode(buildPersistenceUnitMetadataTester());
		tester.addTextNode(buildPackageTester());
		tester.addTextNode(buildSchemaTester());
		tester.addTextNode(buildCatalogTester());
		tester.addTextNode(buildAccessTester());
		tester.addUnsupportedNode(buildAccessMethodsTester());                  // EclipseLink
		tester.addListNodes(buildTenantDiscriminatorColumnTester());            // EclipseLink
		tester.addListNodes(buildConverterTester());                            // EclipseLink : mixed converter
		tester.addListNodes(buildTypeConverterTester());                        // EclipseLink
		tester.addListNodes(buildObjectTypeConverterTester());                  // EclipseLink
		tester.addUnsupportedNode(buildSerializedConverterTester());            // EclipseLink
		tester.addListNodes(buildStructConverterTester());                      // EclipseLink
		tester.addListNodes(buildSequenceGeneratorTester());
		tester.addListNodes(buildTableGeneratorTester());
		tester.addUnsupportedNode(buildUuidGeneratorTester());                  // EclipseLink
		tester.addUnsupportedNode(buildPartitioningTester());                   // EclipseLink
		tester.addUnsupportedNode(buildReplicationPartitioningTester());        // EclipseLink
		tester.addUnsupportedNode(buildRoundRobinPartitioningTester());         // EclipseLink
		tester.addUnsupportedNode(buildPinnedPartitioningTester());             // EclipseLink
		tester.addUnsupportedNode(buildRangePartitioningTester());              // EclipseLink
		tester.addUnsupportedNode(buildValuePartitioningTester());              // EclipseLink
		tester.addUnsupportedNode(buildHashPartitioningTester());               // EclipseLink
		tester.addUnsupportedNode(buildUnionPartitioningTester());              // EclipseLink
		tester.addListNodes(buildNamedQueryTester());
		tester.addListNodes(buildNamedNativeQueryTester());
		tester.addListNodes(buildNamedStoredProcedureQueryTester());
		tester.addUnsupportedNode(buildNamedStoredFunctionQueryTester());       // EclipseLink
		tester.addUnsupportedNode(buildNamedPlsqlStoredProcedureQueryTester()); // EclipseLink
		tester.addUnsupportedNode(buildNamedPlsqlStoredFunctionQueryTester());  // EclipseLink
		tester.addUnsupportedNode(buildOracleObjectTester());                   // EclipseLink
		tester.addUnsupportedNode(buildOracleArrayTester());                    // EclipseLink
		tester.addUnsupportedNode(buildPlsqlRecordTester());                    // EclipseLink
		tester.addUnsupportedNode(buildPlsqlTableTester());                     // EclipseLink
		tester.addListNodes(buildSqlResultSetMappingTester());
		tester.addListNodes(buildMappedSuperclassTester());
		tester.addListNodes(buildEntityTester());
		tester.addListNodes(buildEmbeddableTester());
//		tester.addListNodes(buildConverterTester());                            // Generic JPA, we'll assume EclipseLink
	}
}