/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import org.eclipse.persistence.tools.mapping.orm.ExternalConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;

/**
 * This unit-tests tests the behavior of {@link ExternalConvertibleMappingg}.
 *
 * @version 2.6
 */
public abstract class ConvertibleMappingTests<T extends ExternalConvertibleMapping> extends NonTriensientMappingTests<T> {

	final ChildNodeTester<?, ?>[] buildConverterChoiceTester() {
		return new ChildNodeTester<?, ?>[] {
			buildConverterTester(),
			buildTypeConverterTester(),
			buildObjectTypeConverterTester(),
			buildSerializedConverterTester(),
			buildStructConverterTester()
		};
	}

	private ChildNodeTester<T, ExternalConverter> buildConverterTester() {
		return null;
	}

	final TextNodeTester<T, String> buildConvertTester() {
		return new TextNodeTester<T, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return null;
			}
			@Override
			public String getNodeName() {
				return null;
			}
			@Override
			public String getValue(T form) {
				return null;
			}
			@Override
			public String getValue1() {
				return null;
			}
			@Override
			public String getValue2() {
				return null;
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return false;
			}
			@Override
			public void setValue(T form, String value) {
			}
			@Override
			public String toString(String value) {
				return null;
			}
		};
	}

	private ChildNodeTester<T, ExternalObjectTypeConverter> buildObjectTypeConverterTester() {
		return null;
	}

	private ChildNodeTester<T, ?> buildSerializedConverterTester() {
		return null;
	}

	private ChildNodeTester<T, ExternalStructConverter> buildStructConverterTester() {
		return null;
	}

	private ChildNodeTester<T, ExternalTypeConverter> buildTypeConverterTester() {
		return null;
	}
}