/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.w3c.dom.Node;

/**
 * This unit-tests tests the behavior of {@link ExternalAccessMethods}.
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class AccessMethodsTests extends AbstractExternalFormTests<ExternalAccessMethods> {

	static <T extends ExternalEmbeddable> ChildNodeTester<T, ExternalAccessMethods> buildAccessMethodsTester() {
		return new ChildNodeTester<T, ExternalAccessMethods>() {
			@Override
			public ExternalAccessMethods addChild(T form) {
				return form.addAccessMethods(null, null);
			}
			@Override
			public ExternalAccessMethods getChild(T form) {
				return form.getAccessMethods();
			}
			@Override
			public String getNodeName() {
				return ExternalAccessMethods.ACCESS_METHODS;
			}
			@Override
			public boolean hasChild(T form) {
				return form.hasAccessMethods();
			}
			@Override
			public void removeChild(T form) {
				form.removeAccessMethods();
			}
		};
	}

	private ExternalFormBuilder<ExternalAccessMethods> buildEmbeddableAccessMethodsBuilder() {
		return new ExternalFormBuilder<ExternalAccessMethods>() {
			@Override
			public ExternalAccessMethods buildExternalForm() throws IOException {
				ExternalORMConfiguration orm = ORMConfigurationTests.buildExternalForm();
				ExternalEmbeddable embeddable = orm.addEmbeddable("org.test.MyEmbeddable");
				return embeddable.addAccessMethods(null, null);
			}
			@Override
			public ExternalAccessMethods buildExternalForm(ExternalForm parentForm) {
				return ((ExternalEmbeddable) parentForm).addAccessMethods(null, null);
			}
			@Override
			public int getDefaultAttributeCount() {
				return 0;
			}
			@Override
			public Node getNode(ExternalAccessMethods form) {
				return ObjectTools.execute(form, "getElement");
			}
			@Override
			public String getNodeName() {
				return ExternalAccessMethods.ACCESS_METHODS;
			}
			@Override
			public List<String> getTreeNodeNames() {
				return ListTools.list(
					ExternalORMConfiguration.ENTITY_MAPPINGS,
					ExternalEmbeddable.EMBEDDABLE,
					ExternalAccessMethods.ACCESS_METHODS
				);
			}
		};
	}

	private AttributeNodeTester<ExternalAccessMethods, String> buildGetMethodTester() {
		return new AttributeNodeTester<ExternalAccessMethods, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return "GET_METHOD_0";
			}
			@Override
			public String getNodeName() {
				return ExternalAccessMethods.GET_METHOD;
			}
			@Override
			public String getValue(ExternalAccessMethods form) {
				return form.getGetMethod();
			}
			@Override
			public String getValue1() {
				return "GET_METHOD_1";
			}
			@Override
			public String getValue2() {
				return "GET_METHOD_2";
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalAccessMethods form, String value) {
				form.setGetMethod(value);
			}
			@Override
			public String toString(String value) {
				return value;
			}
		};
	}

	private AttributeNodeTester<ExternalAccessMethods, String> buildSetMethodTester() {
		return new AttributeNodeTester<ExternalAccessMethods, String>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public String getDefaultValue() {
				return "SET_METHOD_0";
			}
			@Override
			public String getNodeName() {
				return ExternalAccessMethods.SET_METHOD;
			}
			@Override
			public String getValue(ExternalAccessMethods form) {
				return form.getSetMethod();
			}
			@Override
			public String getValue1() {
				return "SET_METHOD_1";
			}
			@Override
			public String getValue2() {
				return "SET_METHOD_2";
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalAccessMethods form, String value) {
				form.setSetMethod(value);
			}
			@Override
			public String toString(String value) {
				return value;
			}
		};
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void populate(RootNodeTester tester) {

		tester.setBuilder(buildEmbeddableAccessMethodsBuilder());

		tester.addAttribute(buildGetMethodTester());
		tester.addAttribute(buildSetMethodTester());
	}
}