/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterable;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.EmptyIterable;
import org.eclipse.persistence.tools.utility.tests.TestTools;


@SuppressWarnings("nls")
public class EmptyIterableTests extends TestCase {

	public EmptyIterableTests(String name) {
		super(name);
	}

	public void testIterator() {
		for (String s : EmptyIterable.<String>instance()) {
			fail("bogus element: " + s);
		}
	}

	public void testToString() {
		assertNotNull(EmptyIterable.instance().toString());
	}

	public void testSerialization() throws Exception {
		Iterable<String> iterable = EmptyIterable.instance();
		assertSame(iterable, TestTools.serialize(iterable));
	}
}