/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.nosql.mongo.meta;

/**
 * This class describes the metadata of an abstract representation of a MongoDB 
 * column.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 * 
 * @author John Bracken
 * @version 2.6
 */
public abstract class ColumnDescriptor {
	
	/** Name of the column */
	private String columnName;
	
	/** Defines whether this column is a list type */ 
	private boolean isList;
	
	/**
	 * Constructor.
	 * 
	 * @param columName name of the column.
	 */
	public ColumnDescriptor(String columName) {
		super();
		this.columnName = columName;
	}
	
	/**
	 * Returns the name of the column.
	 * 
	 * @return the name of the column.
	 */
	public String getColumnName() {
		return columnName;
	}
	
	/**
	 * Indicates whether this column is a list
	 * type (e.g. has multiple elements in it's value).
	 * 
	 * @return whether this column is a list.
	 */
	public boolean isList() {
		return this.isList;
	}
	
	/**
	 * Sets whether this column is a list
	 * type (e.g. has multiple elements in it's value).
	 * 
	 * @param isList is this column a list type.
	 */
	public void setList(boolean isList) {
		this.isList = isList;
	}
}