/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalOrderColumn;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a order column, which is a child of an element collection mapping.
 *
 * @see ElementCollectionMapping
 *
 * @version 2.6
 */
final class OrderColumn extends AbstractColumn
                        implements ExternalOrderColumn {

	/**
	 * Creates a new <code>OrderColumn</code>.
	 *
	 * @param parent The parent of this external form
	 */
	OrderColumn(AbstractExternalForm parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(NULLABLE);
		names.add(INSERTABLE);
		names.add(UPDATABLE);
		names.add(COLUMN_DEFINITION);
		names.add(CONTIGUOUS);
		names.add(BASE);
		names.add(TABLE);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getBase() {
		return getIntegerAttribute(BASE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getBaseTextRange() {
		return getAttributeTextRange(BASE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getContiguousTextRange() {
		return getAttributeTextRange(CONTIGUOUS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return ORDER_COLUMN;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isContiguous() {
		return getBooleanAttribute(CONTIGUOUS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeColumn() {
		removeSelf();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setBase(Integer base) {
		setAttribute(BASE, base);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setContiguous(Boolean contiguous) {
		setAttribute(CONTIGUOUS, contiguous);
	}
}