/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalCloneCopyPolicy;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a clone copy policy, which is a child of an entity.
 *
 * @see EmbeddableEntity
 *
 * @version 2.6
 */
final class CloneCopyPolicy extends AbstractExternalForm
                            implements ExternalCloneCopyPolicy {

	/**
	 * Creates a new <code>CloneCopyPolicy</code>.
	 *
	 * @param parent The parent of this external form
	 */
	CloneCopyPolicy(Embeddable parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(METHOD);
		names.add(WORKING_COPY_METHOD);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return CLONE_COPY_POLICY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getMethod() {
		return getAttribute(METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getMethodTextRange() {
		return getAttributeTextRange(METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWorkingCopyMethod() {
		return getAttribute(WORKING_COPY_METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getWorkingCopyMethodTextRange() {
		return getAttributeTextRange(WORKING_COPY_METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMethod(String methodName) {
		setAttribute(METHOD, methodName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWorkingCopyMethod(String workingCopyMethodName) {
		setAttribute(WORKING_COPY_METHOD, workingCopyMethodName);
	}
}