/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a stored
 * procedure parameter in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.StoredProcedureQuery
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalStoredProcedureParameter extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the direction property.
	 */
	String DIRECTION = "direction";

	/**
	 * The attribute name used to store and retrieve the jdbc-type property.
	 */
	String JDBC_TYPE = "jdbc-type";

	/**
	 * The attribute name used to store and retrieve the jdbc-type-name property.
	 */
	String JDBC_TYPE_NAME = "jdbc-type-name";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the query-parameter property.
	 */
	String QUERY_PARAMETER = "query-parameter";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String STORED_PROCEDURE_PARAMETER = "parameter";

	/**
	 * The attribute name used to store and retrieve the type property.
	 */
	String TYPE = "type";

	/**
	 * Returns the direction type for this parameter.
	 */
	Direction getDirection();

	/**
	 * Returns the {@link TextRange} for the direction type value.
	 */
	TextRange getDirectionTextRange();

	@Deprecated
	int getIndex();

	/**
	 * Returns the jdbc type of this parameter.
	 */
	Integer getJdbcType();

	/**
	 * Returns the jdbc type name for this parameter.
	 */
	String getJdbcTypeName();

	/**
	 * Returns the {@link TextRange} for the jdbc type name value.
	 */
	TextRange getJdbcTypeNameTextRange();

	/**
	 * Returns the {@link TextRange} for the jdbc type.
	 */
	TextRange getJdbcTypeTextRange();

	/**
	 * Returns the name of this parameter.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name value.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the query parameter for this parameter.
	 */
	String getQueryParameter();

	/**
	 * Returns the {@link TextRange} for the query parameter value.
	 */
	TextRange getQueryParameterTextRange();

	/**
	 * Returns the type name for this parameter.
	 */
	String getType();

	/**
	 * Returns the {@link TextRange} for the type name value.
	 */
	TextRange getTypeTextRange();

	/**
	 * Sets the direction type for this parameter.
	 */
	void setDirection(Direction directionType);

	/**
	 * Sets the jdbc type for this parameter.
	 */
	void setJdbcType(Integer jdbcType);

	/**
	 * Sets the jdbc type name for this parameter.
	 */
	void setJdbcTypeName(String jdbcTypeName);

	/**
	 * Sets the name of this parameter.
	 */
	void setName(String name);

	/**
	 * Sets the query parameter name for this parameter.
	 */
	void setQueryParameter(String queryParameterName);

	/**
	 * Sets the type name for this parameter.
	 */
	void setType(String typeName);
}