/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface describes the core definition of what an order column is as defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalOrderColumn extends ExternalBasicColumn {

	/**
	 * The attribute name used to store and retrieve the base property.
	 */
	String BASE = "base";

	/**
	 * The attribute name used to store and retrieve the contiguous property.
	 */
	String CONTIGUOUS = "contiguous";

	/**
	 * The attribute name used to store and retrieve the primary-key of the property.
	 */
	String ORDER_COLUMN = "order-column";

	/**
	 * Returns the base for this column.
	 */
	Integer getBase();

	/**
	 * Returns the {@link TextRange for the base value.
	 */
	TextRange getBaseTextRange();

	/**
	 * Returns the {@link TextRange} for the contiguous value.
	 */
	TextRange getContiguousTextRange();

	/**
	 * Indicates whether this column is contiguous.
	 */
	Boolean isContiguous();

	/**
	 * Removes all metadata associated with this column from the the external form.
	 */
	void removeColumn();

	/**
	 * Returns the base for this column.
	 */
	void setBase(Integer base);

	/**
	 * Sets the boolean value of whether the column is contiguous.
	 */
	void setContiguous(Boolean unique);
}