/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior define properties associated with "mappable" mappings that
 * can be enumerated in the ORM xml. Mappable in this case means, that a mapping can designate
 * another mapping for its mapping specific meta data.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalMappableMapping extends ExternalRelationshipMapping {

	/**
	 * The attribute name used to store and retrieve the mapped-by property.
	 */
	String MAPPED_BY = "mapped-by-id";

	/**
	 * Returns TODO.
	 */
	String getMappedByMappingName();

	/**
	 * Returns the {@link TextRange} for the mapped by mapping name value.
	 */
	TextRange getMappedByMappingNameTextRange();

	/**
	 * Sets the name TODO.
	 */
	void setMappedByMappingName(String name);
}