/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;

/**
 * This interface and inherited behavior describe the configurable properties defined for a join
 * table in the ORM xml. A join table may be used in relationship mappings.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.JoinTable
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
public interface ExternalJoinTable extends ExternalReferenceTable {

	/**
	 * Adds a inverse join column with the given name.
	 */
	ExternalJoinColumn addInverseJoinColumn(String name);

	/**
	 * Returns the join column at the specified position.
	 */
	ExternalJoinColumn getInverseJoinColumn(int index);

	/**
	 * Returns a list of inverse join columns used in this join table definition.
	 */
	List<ExternalJoinColumn> inverseJoinColumns();

	/**
	 * Returns the count of inverse join columns used in this join table definition.
	 */
	int inverseJoinColumnsSize();

	/**
	 * Removes the inverse join column at the given position.
	 */
	void removeInverseJoinColumn(int index);
}