/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;

/**
 * This interface and inherited describes the configurable properties for an embedded ID mapping. An
 * embedded ID mapping is used to describe the paths to fields on an embedded mapping and can be
 * defined in a regular.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.EmbeddedId
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalEmbeddedIDMapping extends ExternalNonTransientMapping {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String EMBEDDED_ID = "embedded-id";

	/**
	 * Visits this {@link ExternalEmbeddedIDMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds a override with the given name.
	 */
	ExternalAttributeOverride addAttributeOverride(String name);

	/**
	 * Returns a list of overridden column mappings for embedded fields.
	 */
	List<ExternalAttributeOverride> attributeOverrides();

	/**
	 * Returns the count of overridden column mappings for embedded fields.
	 */
	int attributeOverridesSize();

	/**
	 * Removes the override named.
	 */
	void removeAttributeOverride(int index);
}