/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for an conversion
 * value. One or more conversion values can be declared as part of an object type converter.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.ConversionValue
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalConversionValue extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String CONVERSION_VALUE = "conversion-value";

	/**
	 * The attribute name used to store and retrieve the data-value property.
	 */
	String DATA_VALUE = "data-value";

	/**
	 * The attribute name used to store and retrieve the object-value property.
	 */
	String OBJECT_VALUE = "object-value";

	/**
	 * Returns the data value for this conversion.
	 */
	String getDataValue();

	/**
	 * Returns the {@link TextRange} for the data value for this conversion.
	 */
	TextRange getDataValueTextRange();

	@Deprecated
	int getIndex();

	/**
	 * Returns the object value for this conversion.
	 */
	String getObjectValue();

	/**
	 * Returns the {@link TextRange} for the object value for this conversion.
	 */
	TextRange getObjectValueTextRange();

	/**
	 * Sets the data value for this conversion.
	 */
	void setDataValue(String value);

	/**
	 * Sets the object value for this conversion.
	 */
	void setObjectValue(String value);
}