/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This enumeration defines the entity access types supported extending {@link javax.persistence.AccessType}
 * to include VIRTUAL for dynamic entities.
 *
 * @version 2.6
 */
public enum AccessType {

	/**
	 * Constant used to specify field access type.
	 */
	FIELD,

	/**
	 * Constant used to specify property access type.
	 */
	PROPERTY,

	/**
	 * Constant used to specify virtual access type.
	 */
	VIRTUAL
}