/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.db;

import java.util.EventListener;

/**
 * A <code>ConnectionListener</code> is notified of any changes to a connection.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @see org.eclipse.datatools.connectivity.IManagedConnectionListener
 * @version 2.6
 */
public interface ConnectionListener extends EventListener {

	void opened(ConnectionProfile profile);
	void modified(ConnectionProfile profile);
	boolean okToClose(ConnectionProfile profile);
	void aboutToClose(ConnectionProfile profile);
	void closed(ConnectionProfile profile);

	void databaseChanged(ConnectionProfile profile, Database database);
	void catalogChanged(ConnectionProfile profile, Catalog catalog);
	void schemaChanged(ConnectionProfile profile, Schema schema);
	void sequenceChanged(ConnectionProfile profile, Sequence sequence);
	void tableChanged(ConnectionProfile profile, Table table);
	void columnChanged(ConnectionProfile profile, Column column);
	void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey);
}