/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;

public class ClassToolsTests
extends TestCase {
    private static String testStaticField;

    public ClassToolsTests(String name) {
        super(name);
    }

    public void testAllFields() {
        int fieldCount = 0;
        fieldCount += Vector.class.getDeclaredFields().length;
        fieldCount += AbstractList.class.getDeclaredFields().length;
        fieldCount += AbstractCollection.class.getDeclaredFields().length;
        Iterable fields = ClassTools.allFields(Vector.class);
        ClassToolsTests.assertEquals((int)(fieldCount += Object.class.getDeclaredFields().length), (int)IterableTools.size((Iterable)fields));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"modCount"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"serialVersionUID"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"capacityIncrement"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"elementCount"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"elementData"));
        ClassToolsTests.assertTrue((boolean)((Field)fields.iterator().next()).isAccessible());
    }

    public void testAllMethods() {
        int methodCount = 0;
        methodCount += Vector.class.getDeclaredMethods().length;
        methodCount += AbstractList.class.getDeclaredMethods().length;
        methodCount += AbstractCollection.class.getDeclaredMethods().length;
        Iterable methods = ClassTools.allMethods(Vector.class);
        ClassToolsTests.assertEquals((int)(methodCount += Object.class.getDeclaredMethods().length), (int)IterableTools.size((Iterable)methods));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.methodNames(methods), (Object)"wait"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.methodNames(methods), (Object)"addElement"));
        ClassToolsTests.assertTrue((boolean)((Method)methods.iterator().next()).isAccessible());
    }

    public void testNewInstanceClass() {
        Vector v = (Vector)ClassTools.newInstance(Vector.class);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
    }

    public void testNewInstanceClassClassObject() {
        int initialCapacity = 200;
        Vector v = (Vector)ClassTools.newInstance(Vector.class, Integer.TYPE, (Object)new Integer(initialCapacity));
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ObjectTools.get((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassArrayObjectArray() {
        boolean exCaught;
        block4: {
            int initialCapacity = 200;
            Class[] parmTypes = new Class[]{Integer.TYPE};
            Object[] parms = new Object[]{new Integer(initialCapacity)};
            Vector v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
            ClassToolsTests.assertNotNull((Object)v);
            ClassToolsTests.assertEquals((int)0, (int)v.size());
            Object[] elementData = (Object[])ObjectTools.get((Object)v, (String)"elementData");
            ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
            parms[0] = new Integer(-1);
            exCaught = false;
            try {
                v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
            ClassToolsTests.assertTrue((String)"RuntimeException not thrown", (boolean)exCaught);
            parmTypes[0] = String.class;
            parms[0] = "foo";
            exCaught = false;
            try {
                v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block4;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((String)"NoSuchMethodException not thrown", (boolean)exCaught);
    }

    public void testExecuteClassString() {
        Double randomObject = (Double)ClassTools.execute(Math.class, (String)"random");
        ClassToolsTests.assertNotNull((Object)randomObject);
        double random = randomObject;
        ClassToolsTests.assertTrue((random >= 0.0 ? 1 : 0) != 0);
        ClassToolsTests.assertTrue((random < 1.0 ? 1 : 0) != 0);
    }

    public void testExecuteClassStringClassObject() {
        String s = (String)ClassTools.execute(String.class, (String)"valueOf", Boolean.TYPE, (Object)Boolean.TRUE);
        ClassToolsTests.assertNotNull((Object)s);
        ClassToolsTests.assertEquals((String)"true", (String)s);
    }

    public void testExecuteClassStringClassArrayObjectArray() {
        Object bogusStaticMethodReturnValue;
        boolean exCaught;
        block5: {
            block4: {
                Class[] parmTypes = new Class[]{Boolean.TYPE};
                Object[] parms = new Object[]{Boolean.TRUE};
                String s = (String)ClassTools.execute(String.class, (String)"valueOf", (Class[])parmTypes, (Object[])parms);
                ClassToolsTests.assertNotNull((Object)s);
                ClassToolsTests.assertEquals((String)"true", (String)s);
                exCaught = false;
                bogusStaticMethodReturnValue = null;
                try {
                    bogusStaticMethodReturnValue = ClassTools.execute(String.class, (String)"bogusStaticMethod", (Class[])parmTypes, (Object[])parms);
                }
                catch (RuntimeException ex) {
                    if (!(ex.getCause() instanceof NoSuchMethodException)) break block4;
                    exCaught = true;
                }
            }
            ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
            exCaught = false;
            try {
                bogusStaticMethodReturnValue = ClassTools.execute(String.class, (String)"toString");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block5;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
    }

    public void testSet() {
        boolean exCaught;
        block2: {
            ClassTools.set(((Object)((Object)this)).getClass(), (String)"testStaticField", (Object)"new value");
            ClassToolsTests.assertEquals((String)testStaticField, (String)"new value");
            exCaught = false;
            try {
                ClassTools.set(((Object)((Object)this)).getClass(), (String)"bogusStaticField", (Object)"new value");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testSimpleName() {
        ClassToolsTests.assertEquals((String)"Vector", (String)Vector.class.getSimpleName());
        ClassToolsTests.assertEquals((String)"Entry", (String)Map.Entry.class.getSimpleName());
        ClassToolsTests.assertEquals((String)"int", (String)Integer.TYPE.getSimpleName());
        ClassToolsTests.assertEquals((String)"int[]", (String)int[].class.getSimpleName());
        ClassToolsTests.assertEquals((String)"int[][]", (String)int[][].class.getSimpleName());
        ClassToolsTests.assertEquals((String)"void", (String)Void.TYPE.getSimpleName());
    }

    public void testPackageName() {
        ClassToolsTests.assertEquals((String)"java.util", (String)Vector.class.getPackage().getName());
        ClassToolsTests.assertEquals((String)"java.util", (String)Map.Entry.class.getPackage().getName());
    }

    public void testArrayDepth() {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepth(Vector.class));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepth(Integer.TYPE));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepth(Void.TYPE));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepth(Vector[].class));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepth(int[].class));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepth(Vector[][][].class));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepth(int[][][].class));
    }

    public void testElementType() {
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementType(Vector.class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementType(Integer.TYPE));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.elementType(Void.TYPE));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementType(Vector[].class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementType(int[].class));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementType(Vector[][][].class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementType(int[][][].class));
    }

    public void testIsPrimitiveWrapper() {
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Void.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Boolean.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Integer.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Float.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(String.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(Integer.TYPE));
    }

    public void testIsVariablePrimitiveWrapper() {
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(Void.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitiveWrapper(Boolean.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitiveWrapper(Integer.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitiveWrapper(Float.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(String.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(Integer.TYPE));
    }

    public void testPrimitiveWrapper() {
        ClassToolsTests.assertEquals(Void.class, (Object)ClassTools.primitiveWrapper(Void.TYPE));
        ClassToolsTests.assertEquals(Integer.class, (Object)ClassTools.primitiveWrapper(Integer.TYPE));
        ClassToolsTests.assertEquals(Float.class, (Object)ClassTools.primitiveWrapper(Float.TYPE));
        ClassToolsTests.assertEquals(Boolean.class, (Object)ClassTools.primitiveWrapper(Boolean.TYPE));
        ClassToolsTests.assertNull((Object)ClassTools.primitiveWrapper(String.class));
    }

    public void testForTypeDeclarationStringInt() throws Exception {
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.forTypeDeclaration((String)"int", (int)0));
        ClassToolsTests.assertEquals(int[].class, (Object)ClassTools.forTypeDeclaration((String)"int", (int)1));
        ClassToolsTests.assertEquals(int[][][].class, (Object)ClassTools.forTypeDeclaration((String)"int", (int)3));
        ClassToolsTests.assertEquals(Object.class, (Object)ClassTools.forTypeDeclaration((String)"java.lang.Object", (int)0));
        ClassToolsTests.assertEquals(Object[][][].class, (Object)ClassTools.forTypeDeclaration((String)"java.lang.Object", (int)3));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.forTypeDeclaration((String)"void", (int)0));
        try {
            ClassTools.forTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ClassToolsTests.fail((String)"should not get here...");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testPrimitiveCode() {
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.primitiveCode(Integer.TYPE));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.primitiveCode(Byte.TYPE));
    }

    private Iterable<String> fieldNames(Iterable<Field> fields) {
        return new TransformationIterable<Field, String>(fields){

            protected String transform(Field field) {
                return field.getName();
            }
        };
    }

    private Iterable<String> methodNames(Iterable<Method> methods) {
        return new TransformationIterable<Method, String>(methods){

            protected String transform(Method method) {
                return method.getName();
            }
        };
    }
}

