/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.internal;

import java.util.Collections;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.ForeignKey;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.gen.internal.ORMGenCustomizer;
import org.eclipse.persistence.tools.gen.internal.ORMGenTable;
import org.eclipse.persistence.tools.gen.internal.util.EntityGenTools;
import org.eclipse.persistence.tools.utility.StringUtil;

public class ORMGenColumn {
    private Table mTable;
    private Column mDbColumn;
    private ORMGenCustomizer mCustomizer;
    private ORMGenTable mGenTable;
    private static String JAVA_LANG_PACKAGE = "java.lang.";
    public static final String PUBLIC_SCOPE = "public";
    public static final String PROTECTED_SCOPE = "protected";
    public static final String PRIVATE_SCOPE = "private";
    private static final String PROPERTY_NAME = "propertyName";
    protected static final String PROPERTY_TYPE = "propertyType";
    protected static final String MAPPING_KIND = "mappingKind";
    private static final String PROPERTY_DESC = "propertyDesc";
    private static final String PROPERTY_GET_SCOPE = "propertyGetScope";
    private static final String PROPERTY_SET_SCOPE = "propertySetScope";
    private static final String FIELD_SCOPE = "fieldScope";
    private static final String USE_IN_EQUALS = "useInEquals";
    private static final String USE_IN_TO_STRING = "useInToString";
    private static final String UPDATEABLE = "updateable";
    private static final String INSERTABLE = "insertable";
    private static final String GENERATED = "genProperty";

    public ORMGenColumn(Column dbColumn, ORMGenCustomizer customizer) {
        this.mDbColumn = dbColumn;
        this.mCustomizer = customizer;
        this.mTable = dbColumn.getTable();
    }

    public ORMGenCustomizer getCustomizer() {
        return this.mCustomizer;
    }

    public void setGenTable(ORMGenTable ormGenTable) {
        this.mGenTable = ormGenTable;
    }

    protected String customized(String propName) {
        return this.getCustomizer().getProperty(propName, this.mTable.getName(), this.getDbName());
    }

    protected boolean customizedBoolean(String propName) {
        return this.getCustomizer().getBooleanProperty(propName, this.mTable.getName(), this.getDbName());
    }

    protected void setCustomized(String propName, String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        this.getCustomizer().setProperty(propName, value, this.mTable.getName(), this.getDbName());
    }

    protected void setCustomizedBoolean(String propName, boolean value, boolean defaultValue) {
        if (defaultValue == value) {
            this.setCustomized(propName, null);
        } else {
            this.getCustomizer().setBooleanProperty(propName, value, this.mTable.getName(), this.getDbName());
        }
    }

    public String getName() {
        String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildColumnAnnotationName(this.mDbColumn.getName(), this.mDbColumn);
        return annotationName != null ? annotationName : this.mDbColumn.getName();
    }

    public String getDbName() {
        return this.mDbColumn.getName();
    }

    public String getJoinColumnName() {
        String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildJoinColumnAnnotationName(this.mDbColumn);
        return annotationName != null ? annotationName : this.mDbColumn.getName();
    }

    public Column getDbColumn() {
        return this.mDbColumn;
    }

    public String getPropertyName() {
        String name = this.customized(PROPERTY_NAME);
        if (name == null) {
            name = EntityGenTools.convertToUniqueJavaStyleAttributeName(this.getDbName(), Collections.<String>emptySet());
        }
        return name;
    }

    public void setPropertyName(String name) {
        if (!StringUtil.equalObjects((Object)name, (Object)this.getPropertyName())) {
            this.setCustomized(PROPERTY_NAME, name);
        }
    }

    public boolean isDefault() {
        return this.isDefaultname() && this.isUpdateable() && this.isInsertable();
    }

    public boolean isDefaultname() {
        String propName = this.getPropertyName();
        String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildColumnAnnotationName(propName, this.mDbColumn);
        return annotationName == null;
    }

    public boolean isDefaultJoinColumnName(String associationRolePropName) {
        if (!this.mDbColumn.isPartOfForeignKey()) {
            return false;
        }
        Iterable<ForeignKey> it = this.mDbColumn.getTable().getForeignKeys();
        for (ForeignKey fk : it) {
            Column c = fk.getBaseColumns().iterator().next();
            if (!c.equals(this.mDbColumn)) continue;
            try {
                String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildJoinColumnAnnotationName(associationRolePropName, fk);
                return annotationName == null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public String getPropertyType() {
        String type = this.customized(PROPERTY_TYPE);
        if (type == null) {
            type = this.getCustomizer().getPropertyTypeFromColumn(this.mDbColumn);
        }
        if (type.startsWith(JAVA_LANG_PACKAGE)) {
            type = type.substring(JAVA_LANG_PACKAGE.length());
        }
        if (type.equals("java.sql.Date")) {
            type = "java.util.Date";
        }
        return type;
    }

    public String getSimplePropertyType() {
        return this.mGenTable.getSimplifiedColType(this.getPropertyType());
    }

    public void setPropertyType(String type) {
        if (!StringUtil.equalObjects((Object)type, (Object)this.getPropertyType())) {
            this.setCustomized(PROPERTY_TYPE, type);
        }
    }

    public boolean isNumeric() {
        boolean ret = this.mDbColumn.isNumeric();
        return ret;
    }

    public String getMappingKind() {
        String kind = this.customized(MAPPING_KIND);
        if (kind == null) {
            kind = this.getCustomizer().getBasicMappingKind();
            if (this.mDbColumn.isPartOfPrimaryKey() && this.mDbColumn.getTable().getPrimaryKeyColumnsSize() == 1) {
                kind = this.getCustomizer().getIdMappingKind();
            }
        }
        return kind;
    }

    public void setMappingKind(String mappingKind) {
        if (!StringUtil.equalObjects((Object)mappingKind, (Object)this.getMappingKind())) {
            this.setCustomized(MAPPING_KIND, mappingKind);
        }
    }

    public boolean isNullable() {
        return this.mDbColumn.isNullable();
    }

    public int getSize() {
        if (this.mDbColumn.isNumeric()) {
            return this.mDbColumn.getPrecision();
        }
        return this.mDbColumn.getLength();
    }

    public int getDecimalDigits() {
        if (this.mDbColumn.isNumeric()) {
            return this.mDbColumn.getScale();
        }
        return -1;
    }

    public boolean isPrimaryKey() {
        return this.mDbColumn.isPartOfPrimaryKey();
    }

    public boolean isPartOfCompositePrimaryKey() {
        return this.mDbColumn.isPartOfPrimaryKey() && this.mTable.getPrimaryKeyColumnsSize() > 1;
    }

    public boolean isForeignKey() {
        return this.mDbColumn.isPartOfForeignKey();
    }

    public boolean isUnique() {
        return this.mDbColumn.isPartOfUniqueConstraint();
    }

    public String getPropertyDescription() {
        return this.customized(PROPERTY_DESC);
    }

    public boolean isDataTypeLOB() {
        return this.mDbColumn.isLOB();
    }

    public boolean isNeedMapTemporalType() {
        String propertyType = this.getPropertyType();
        return propertyType.equals("java.util.Date") || propertyType.equals("java.util.Calendar");
    }

    public String getTemporalType() {
        String defaultType = this.getCustomizer().getPropertyTypeFromColumn(this.mDbColumn);
        if (defaultType.equals("java.sql.Date")) {
            return "DATE";
        }
        if (defaultType.equals("java.sql.Time")) {
            return "TIME";
        }
        return "TIMESTAMP";
    }

    public String getPropertyGetScope() {
        String scope = this.customized(PROPERTY_GET_SCOPE);
        if (scope == null) {
            scope = PUBLIC_SCOPE;
        }
        return scope;
    }

    public void setPropertyGetScope(String scope) {
        if (!StringUtil.equalObjects((Object)scope, (Object)this.getPropertyGetScope())) {
            this.setCustomized(PROPERTY_GET_SCOPE, scope);
        }
    }

    public String getPropertySetScope() {
        String scope = this.customized(PROPERTY_SET_SCOPE);
        if (scope == null) {
            scope = PUBLIC_SCOPE;
        }
        return scope;
    }

    public void setPropertySetScope(String scope) {
        if (!StringUtil.equalObjects((Object)scope, (Object)this.getPropertySetScope())) {
            this.setCustomized(PROPERTY_SET_SCOPE, scope);
        }
    }

    public String getFieldScope() {
        String scope = this.customized(FIELD_SCOPE);
        if (scope == null) {
            scope = PRIVATE_SCOPE;
        }
        return scope;
    }

    public boolean isUseInEquals() {
        return this.customizedBoolean(USE_IN_EQUALS) || this.isPrimaryKey();
    }

    public void setUseInEquals(boolean value) {
        this.setCustomizedBoolean(USE_IN_EQUALS, value, false);
    }

    public boolean isUseInToString() {
        return this.customizedBoolean(USE_IN_TO_STRING) || this.isPrimaryKey();
    }

    public void setUseInToString(boolean value) {
        this.setCustomizedBoolean(USE_IN_TO_STRING, value, false);
    }

    public boolean isUpdateable() {
        return !"false".equals(this.customized(UPDATEABLE));
    }

    public void setUpdateable(boolean value) {
        this.setCustomizedBoolean(UPDATEABLE, value, true);
    }

    public boolean isInsertable() {
        return !"false".equals(this.customized(INSERTABLE));
    }

    public void setInsertable(boolean value) {
        this.setCustomizedBoolean(INSERTABLE, value, true);
    }

    public boolean isGenerated() {
        return !"false".equals(this.customized(GENERATED));
    }

    public void setGenerated(boolean value) {
        this.setCustomizedBoolean(GENERATED, value, true);
    }

    public String toString() {
        return "name=" + this.getName() + "; type=" + this.getPropertyType();
    }
}

