/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db;

import java.util.Iterator;
import org.eclipse.persistence.tools.db.EclipseLinkDatabase;
import org.eclipse.persistence.tools.db.EclipseLinkTable;
import org.eclipse.persistence.tools.db.model.ELDatabase;
import org.eclipse.persistence.tools.db.model.ELTable;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.Schema;
import org.eclipse.persistence.tools.gen.db.SchemaContainer;
import org.eclipse.persistence.tools.gen.db.Sequence;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;
import org.eclipse.persistence.tools.utility.iterator.FilteringIterator;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;

public class EclipseLinkSchema
implements Schema {
    private EclipseLinkDatabase database;
    private ELDatabase mwDatabase;
    private String schemaName;

    public EclipseLinkSchema(EclipseLinkDatabase database, ELDatabase mwDatabase, String schemaName) {
        this.database = database;
        this.mwDatabase = mwDatabase;
        this.schemaName = schemaName;
    }

    public ConnectionProfile getConnectionProfile() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public SchemaContainer getContainer() {
        return this.getDatabase();
    }

    public EclipseLinkDatabase getDatabase() {
        return this.database;
    }

    public String getIdentifier() {
        return this.getDatabase().convertNameToIdentifier(this.schemaName);
    }

    public String getIdentifier(String defaultName) {
        return this.getDatabase().getIdentifier(this.getName(), defaultName);
    }

    public String getName() {
        return this.schemaName;
    }

    public Sequence getSequenceForIdentifier(String identifier) {
        throw new UnsupportedOperationException("Sequences not supported.");
    }

    public Sequence getSequenceNamed(String name) {
        throw new UnsupportedOperationException("Sequences not supported.");
    }

    public Iterable<Sequence> getSequences() {
        throw new UnsupportedOperationException("Sequences not supported.");
    }

    public int getSequencesSize() {
        throw new UnsupportedOperationException("Sequences not supported.");
    }

    public Iterable<String> getSortedSequenceIdentifiers() {
        throw new UnsupportedOperationException("Sequences not supported.");
    }

    public Iterable<String> getSortedTableIdentifiers() {
        return new TransformationIterable<Table, String>(this.getTables()){

            protected String transform(Table table) {
                return table.getName();
            }
        };
    }

    public Table getTableForIdentifier(String identifier) {
        return this.getTableNamed(identifier);
    }

    public Table getTableNamed(String name) {
        for (Table table : this.getTables()) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public Iterable<Table> getTables() {
        return new TransformationIterable<ELTable, Table>((Iterable)new Iterable<ELTable>(){

            @Override
            public Iterator<ELTable> iterator() {
                return new FilteringIterator<ELTable>(EclipseLinkSchema.this.mwDatabase.tables()){

                    protected boolean accept(ELTable table) {
                        return ObjectTools.equals((Object)EclipseLinkSchema.this.schemaName, (Object)table.getSchema());
                    }
                };
            }
        }){

            protected Table transform(ELTable table) {
                return new EclipseLinkTable(EclipseLinkSchema.this, table);
            }
        };
    }

    public int getTablesSize() {
        return IteratorTools.size(this.getTables().iterator());
    }

    public void refresh() {
    }
}

