/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.nosql.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.CollectionDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.ColumnDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.LeafColumnDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.NestedColumnDescriptor;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.DataFormatType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSql;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMRepository;
import org.eclipse.persistence.tools.utility.NameTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.StringUtil;
import org.eclipse.persistence.tools.utility.collection.ListTools;

public class MongoEntityGenerator {
    private Mongo connection;
    private DB database;
    private int rowSampleSize;

    public MongoEntityGenerator(String host, int port, String dbName, int rowSampleSize) throws MongoException, UnknownHostException {
        this.rowSampleSize = rowSampleSize;
        this.connection = new Mongo(new ServerAddress(host, port));
        this.database = this.connection.getDB(dbName);
    }

    private List<CollectionDescriptor> buildCollectionDescriptors(Collection<String> collectionNames) {
        LinkedList<CollectionDescriptor> collectionDescriptors = new LinkedList<CollectionDescriptor>();
        for (String collectionName : collectionNames) {
            CollectionDescriptor collectionDescriptor = new CollectionDescriptor(collectionName);
            collectionDescriptors.add(collectionDescriptor);
            this.updateColumnDescriptors(collectionDescriptor);
        }
        return collectionDescriptors;
    }

    private Class<?> calculateType(Class<?> type1, Class<?> type2) {
        if (type1 != null && type2 == null) {
            return type1;
        }
        if (type1 == null && type2 != null) {
            return type2;
        }
        if (type1 == Integer.class && type2 == Long.class || type2 == Integer.class && type1 == Long.class) {
            return Long.class;
        }
        if (type1 == Float.class && type2 == Double.class || type2 == Float.class && type1 == Double.class) {
            return Double.class;
        }
        if (!((type1 != Integer.class && type1 != Long.class || type2 != Float.class && type2 != Double.class) && (type2 != Integer.class && type2 != Long.class || type1 != Float.class && type1 != Double.class))) {
            return Double.class;
        }
        return type1;
    }

    private ExternalORMConfiguration generate(List<CollectionDescriptor> collectionDescriptors, String packageName) {
        try {
            ORMConfiguration config = new ORMRepository().buildORMConfiguration(null, ORMDocumentType.ECLIPELINK_2_6);
            HashSet<String> allEntityNames = new HashSet<String>();
            for (CollectionDescriptor collection : collectionDescriptors) {
                String collectionName = collection.getName();
                String entityName = this.uniqueJavaClassName(collectionName, packageName, allEntityNames);
                ExternalEntity exEntity = config.addEntity(entityName);
                exEntity.setAccessType(AccessType.VIRTUAL);
                ExternalNoSql noSqlDesc = exEntity.addNoSql();
                noSqlDesc.setDataFormat(DataFormatType.MAPPED);
                noSqlDesc.setDataType(collectionName);
                this.generateMappings((ExternalEmbeddable)exEntity, collection, packageName, (ExternalORMConfiguration)config, allEntityNames);
            }
            this.generateQueries((ExternalORMConfiguration)config);
            return config;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void generateLeafMapping(ExternalEmbeddable exEntity, LeafColumnDescriptor column, String columnName, String javaColumnName) {
        Object mapping;
        if (column.isList()) {
            mapping = exEntity.addElementCollectionMapping(javaColumnName);
            mapping.setTargetClassName(column.getColumnType().getName());
            mapping.setAttributeType(Vector.class.getName());
        } else {
            mapping = columnName.equals("_id") ? exEntity.addIdMapping(javaColumnName) : exEntity.addBasicMapping(javaColumnName);
            mapping.setAttributeType(column.getColumnType().getName());
        }
        mapping.setNoSqlField(columnName);
    }

    private void generateMappings(ExternalEmbeddable exEntity, CollectionDescriptor collection, String packageName, ExternalORMConfiguration config, Set<String> allEntityNames) {
        for (ColumnDescriptor columnDescriptor : collection.columns()) {
            String columnName = columnDescriptor.getColumnName();
            String javaColumnName = NameTools.javaNameFromDatabaseName((String)columnName);
            javaColumnName = this.jpaAnnotationToMappingName(javaColumnName);
            if (columnDescriptor instanceof LeafColumnDescriptor) {
                this.generateLeafMapping(exEntity, (LeafColumnDescriptor)columnDescriptor, columnName, javaColumnName);
                continue;
            }
            if (!(columnDescriptor instanceof NestedColumnDescriptor)) continue;
            this.generateNestedMapping(exEntity, config, packageName, allEntityNames, (NestedColumnDescriptor)columnDescriptor, columnName, javaColumnName);
        }
    }

    private void generateNestedMapping(ExternalEmbeddable exEntity, ExternalORMConfiguration config, String packageName, Set<String> allEntityNames, NestedColumnDescriptor column, String columnName, String javaColumnName) {
        String embeddableName = this.uniqueJavaClassName(columnName, packageName, allEntityNames);
        ExternalEmbeddable embeddable = config.addEmbeddable(embeddableName);
        embeddable.addNoSql().setDataFormat(DataFormatType.MAPPED);
        embeddable.setAccessType(AccessType.VIRTUAL);
        this.generateMappings(embeddable, column.getColumnDescriptor(), packageName, config, allEntityNames);
        if (column.isList()) {
            ExternalElementCollectionMapping mapping = exEntity.addElementCollectionMapping(javaColumnName);
            mapping.setNoSqlField(columnName);
            mapping.setAttributeType(Vector.class.getName());
            mapping.setTargetClassName(embeddableName);
        } else {
            ExternalEmbeddedMapping mapping = exEntity.addEmbeddedMapping(javaColumnName);
            mapping.setNoSqlField(columnName);
            mapping.setAttributeType(embeddableName);
        }
    }

    private void generateQueries(ExternalORMConfiguration config) {
        for (ExternalEntity entity : config.entities()) {
            String entityName = entity.getClassShortName();
            ExternalBasicNamedQuery query = config.addNamedQuery(String.valueOf(entityName) + ".findAll");
            char identifier = Character.toLowerCase(entityName.charAt(0));
            query.setQuery("select " + identifier + " from " + entityName + " " + identifier);
        }
    }

    public void generateSource(Collection<String> collectionNames, String packageName, File baseDirectory, AccessType type, String characterEncoding) throws Exception {
        List<CollectionDescriptor> collectionDescriptors = this.buildCollectionDescriptors(collectionNames);
        ExternalORMConfiguration config = this.generate(collectionDescriptors, packageName);
        File packageDirectory = new File(baseDirectory, String.valueOf(packageName.replace('.', '/')) + "/");
        packageDirectory.mkdirs();
        Properties vep = new Properties();
        vep.setProperty("resource.loader", "class");
        vep.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine ve = new VelocityEngine();
        ve.init(vep);
        for (ExternalEntity entity : config.entities()) {
            this.generateSource((ExternalEmbeddable)entity, type, "entity.java.vm", packageName, packageDirectory, ve, characterEncoding);
        }
        for (ExternalEntity entity : config.embeddables()) {
            this.generateSource((ExternalEmbeddable)entity, type, "embeddable.java.vm", packageName, packageDirectory, ve, characterEncoding);
        }
    }

    private void generateSource(ExternalEmbeddable entity, AccessType accessType, String templateName, String packageName, File packageDirectory, VelocityEngine ve, String characterEncoding) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("entity", (Object)entity);
        context.put("mappings", (Object)ListTools.list((Iterable)entity.mappings()));
        context.put("packageName", (Object)packageName);
        context.put("accessType", (Object)accessType);
        StringWriter w = new StringWriter();
        ve.mergeTemplate(templateName, (Context)context, (Writer)w);
        String fileContent = w.toString();
        File javaFile = new File(packageDirectory, String.valueOf(entity.getClassShortName()) + ".java");
        byte[] content = fileContent.getBytes(characterEncoding);
        javaFile.createNewFile();
        FileOutputStream writer = new FileOutputStream(javaFile);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    public String generateXML(Collection<String> collectionNames, String packageName) {
        List<CollectionDescriptor> collectionDescriptors = this.buildCollectionDescriptors(collectionNames);
        return this.generate(collectionDescriptors, packageName).getXML();
    }

    private void handleLeafColumn(CollectionDescriptor collectionDescriptor, String columnName, Object value) {
        Class<Object> valueClass;
        LeafColumnDescriptor columnDescriptor = (LeafColumnDescriptor)collectionDescriptor.getColumn(columnName);
        if (columnDescriptor == null) {
            columnDescriptor = collectionDescriptor.addLeafColumn(columnName);
        }
        valueClass = (valueClass = value.getClass()).getName().equals("org.bson.types.ObjectId") ? String.class : valueClass;
        Class<?> type = this.calculateType(valueClass, columnDescriptor.getColumnType());
        columnDescriptor.setColumnType(type);
    }

    private void handleListColumn(CollectionDescriptor collectionDescriptor, String columnName, BasicDBList listValue) {
        block2: {
            Object valueFromList;
            ListIterator listValues;
            ColumnDescriptor columnDescriptor;
            block3: {
                columnDescriptor = collectionDescriptor.getColumn(columnName);
                if (listValue.size() <= 0) break block2;
                listValues = listValue.listIterator();
                valueFromList = listValues.next();
                if (!(valueFromList instanceof BasicDBObject)) break block3;
                NestedColumnDescriptor nestedColumnDesc = columnDescriptor == null ? collectionDescriptor.addNestedColumn(columnName) : (NestedColumnDescriptor)columnDescriptor;
                nestedColumnDesc.setList(true);
                this.updateCollectionDescriptor(nestedColumnDesc.getColumnDescriptor(), (DBObject)valueFromList);
                while (listValues.hasNext()) {
                    valueFromList = listValues.next();
                    this.updateCollectionDescriptor(nestedColumnDesc.getColumnDescriptor(), (DBObject)valueFromList);
                }
                break block2;
            }
            if (valueFromList == null) break block2;
            Class<?> valueClass = valueFromList.getClass();
            LeafColumnDescriptor leafColumnDescriptor = columnDescriptor == null ? collectionDescriptor.addLeafColumn(columnName) : (LeafColumnDescriptor)columnDescriptor;
            leafColumnDescriptor.setList(true);
            leafColumnDescriptor.setColumnType(valueClass);
            while (listValues.hasNext()) {
                valueFromList = listValues.next();
                if (valueFromList == null) continue;
                valueClass = valueFromList.getClass();
                if (leafColumnDescriptor.getColumnType() == valueClass) continue;
                Class<?> type = this.calculateType(leafColumnDescriptor.getColumnType(), valueClass);
                leafColumnDescriptor.setColumnType(type);
                break;
            }
        }
    }

    private void handleNestedColumn(CollectionDescriptor collectionDescriptor, String columnName, Object value) {
        NestedColumnDescriptor columnDescriptor = (NestedColumnDescriptor)collectionDescriptor.getColumn(columnName);
        if (columnDescriptor == null) {
            columnDescriptor = collectionDescriptor.addNestedColumn(columnName);
        }
        this.updateCollectionDescriptor(columnDescriptor.getColumnDescriptor(), (DBObject)value);
    }

    private String jpaAnnotationToEntityName(String entityName) {
        if (entityName.equalsIgnoreCase("Entity") || entityName.equalsIgnoreCase("Embeddable") || entityName.equalsIgnoreCase("MappedSuperclass")) {
            entityName = String.valueOf(entityName) + "Entity";
        }
        return entityName;
    }

    private String jpaAnnotationToMappingName(String mappingName) {
        if (mappingName.equalsIgnoreCase("Id") || mappingName.equalsIgnoreCase("Basic") || mappingName.equalsIgnoreCase("Embedded") || mappingName.equalsIgnoreCase("ElementCollection")) {
            mappingName = String.valueOf(mappingName) + "Mapping";
        }
        return mappingName;
    }

    public Set<String> listCollectionNames() {
        Set collectionNames = this.database.getCollectionNames();
        collectionNames.remove("system.indexes");
        return collectionNames;
    }

    private String uniqueJavaClassName(String collectionName, String packageName, Set<String> allEntityNames) {
        String entityName = StringUtil.singularise((String)NameTools.javaNameFromDatabaseName((String)collectionName, (boolean)true));
        entityName = this.jpaAnnotationToEntityName(entityName);
        if (StringTools.isNotBlank((String)packageName)) {
            entityName = String.valueOf(packageName) + "." + entityName;
        }
        entityName = NameTools.uniqueName((String)entityName, allEntityNames);
        allEntityNames.add(entityName);
        return entityName;
    }

    private void updateCollectionDescriptor(CollectionDescriptor collectionDescriptor, DBObject dbObject) {
        for (String columnName : dbObject.keySet()) {
            Object value = dbObject.get(columnName);
            if (value == null) continue;
            if (value instanceof BasicDBList) {
                this.handleListColumn(collectionDescriptor, columnName, (BasicDBList)value);
                continue;
            }
            if (value instanceof BasicDBObject) {
                this.handleNestedColumn(collectionDescriptor, columnName, value);
                continue;
            }
            this.handleLeafColumn(collectionDescriptor, columnName, value);
        }
    }

    private void updateColumnDescriptors(CollectionDescriptor collectionDescriptor) {
        DBCollection collection = this.database.getCollection(collectionDescriptor.getName());
        DBCursor cursor = collection.find().limit(this.rowSampleSize);
        for (DBObject row : cursor) {
            this.updateCollectionDescriptor(collectionDescriptor, row);
        }
    }
}

