/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalCache;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalTimeOfDay;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ORMConfigurationTests;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.w3c.dom.Node;

public final class CacheTests
extends AbstractExternalFormTests<ExternalCache> {
    private AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Boolean> buildAlwaysRefreshTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "always-refresh";
            }

            @Override
            public Boolean getValue(ExternalCache form) {
                return form.isAlwaysRefresh();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, Boolean value) {
                form.setAlwaysRefresh(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    private AbstractExternalFormTests.ExternalFormBuilder<ExternalCache> buildCacheBuilder() {
        return new AbstractExternalFormTests.ExternalFormBuilder<ExternalCache>(){

            @Override
            public ExternalCache buildExternalForm() throws IOException {
                ORMConfiguration orm = ORMConfigurationTests.buildExternalForm();
                ExternalEntity entity = orm.addEntity("org.test.MyEntity");
                return entity.addCache();
            }

            @Override
            public ExternalCache buildExternalForm(ExternalForm parentForm) {
                return ((ExternalEntity)parentForm).addCache();
            }

            @Override
            public int getDefaultAttributeCount() {
                return 0;
            }

            @Override
            public Node getNode(ExternalCache form) {
                return (Node)ObjectTools.execute((Object)form, (String)"getElement");
            }

            @Override
            public String getNodeName() {
                return "cache";
            }

            @Override
            public List<String> getTreeNodeNames() {
                return ListTools.list((Object[])new String[]{"entity-mappings", "entity", "cache"});
            }
        };
    }

    private AbstractExternalFormTests.TextNodeTester<ExternalCache, Integer> buildExpiryTester() {
        return new AbstractExternalFormTests.TextNodeTester<ExternalCache, Integer>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Integer getDefaultValue() {
                return 123;
            }

            @Override
            public String getNodeName() {
                return "expiry";
            }

            @Override
            public Integer getValue(ExternalCache form) {
                return form.getExpiryTimeToLive();
            }

            @Override
            public Integer getValue1() {
                return 1234;
            }

            @Override
            public Integer getValue2() {
                return 5678;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, Integer value) {
                form.setExpiryTimeToLive(value);
            }

            @Override
            public String toString(Integer value) {
                return value.toString();
            }
        };
    }

    private AbstractExternalFormTests.ChildNodeTester<ExternalCache, ExternalTimeOfDay> buildExpiryTimeOfDayTester() {
        return new AbstractExternalFormTests.ChildNodeTester<ExternalCache, ExternalTimeOfDay>(){

            @Override
            public ExternalTimeOfDay addChild(ExternalCache form) {
                return form.addExpiryTimeOfDay();
            }

            @Override
            public ExternalTimeOfDay getChild(ExternalCache form) {
                return form.getExpiryTimeOfDay();
            }

            @Override
            public String getNodeName() {
                return "expiry-time-of-day";
            }

            @Override
            public boolean hasChild(ExternalCache form) {
                return form.hasExpiryTimeOfDay();
            }

            @Override
            public void removeChild(ExternalCache form) {
                form.removeExpiryTimeOfDay();
            }
        };
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalCache, CacheIsolationType> buildIsolationTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalCache, CacheIsolationType>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public CacheIsolationType getDefaultValue() {
                return CacheIsolationType.ISOLATED;
            }

            @Override
            public String getNodeName() {
                return "isolation";
            }

            @Override
            public CacheIsolationType getValue(ExternalCache form) {
                return form.getIsolationType();
            }

            @Override
            public CacheIsolationType getValue1() {
                return CacheIsolationType.PROTECTED;
            }

            @Override
            public CacheIsolationType getValue2() {
                return CacheIsolationType.SHARED;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, CacheIsolationType value) {
                form.setIsolationType(value);
            }

            @Override
            public String toString(CacheIsolationType value) {
                return value.toString();
            }
        };
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Boolean> buildRefreshOnlyIfNewerTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "refresh-only-if-newer";
            }

            @Override
            public Boolean getValue(ExternalCache form) {
                return form.isRefreshOnlyIfNewer();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, Boolean value) {
                form.setRefreshOnlyIfNewer(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Boolean> buildSharedTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "shared";
            }

            @Override
            public Boolean getValue(ExternalCache form) {
                return form.isShared();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, Boolean value) {
                form.setShared(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Integer> buildSizeTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalCache, Integer>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Integer getDefaultValue() {
                return 123;
            }

            @Override
            public String getNodeName() {
                return "size";
            }

            @Override
            public Integer getValue(ExternalCache form) {
                return form.getSize();
            }

            @Override
            public Integer getValue1() {
                return 12345;
            }

            @Override
            public Integer getValue2() {
                return 6789;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, Integer value) {
                form.setSize(value);
            }

            @Override
            public String toString(Integer value) {
                return value.toString();
            }
        };
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalCache, CacheType> buildTypeTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalCache, CacheType>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public CacheType getDefaultValue() {
                return CacheType.CACHE;
            }

            @Override
            public String getNodeName() {
                return "type";
            }

            @Override
            public CacheType getValue(ExternalCache form) {
                return form.getType();
            }

            @Override
            public CacheType getValue1() {
                return CacheType.FULL;
            }

            @Override
            public CacheType getValue2() {
                return CacheType.HARD_WEAK;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalCache form, CacheType value) {
                form.setType(value);
            }

            @Override
            public String toString(CacheType value) {
                return value.name();
            }
        };
    }

    @Override
    protected void populate(AbstractExternalFormTests.RootNodeTester tester) {
        tester.setBuilder(this.buildCacheBuilder());
        tester.addAttribute(this.buildSizeTester());
        tester.addAttribute(this.buildSharedTester());
        tester.addAttribute(this.buildIsolationTester());
        tester.addAttribute(this.buildTypeTester());
        tester.addAttribute(this.buildAlwaysRefreshTester());
        tester.addAttribute(this.buildRefreshOnlyIfNewerTester());
        tester.addTextNode(this.buildExpiryTester());
        tester.addNode(this.buildExpiryTimeOfDayTester());
    }
}

