/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

public abstract class AbstractExternalFormTests<FORM extends ExternalForm> {
    protected abstract void populate(RootNodeTester var1);

    @Test
    public final void test() throws Exception {
        RootNodeTester tester = new RootNodeTester();
        this.populate(tester);
        tester.test();
    }

    private abstract class AbstractChildNodeTesterRunner
    extends NodeTesterRunner {
        boolean hasChild;

        AbstractChildNodeTesterRunner(NodeTester<FORM, ?> tester) {
            super(tester);
        }

        final String displayString() {
            return "<" + this.getNodeName() + ">";
        }

        final Node getChildNode(Node node) {
            node = node.getFirstChild();
            while (node != null) {
                if (this.getNodeName().equals(node.getNodeName())) {
                    return node;
                }
                node = node.getNextSibling();
            }
            return null;
        }

        @Override
        boolean isMultipleSupported() {
            return false;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return false;
        }
    }

    private class AttributeNodeRunnerAddingController
    extends Controller {
        private AttributeNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            AttributeNodeTesterRunner runner = (AttributeNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + " " + runner.getNodeName() + "=\"" + runner.propertyTester().getDefaultValue() + "\"> : adding");
        }

        @Override
        void test(ExternalFormHolder holder) {
            AttributeNodeTesterRunner runner = (AttributeNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class AttributeNodeRunnerReadingController
    extends Controller {
        private AttributeNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            AttributeNodeTesterRunner runner = (AttributeNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + " " + runner.getNodeName() + "=\"" + runner.propertyTester().getDefaultValue() + "\"> : reading");
        }

        @Override
        void test(ExternalFormHolder holder) {
            AttributeNodeTesterRunner runner = (AttributeNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class AttributeNodeRunnerRemovingController
    extends Controller {
        private AttributeNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            AttributeNodeTesterRunner runner = (AttributeNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + " " + runner.getNodeName() + "=\"" + runner.propertyTester().getDefaultValue() + "\"> : removing");
        }

        @Override
        void test(ExternalFormHolder holder) {
            AttributeNodeTesterRunner runner = (AttributeNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface AttributeNodeTester<FORM extends ExternalForm, VALUE>
    extends PropertyTester<FORM, VALUE> {
    }

    private class AttributeNodeTesterRunner
    extends PropertyNodeTesterRunner {
        AttributeNodeTesterRunner(AttributeNodeTester<FORM, ?> tester) {
            super(tester);
        }

        @Override
        String displayString() {
            return "<" + this.parentNodeName + " " + this.getNodeName() + "=\"" + this.propertyTester().getDefaultValue() + "\">";
        }

        @Override
        int getChildrenCount(Node parentNode) {
            return parentNode.getAttributes().getLength();
        }

        @Override
        Node getNode(Node parentNode) {
            return parentNode.getAttributes().getNamedItem(this.getNodeName());
        }

        @Override
        String getNodeValue(Node node) {
            return node.getTextContent();
        }
    }

    private class BooleanChildNodeRunnerAddingController
    extends Controller {
        private BooleanChildNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            BooleanChildNodeTesterRunner runner = (BooleanChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class BooleanChildNodeRunnerReadingController
    extends Controller {
        private BooleanChildNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : reading");
        }

        @Override
        void test(ExternalFormHolder holder) {
            BooleanChildNodeTesterRunner runner = (BooleanChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class BooleanChildNodeRunnerRemovingController
    extends Controller {
        private BooleanChildNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : removing");
        }

        @Override
        void test(ExternalFormHolder holder) {
            BooleanChildNodeTesterRunner runner = (BooleanChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface BooleanChildNodeTester<FORM extends ExternalForm>
    extends NodeTester<FORM, Boolean> {
        public boolean getValue(FORM var1);

        public void setValue(FORM var1, boolean var2);
    }

    private class BooleanChildNodeTesterRunner
    extends AbstractChildNodeTesterRunner {
        BooleanChildNodeTesterRunner(BooleanChildNodeTester<FORM> tester) {
            super(tester);
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
            if (this.hasChild) {
                return;
            }
            BooleanChildNodeTester tester = (BooleanChildNodeTester)this.tester;
            tester.setValue(holder.form, true);
            this.hasChild = true;
            ++this.currentChildrenCount;
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Assert.assertTrue((String)(String.valueOf(this.displayString()) + " : The child node should have been found"), (boolean)tester.getValue(holder.form));
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (Object)this.getChildNode(holder.node));
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
            BooleanChildNodeTester tester = (BooleanChildNodeTester)this.tester;
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (Object)this.hasChild, (Object)tester.getValue(holder.form));
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            if (this.hasChild) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (Object)this.getChildNode(holder.node));
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (Object)this.getChildNode(holder.node));
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }

        @Override
        void testReading(ExternalFormHolder holder) {
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
            if (!this.hasChild) {
                return;
            }
            BooleanChildNodeTester tester = (BooleanChildNodeTester)this.tester;
            Assert.assertTrue((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (boolean)tester.getValue(holder.form));
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            tester.setValue(holder.form, false);
            --this.currentChildrenCount;
            this.hasChild = false;
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should have been removed"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The wrong child node was removed"), (Object)this.getChildNode(holder.node));
            Assert.assertFalse((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (boolean)tester.getValue(holder.form));
        }
    }

    private class ChildAttributeRunnerAddingController
    extends Controller {
        private ChildAttributeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            ChildAttributeTesterRunner runner = (ChildAttributeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getChildNodeName() + " " + runner.tester.getNodeName() + "=\"\">> : adding");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildAttributeTesterRunner runner = (ChildAttributeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChildAttributeRunnerReadingController
    extends Controller {
        private ChildAttributeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            ChildAttributeTesterRunner runner = (ChildAttributeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getChildNodeName() + " " + runner.tester.getNodeName() + "=\"\">> : reading");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildAttributeTesterRunner runner = (ChildAttributeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChildAttributeRunnerRemovingController
    extends Controller {
        private ChildAttributeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            ChildAttributeTesterRunner runner = (ChildAttributeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getChildNodeName() + " " + runner.tester.getNodeName() + "=\"\">> : removing");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildAttributeTesterRunner runner = (ChildAttributeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface ChildAttributeTester<FORM extends ExternalForm, VALUE>
    extends PropertyTester<FORM, VALUE> {
        public String getChildNodeName();
    }

    private class ChildAttributeTesterRunner
    extends NodeTesterRunner {
        private boolean nodeExists;

        ChildAttributeTesterRunner(ChildAttributeTester<FORM, ?> tester) {
            super(tester);
        }

        private String displayString() {
            return "<" + this.parentNodeName + "><" + this.getChildNodeName() + " " + this.tester.getNodeName() + "=\"\">";
        }

        @Override
        String getActualNodeName() {
            return this.getChildNodeName();
        }

        private Node getChildNode(Node node) {
            node = node.getFirstChild();
            while (node != null) {
                if (this.getChildNodeName().equals(node.getNodeName())) {
                    return node;
                }
                node = node.getNextSibling();
            }
            return null;
        }

        private String getChildNodeName() {
            return ((ChildAttributeTester)this.tester).getChildNodeName();
        }

        @Override
        boolean isMultipleSupported() {
            return false;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return false;
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
            ChildAttributeTester tester = (ChildAttributeTester)this.tester;
            tester.setValue(holder.form, null);
            if (this.nodeExists) {
                --this.currentChildrenCount;
                this.nodeExists = false;
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Object result = tester.getValue(holder.form);
            Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The element's value should be null"), result);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Object expectedValue1 = tester.getValue1();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : Value 1 cannot be null"), expectedValue1);
            tester.setValue(holder.form, expectedValue1);
            if (!this.nodeExists) {
                this.nodeExists = true;
                ++this.currentChildrenCount;
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Node childNode = this.getChildNode(holder.node);
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node was not added correctly"), (Object)childNode);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of attributes is inconsistent"), (long)1L, (long)childNode.getAttributes().getLength());
            Node attribute = childNode.getAttributes().getNamedItem(tester.getNodeName());
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The attribute was not added correctly"), (Object)attribute);
            String stringExpectedValue = tester.toString(expectedValue1);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The attribute's value was not set correctly"), (Object)stringExpectedValue, (Object)attribute.getNodeValue());
            result = tester.getValue(holder.form);
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The element's value was not set correctly"), result);
            String stringResult = tester.toString(result);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The value was not set correctly"), (Object)stringExpectedValue, (Object)stringResult);
            Object expectedValue2 = tester.getValue2();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : Value 2 cannot be null"), expectedValue2);
            Assert.assertNotSame((String)(String.valueOf(this.displayString()) + " : Value 1 and value 2 cannot be the same"), expectedValue1, expectedValue2);
            tester.setValue(holder.form, expectedValue2);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            childNode = this.getChildNode(holder.node);
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node was not added correctly"), (Object)childNode);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of attributes is inconsistent"), (long)1L, (long)childNode.getAttributes().getLength());
            attribute = childNode.getAttributes().getNamedItem(tester.getNodeName());
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The attribute was not added correctly"), (Object)attribute);
            stringExpectedValue = tester.toString(expectedValue2);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The attribute's value was not set correctly"), (Object)stringExpectedValue, (Object)attribute.getNodeValue());
            result = tester.getValue(holder.form);
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The element's value was not set correctly"), result);
            stringResult = tester.toString(result);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The value was not set correctly"), (Object)stringExpectedValue, (Object)stringResult);
            Object defaultValue = tester.getDefaultValue();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The default value cannot be null"), defaultValue);
            tester.setValue(holder.form, defaultValue);
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
            ChildAttributeTester tester = (ChildAttributeTester)this.tester;
            this.nodeExists |= tester.doesNodeAlreadyExist();
            String nodeName = this.getNodeName();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node's attribute name cannot be null"), (Object)nodeName);
            String childNodeName = this.getChildNodeName();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node name cannot be null"), (Object)childNodeName);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is incorrect"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Node childNode = this.getChildNode(holder.node);
            if (!this.nodeExists) {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The node should be null"), (Object)childNode);
            } else {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The node should not be null"), (Object)childNode);
                Node attribute = childNode.getAttributes().getNamedItem(tester.getNodeName());
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The attribute was not added correctly"), (Object)attribute);
                Object defaultValue = tester.getDefaultValue();
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The default value cannot be null"), defaultValue);
                String stringDefaultValue = tester.toString(defaultValue);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The attribute's value was not set correctly"), (Object)stringDefaultValue, (Object)attribute.getNodeValue());
            }
        }

        @Override
        void testReading(ExternalFormHolder holder) {
            ChildAttributeTester tester = (ChildAttributeTester)this.tester;
            Object result = tester.getValue(holder.form);
            if (this.nodeExists) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The element's value should not be null"), result);
                Assert.assertSame((String)(String.valueOf(this.displayString()) + " : The element's value was not retrived correctly"), tester.getDefaultValue(), result);
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The element's value should be null"), result);
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Node childNode = this.getChildNode(holder.node);
            if (this.nodeExists) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The node should not be null"), (Object)childNode);
                Node attribute = childNode.getAttributes().getNamedItem(tester.getNodeName());
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The attribute should not be null"), (Object)attribute);
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The node should be null"), (Object)childNode);
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
            PropertyTester tester = (PropertyTester)this.tester;
            tester.setValue(holder.form, null);
            if (this.nodeExists) {
                this.nodeExists = false;
                --this.currentChildrenCount;
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }
    }

    private class ChildListNodeRunnerAddingController
    extends Controller {
        private ChildListNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "*> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildListNodeTesterRunner runner = (ChildListNodeTesterRunner)this.runner;
            Random random = new Random();
            int count = runner.getDefaultChildrenCount();
            int startIndex = random.nextInt(count);
            int endIndex = random.nextInt(count);
            while (endIndex == startIndex) {
                endIndex = random.nextInt(count);
            }
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.addRange(startIndex, endIndex);
            runner.rangeIndex = runner.ranges.size() - 1;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChildListNodeRunnerReadingController
    extends Controller {
        private ChildListNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "*> : reading");
        }

        @Override
        void test(ExternalFormHolder holder) {
            int rangeIndex;
            ChildListNodeTesterRunner runner = (ChildListNodeTesterRunner)this.runner;
            int rangesCount = runner.ranges.size();
            if (rangesCount == 0) {
                return;
            }
            Random random = new Random();
            runner.rangeIndex = rangeIndex = random.nextInt(rangesCount);
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
        }
    }

    private class ChildListNodeRunnerRemovingController
    extends Controller {
        private ChildListNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "*> : removal");
        }

        @Override
        void test(ExternalFormHolder holder) {
            int rangeIndex;
            ChildListNodeTesterRunner runner = (ChildListNodeTesterRunner)this.runner;
            int rangesCount = runner.ranges.size();
            if (rangesCount == 0) {
                return;
            }
            Random random = new Random();
            runner.rangeIndex = rangeIndex = random.nextInt(rangesCount);
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface ChildListNodeTester<FORM extends ExternalForm, CHILD_FORM, CHILD_VALUE>
    extends NodeTester<FORM, CHILD_FORM> {
        public CHILD_FORM addChild(FORM var1, CHILD_VALUE var2);

        public CHILD_FORM getChild(FORM var1, int var2);

        public CHILD_FORM getChildForm(List<CHILD_FORM> var1, int var2);

        public List<CHILD_FORM> getChildren(FORM var1);

        public int getChildrenSize(FORM var1);

        public CHILD_VALUE getChildValue(CHILD_FORM var1);

        public CHILD_VALUE getExpectedChildValue(int var1);

        public List<CHILD_VALUE> getExpectedChildValues();

        public List<String> getNodeNames();

        public void removeChild(FORM var1, int var2);
    }

    private class ChildListNodeTesterRunner
    extends NodeTesterRunner {
        ContainerNodeRetriever containerNodeRetriever;
        int currentChildListCount;
        int rangeIndex;
        List<Integer[]> ranges;

        ChildListNodeTesterRunner(ChildListNodeTester<FORM, ?, ?> tester) {
            super(tester);
            this.initialize(tester);
        }

        void addRange(int startIndex, int endIndex) {
            this.ranges.add(new Integer[]{Math.min(startIndex, endIndex), Math.max(startIndex, endIndex)});
        }

        private ContainerNodeRetriever buildContainerNodeRetriever() {
            return new ContainerNodeRetriever(){

                @Override
                public Node getContainerNode(Node parent) {
                    return parent;
                }
            };
        }

        private String displayString() {
            return "<" + this.getNodeName() + ">";
        }

        private List<Node> getChildrenNodes(Node node) {
            ChildListNodeTester tester = (ChildListNodeTester)this.tester;
            List<String> nodeNames = tester.getNodeNames();
            ArrayList<Node> children = new ArrayList<Node>();
            node = node.getFirstChild();
            while (node != null) {
                if (nodeNames.contains(node.getNodeName())) {
                    children.add(node);
                }
                node = node.getNextSibling();
            }
            return children;
        }

        private Node getContainerNode(Node parent) {
            return this.containerNodeRetriever.getContainerNode(parent);
        }

        int getDefaultChildrenCount() {
            ChildListNodeTester tester = (ChildListNodeTester)this.tester;
            return tester.getExpectedChildValues().size();
        }

        private int getNodePositionOfInsertion(Node node, List<String> nodeNames) {
            String nodeName = node.getNodeName();
            int index = 0;
            int count = nodeNames.size();
            while (index < count) {
                String name = nodeNames.get(index);
                if (name.equals(nodeName)) {
                    return index;
                }
                ++index;
            }
            Assert.fail((String)("The child node named <" + nodeName + "> is not included into the test"));
            return -1;
        }

        private void initialize(ChildListNodeTester<FORM, ?, ?> tester) {
            this.ranges = new ArrayList<Integer[]>();
            this.containerNodeRetriever = this.buildContainerNodeRetriever();
            List<?> childValues = tester.getExpectedChildValues();
            if (!childValues.isEmpty()) {
                Assert.assertTrue((String)"The list of child values should contain at least 10 items for proper testing", (childValues.size() >= 10 ? 1 : 0) != 0);
            }
        }

        @Override
        boolean isMultipleSupported() {
            return true;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return false;
        }

        @Override
        void setup() {
            this.rangeIndex = this.ranges.size();
            this.ranges.add(new Integer[]{0, this.getDefaultChildrenCount()});
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
            ChildListNodeTester tester = (ChildListNodeTester)this.tester;
            List<String> nodeNames = tester.getNodeNames();
            List values = tester.getExpectedChildValues();
            Integer[] range = this.ranges.get(this.rangeIndex);
            int index = range[0];
            while (index < range[1]) {
                Object value = values.get(index);
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child value cannot be null"), value);
                Object childForm = tester.addChild(holder.form, value);
                ++this.currentChildrenCount;
                ++this.currentChildListCount;
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form should have been created"), childForm);
                Node containerNode = this.getContainerNode(holder.node);
                List<Node> childrenNode = this.getChildrenNodes(containerNode);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node was not created correctly"), (long)this.currentChildListCount, (long)childrenNode.size());
                Assert.assertEquals((String)"The child node was not created correctly", (long)this.currentChildrenCount, (long)containerNode.getChildNodes().getLength());
                if (nodeNames.size() > 1) {
                    this.testOrdinalPosition(containerNode, nodeNames);
                }
                ++index;
            }
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
            ChildListNodeTester tester = (ChildListNodeTester)this.tester;
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : Incorrect number of children was retrieved"), (long)this.currentChildListCount, (long)tester.getChildren(holder.form).size());
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildListCount, (long)tester.getChildrenSize(holder.form));
            Node containerNode = this.getContainerNode(holder.node);
            if (containerNode == null) {
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)0L, (long)this.currentChildrenCount);
            } else {
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)containerNode.getChildNodes().getLength());
            }
        }

        private void testOrdinalPosition(Node containerNode, List<String> nodeNames) {
            Node childNode = containerNode.getFirstChild();
            if (childNode != null) {
                ArrayList<Integer> nodePositions = new ArrayList<Integer>();
                do {
                    int nodePosition = this.getNodePositionOfInsertion(childNode, nodeNames);
                    nodePositions.add(nodePosition);
                } while ((childNode = childNode.getNextSibling()) != null);
                int previousPosition = -1;
                Iterator iterator = nodePositions.iterator();
                while (iterator.hasNext()) {
                    int nodePosition = (Integer)iterator.next();
                    if (previousPosition > nodePosition) {
                        Assert.fail((String)"The insertion was not performed following the ordering.");
                    }
                    previousPosition = nodePosition;
                }
            }
        }

        @Override
        void testReading(ExternalFormHolder holder) {
            ChildListNodeTester tester = (ChildListNodeTester)this.tester;
            List childForms = tester.getChildren(holder.form);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildListCount, (long)childForms.size());
            Integer[] range = this.ranges.get(this.rangeIndex);
            int index = range[0];
            while (index < range[1]) {
                int translatedPosition = this.translatePosition(this.rangeIndex, index);
                Object childForm = tester.getChild(holder.form, translatedPosition);
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), childForm);
                Object childValue = tester.getChildValue(childForm);
                Object expectedChildValue = tester.getExpectedChildValue(index);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), expectedChildValue, childValue);
                childForm = tester.getChildForm(childForms, translatedPosition);
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), childForm);
                childValue = tester.getChildValue(childForm);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), expectedChildValue, childValue);
                ++index;
            }
            Random random = new Random();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int index2 = range[0];
            while (index2 < range[1]) {
                positions.add(index2);
                ++index2;
            }
            while (!positions.isEmpty()) {
                int position = positions.size() == 1 ? 0 : random.nextInt(positions.size());
                int index3 = (Integer)positions.remove(position);
                int translatedPosition = this.translatePosition(this.rangeIndex, index3);
                Object childForm = tester.getChild(holder.form, translatedPosition);
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), childForm);
                Object childValue = tester.getChildValue(childForm);
                Object expectedChildValue = tester.getExpectedChildValue(index3);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), expectedChildValue, childValue);
                childForm = tester.getChildForm(childForms, translatedPosition);
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), childForm);
                childValue = tester.getChildValue(childForm);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), expectedChildValue, childValue);
            }
        }

        private void testReadingAfterRemoval(ChildListNodeTester<FORM, Object, Object> tester, ExternalFormHolder holder, List<Object> childForms, List<Object> values, int rangesIndexToSkip, int offset) {
            int rangesIndex = 0;
            while (rangesIndex < this.ranges.size()) {
                if (rangesIndex != rangesIndexToSkip) {
                    Integer[] range = this.ranges.get(rangesIndex);
                    int rangeIndex = range[0];
                    while (rangeIndex < range[1]) {
                        int translatedPosition = this.translatePosition(rangesIndex, rangeIndex, rangesIndexToSkip);
                        if (rangesIndex > rangesIndexToSkip) {
                            translatedPosition += offset;
                        }
                        Object childForm = tester.getChild(holder.form, translatedPosition);
                        Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), (Object)childForm);
                        Object childValue = tester.getChildValue(childForm);
                        Object expectedChildValue = tester.getExpectedChildValue(rangeIndex);
                        Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), (Object)expectedChildValue, (Object)childValue);
                        childForm = tester.getChildForm(childForms, translatedPosition);
                        Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), (Object)childForm);
                        childValue = tester.getChildValue(childForm);
                        Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), (Object)expectedChildValue, (Object)childValue);
                        ++rangeIndex;
                    }
                }
                ++rangesIndex;
            }
        }

        private void testReadingAfterRemoval(ChildListNodeTester<FORM, Object, Object> tester, ExternalFormHolder holder, List<Object> childForms, List<Object> values, List<Integer> positions) {
            int childIndex = 0;
            for (int position : positions) {
                Object childForm = tester.getChild(holder.form, childIndex++);
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form cannot be null"), (Object)childForm);
                Object childValue = tester.getChildValue(childForm);
                Object expectedChildValue = tester.getExpectedChildValue(position);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child value was not retrieved correctly"), (Object)expectedChildValue, (Object)childValue);
            }
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
            if (this.ranges.isEmpty()) {
                return;
            }
            ChildListNodeTester tester = (ChildListNodeTester)this.tester;
            Random random = new Random();
            List<Object> values = tester.getExpectedChildValues();
            List<Object> readOnlyChildForms = tester.getChildren(holder.form);
            Integer[] range = this.ranges.get(this.rangeIndex);
            int rangeCount = this.ranges.size();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int index = range[0];
            while (index < range[1]) {
                positions.add(index);
                ++index;
            }
            ArrayList<Integer> readOnlyPositions = new ArrayList<Integer>();
            readOnlyPositions.addAll(positions);
            while (!positions.isEmpty()) {
                int position = positions.size() == 1 ? 0 : random.nextInt(positions.size());
                positions.remove(position);
                readOnlyPositions.remove(position);
                int translatedPosition = position;
                if (this.rangeIndex > 0) {
                    int previousRangeIndex = this.rangeIndex - 1;
                    int lastRangeIndex = this.ranges.get(previousRangeIndex)[1];
                    translatedPosition += this.translatePosition(previousRangeIndex, lastRangeIndex);
                }
                tester.removeChild(holder.form, translatedPosition);
                --this.currentChildrenCount;
                --this.currentChildListCount;
                int positionIndex = position;
                while (positionIndex < positions.size()) {
                    positions.set(positionIndex, (Integer)positions.get(positionIndex) - 1);
                    ++positionIndex;
                }
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildListCount, (long)tester.getChildrenSize(holder.form));
                Node containerNode = this.getContainerNode(holder.node);
                if (containerNode == null) {
                    Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)0L, (long)this.currentChildrenCount);
                } else {
                    Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)containerNode.getChildNodes().getLength());
                }
                List<Object> childForms = tester.getChildren(holder.form);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildListCount, (long)childForms.size());
                if (rangeCount == 1) {
                    this.testReadingAfterRemoval(tester, holder, readOnlyChildForms, values, readOnlyPositions);
                    continue;
                }
                this.testReadingAfterRemoval(tester, holder, childForms, values, this.rangeIndex, positions.size());
            }
            this.ranges.remove(this.rangeIndex);
        }

        private int translatePosition(int endRangesIndex, int rangeIndexToAdjust) {
            return this.translatePosition(endRangesIndex, rangeIndexToAdjust, -1);
        }

        private int translatePosition(int endRangeIndex, int rangeIndexToAdjust, int rangeIndexToSkip) {
            int translatedPosition = 0;
            int rangesIndex = 0;
            while (rangesIndex <= endRangeIndex) {
                if (rangesIndex != rangeIndexToSkip) {
                    Integer[] range = this.ranges.get(rangesIndex);
                    translatedPosition = rangesIndex != endRangeIndex ? (translatedPosition += range[1] - range[0]) : (translatedPosition += rangeIndexToAdjust - range[0]);
                }
                ++rangesIndex;
            }
            return translatedPosition;
        }
    }

    private class ChildNodeRunnerAddingController
    extends Controller {
        private ChildNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildNodeTesterRunner runner = (ChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChildNodeRunnerReadingController
    extends Controller {
        private ChildNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildNodeTesterRunner runner = (ChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
        }
    }

    private class ChildNodeRunnerRemovingController
    extends Controller {
        private ChildNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChildNodeTesterRunner runner = (ChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface ChildNodeTester<FORM extends ExternalForm, VALUE extends ExternalForm>
    extends NodeTester<FORM, VALUE> {
        public VALUE addChild(FORM var1);

        public VALUE getChild(FORM var1);

        public boolean hasChild(FORM var1);

        public void removeChild(FORM var1);
    }

    private class ChildNodeTesterRunner
    extends AbstractChildNodeTesterRunner {
        ChildNodeTesterRunner(ChildNodeTester<FORM, ?> tester) {
            super(tester);
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
            if (this.hasChild) {
                return;
            }
            ChildNodeTester tester = (ChildNodeTester)this.tester;
            Object childForm = tester.addChild(holder.form);
            this.hasChild = true;
            ++this.currentChildrenCount;
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child form should exist"), childForm);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Assert.assertTrue((String)(String.valueOf(this.displayString()) + " : The child node should have been found"), (boolean)tester.hasChild(holder.form));
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (Object)this.getChildNode(holder.node));
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
            ChildNodeTester tester = (ChildNodeTester)this.tester;
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (Object)this.hasChild, (Object)tester.hasChild(holder.form));
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            if (this.hasChild) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (Object)this.getChildNode(holder.node));
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (Object)this.getChildNode(holder.node));
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }

        @Override
        void testReading(ExternalFormHolder holder) {
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
            if (!this.hasChild) {
                return;
            }
            ChildNodeTester tester = (ChildNodeTester)this.tester;
            Assert.assertTrue((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (boolean)tester.hasChild(holder.form));
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should exist"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            tester.removeChild(holder.form);
            --this.currentChildrenCount;
            this.hasChild = false;
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child node should have been removed"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
            Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The wrong child node was removed"), (Object)this.getChildNode(holder.node));
            Assert.assertFalse((String)(String.valueOf(this.displayString()) + " : The child node should not exist"), (boolean)tester.hasChild(holder.form));
        }
    }

    private class ChoiceChildNodeRunnerAddingController
    extends Controller {
        private ChoiceChildNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            ChoiceChildNodeTesterRunner runner = (ChoiceChildNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChoiceChildNodeTesterRunner runner = (ChoiceChildNodeTesterRunner)this.runner;
            Random random = new Random();
            int index = random.nextInt(runner.testers.length);
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.index = index;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChoiceChildNodeRunnerReadingController
    extends Controller {
        private ChoiceChildNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            ChoiceChildNodeTesterRunner runner = (ChoiceChildNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getNodeName() + "> : reading");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChoiceChildNodeTesterRunner runner = (ChoiceChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChoiceChildNodeRunnerRemovingController
    extends Controller {
        private ChoiceChildNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            ChoiceChildNodeTesterRunner runner = (ChoiceChildNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getNodeName() + "> : removing");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ChoiceChildNodeTesterRunner runner = (ChoiceChildNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ChoiceChildNodeTesterRunner
    extends NodeTesterRunner {
        public int index;
        private ChildNodeTester<?, ?>[] testers;

        ChoiceChildNodeTesterRunner(ChildNodeTester<?, ?>[] testers) {
            super(null);
            this.index = -1;
            this.testers = testers;
        }

        @Override
        String getNodeName() {
            return this.testers[this.index].getNodeName();
        }

        @Override
        boolean isMultipleSupported() {
            return false;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return false;
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
        }

        @Override
        void testReading(ExternalFormHolder holder) {
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
        }
    }

    private class ContainerChildListNodeRunnerAddingController
    extends Controller {
        private ContainerChildListNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            ContainerChildListNodeTesterRunner runner = (ContainerChildListNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getContainerNodeName() + "> : adding");
        }

        @Override
        void test(ExternalFormHolder holder) {
            ContainerChildListNodeTesterRunner runner = (ContainerChildListNodeTesterRunner)this.runner;
            Random random = new Random();
            int count = runner.runner.getDefaultChildrenCount();
            int startIndex = random.nextInt(count);
            int endIndex = random.nextInt(count);
            while (endIndex == startIndex) {
                endIndex = random.nextInt(count);
            }
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.runner.addRange(startIndex, endIndex);
            ((ContainerChildListNodeTesterRunner)runner).runner.rangeIndex = ((ContainerChildListNodeTesterRunner)runner).runner.ranges.size() - 1;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            runner.testReading(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class ContainerChildListNodeRunnerReadingController
    extends Controller {
        private ContainerChildListNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            ContainerChildListNodeTesterRunner runner = (ContainerChildListNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getContainerNodeName() + "> : reading");
        }

        @Override
        void test(ExternalFormHolder holder) {
            int rangeIndex;
            ContainerChildListNodeTesterRunner runner = (ContainerChildListNodeTesterRunner)this.runner;
            int rangesCount = ((ContainerChildListNodeTesterRunner)runner).runner.ranges.size();
            if (rangesCount == 0) {
                return;
            }
            Random random = new Random();
            ((ContainerChildListNodeTesterRunner)runner).runner.rangeIndex = rangeIndex = random.nextInt(rangesCount);
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
        }
    }

    private class ContainerChildListNodeRunnerRemovingController
    extends Controller {
        private ContainerChildListNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            ContainerChildListNodeTesterRunner runner = (ContainerChildListNodeTesterRunner)this.runner;
            logger.log(Level.FINE, "<" + runner.parentNodeName + "><" + runner.getContainerNodeName() + "> : removing");
        }

        @Override
        void test(ExternalFormHolder holder) {
            int rangeIndex;
            ContainerChildListNodeTesterRunner runner = (ContainerChildListNodeTesterRunner)this.runner;
            int rangesCount = ((ContainerChildListNodeTesterRunner)runner).runner.ranges.size();
            if (rangesCount == 0) {
                return;
            }
            Random random = new Random();
            ((ContainerChildListNodeTesterRunner)runner).runner.rangeIndex = rangeIndex = random.nextInt(rangesCount);
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface ContainerChildListNodeTester<FORM extends ExternalForm, CHILD_FORM, CHILD_VALUE>
    extends ChildListNodeTester<FORM, CHILD_FORM, CHILD_VALUE> {
        public String getContainerNodeName();
    }

    private class ContainerChildListNodeTesterRunner
    extends NodeTesterRunner {
        private ChildListNodeTesterRunner runner;

        ContainerChildListNodeTesterRunner(ContainerChildListNodeTester<FORM, ?, ?> tester) {
            super(tester);
            this.runner = new ChildListNodeTesterRunner(tester);
            this.runner.containerNodeRetriever = this.buildContainerNodeRetreiver();
        }

        private ContainerNodeRetriever buildContainerNodeRetreiver() {
            return new ContainerNodeRetriever(){

                @Override
                public Node getContainerNode(Node parent) {
                    return ContainerChildListNodeTesterRunner.this.getNode(parent);
                }
            };
        }

        private String displayString() {
            return "<" + this.getContainerNodeName() + ">";
        }

        @Override
        String getActualNodeName() {
            return this.getContainerNodeName();
        }

        String getContainerNodeName() {
            ContainerChildListNodeTester tester = (ContainerChildListNodeTester)this.tester;
            return tester.getContainerNodeName();
        }

        private Node getNode(Node node) {
            node = node.getFirstChild();
            while (node != null) {
                if (this.getContainerNodeName().equals(node.getNodeName())) {
                    return node;
                }
                node = node.getNextSibling();
            }
            return null;
        }

        @Override
        boolean isMultipleSupported() {
            return false;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return false;
        }

        @Override
        void test(ExternalFormHolder holder) {
            this.runner.setup();
            super.test(holder);
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
            Node childNode = this.getNode(holder.node);
            if (childNode == null) {
                ++this.currentChildrenCount;
            }
            this.runner.testAdding(holder);
            Assert.assertEquals((String)(String.valueOf(this.runner.displayString()) + " : The child nodes were not created correctly"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
            this.runner.testInitialState(holder);
        }

        @Override
        void testReading(ExternalFormHolder holder) {
            this.runner.testReading(holder);
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
            this.runner.testRemoving(holder);
            Node childNode = this.getNode(holder.node);
            if (this.runner.currentChildListCount == 0) {
                --this.currentChildrenCount;
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The child nodes were not removed correctly"), (Object)childNode);
            } else {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The child nodes were not removed correctly"), (Object)childNode);
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child nodes were not removed correctly"), (long)this.currentChildrenCount, (long)holder.node.getChildNodes().getLength());
        }
    }

    static interface ContainerNodeRetriever {
        public Node getContainerNode(Node var1);
    }

    private abstract class Controller {
        int currentChildrenCount;
        NodeTesterRunner runner;

        private Controller() {
        }

        abstract void log(Logger var1);

        abstract void test(ExternalFormHolder var1);

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static interface ExternalFormBuilder<FORM extends ExternalForm> {
        public FORM buildExternalForm() throws IOException;

        public FORM buildExternalForm(ExternalForm var1);

        public int getDefaultAttributeCount();

        public Node getNode(FORM var1);

        public String getNodeName();

        public List<String> getTreeNodeNames();
    }

    private abstract class ExternalFormHolder {
        FORM form;
        Node node;

        private ExternalFormHolder() {
        }

        abstract void rebuild();
    }

    private static interface NodeCountRetriever {
        public int getCount(Node var1);
    }

    private static interface NodeTester<FORM extends ExternalForm, Value> {
        public String getNodeName();
    }

    private abstract class NodeTesterRunner {
        int currentChildrenCount;
        ExternalFormHolder holder;
        String parentNodeName;
        final NodeTester<FORM, Object> tester;

        NodeTesterRunner(NodeTester<FORM, ?> tester) {
            this.tester = tester;
            Assert.assertNotNull((String)("The tester cannot be null: " + tester), tester);
            Assert.assertNotNull((String)("The node name cannot be null: " + tester), (Object)tester.getNodeName());
        }

        String getActualNodeName() {
            return this.getNodeName();
        }

        String getNodeName() {
            return this.tester.getNodeName();
        }

        abstract boolean isMultipleSupported();

        abstract boolean isNodeDeletedWithNullValue();

        void setup() {
        }

        void test(ExternalFormHolder holder) {
            this.setup();
            this.testInitialState(holder);
            this.testAdding(holder);
            this.testReading(holder);
            this.testRemoving(holder);
        }

        abstract void testAdding(ExternalFormHolder var1);

        abstract void testInitialState(ExternalFormHolder var1);

        abstract void testReading(ExternalFormHolder var1);

        abstract void testRemoving(ExternalFormHolder var1);

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " : " + this.tester.getNodeName();
        }
    }

    private class NotSupportedAttributeTester
    implements AttributeNodeTester<FORM, Object> {
        private String attributeName;

        NotSupportedAttributeTester(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public boolean doesNodeAlreadyExist() {
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public String getNodeName() {
            return this.attributeName;
        }

        @Override
        public Object getValue(FORM form) {
            return null;
        }

        @Override
        public Object getValue1() {
            return null;
        }

        @Override
        public Object getValue2() {
            return null;
        }

        @Override
        public boolean isNodeDeletedWithNullValue() {
            return false;
        }

        @Override
        public boolean isNullAllowed() {
            return false;
        }

        @Override
        public void setValue(FORM form, Object value) {
        }

        @Override
        public String toString(Object value) {
            return null;
        }
    }

    private class NotSupportedAttributeTesterRunner
    extends AttributeNodeTesterRunner {
        NotSupportedAttributeTesterRunner(String attributeName) {
            super(new NotSupportedAttributeTester(attributeName));
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
        }

        @Override
        void testReading(ExternalFormHolder holder) {
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
        }
    }

    private class NotSupportedNodeTester
    implements NodeTester<FORM, Object> {
        private String nodeName;

        NotSupportedNodeTester(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }
    }

    private class NotSupportedNodeTesterRunner
    extends NodeTesterRunner {
        NotSupportedNodeTesterRunner(String nodeName) {
            super(new NotSupportedNodeTester(nodeName));
        }

        @Override
        boolean isMultipleSupported() {
            return false;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return false;
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
        }

        @Override
        void testReading(ExternalFormHolder holder) {
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
        }
    }

    private abstract class PropertyNodeTesterRunner
    extends NodeTesterRunner {
        private boolean nodeExists;

        PropertyNodeTesterRunner(PropertyTester<FORM, ?> tester) {
            super(tester);
        }

        abstract String displayString();

        abstract int getChildrenCount(Node var1);

        abstract Node getNode(Node var1);

        abstract String getNodeValue(Node var1);

        @Override
        final boolean isMultipleSupported() {
            return false;
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return this.propertyTester().isNodeDeletedWithNullValue();
        }

        PropertyTester<FORM, Object> propertyTester() {
            return (PropertyTester)this.tester;
        }

        @Override
        void testAdding(ExternalFormHolder holder) {
            PropertyTester tester = this.propertyTester();
            if (tester.isNullAllowed()) {
                tester.setValue(holder.form, null);
                if (this.nodeExists) {
                    this.nodeExists = false;
                    --this.currentChildrenCount;
                }
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
                Object result = tester.getValue(holder.form);
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The element's value should be null"), (Object)result);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
                if (tester.isNodeDeletedWithNullValue()) {
                    holder.rebuild();
                }
            }
            Object expectedValue1 = tester.getValue1();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : Value 1 cannot be null"), (Object)expectedValue1);
            tester.setValue(holder.form, expectedValue1);
            if (!this.nodeExists) {
                this.nodeExists = true;
                ++this.currentChildrenCount;
            }
            Node childNode = this.getNode(holder.node);
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The node cannot be null"), (Object)childNode);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should have a " + this.currentChildrenCount + " children"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
            Object result = tester.getValue(holder.form);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element's value was not set correctly"), (Object)expectedValue1, (Object)result);
            String stringResult = this.getNodeValue(childNode);
            String stringNodeValue = tester.toString(expectedValue1);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The value was not set correctly"), (Object)stringNodeValue, (Object)stringResult);
            Object expectedValue2 = tester.getValue2();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : Value 2 cannot be null"), (Object)expectedValue2);
            Assert.assertNotSame((String)(String.valueOf(this.displayString()) + " : Value 1 and value 2 cannot be the same"), (Object)expectedValue1, (Object)expectedValue2);
            tester.setValue(holder.form, expectedValue2);
            result = tester.getValue(holder.form);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " The element's value was not set correctly"), (Object)expectedValue2, (Object)result);
            stringResult = this.getNodeValue(childNode);
            stringNodeValue = tester.toString(expectedValue2);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element's value was not set correctly"), (Object)stringNodeValue, (Object)stringResult);
            Object defaultValue = tester.getDefaultValue();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The default value cannot be null"), (Object)defaultValue);
            tester.setValue(holder.form, defaultValue);
        }

        @Override
        void testInitialState(ExternalFormHolder holder) {
            PropertyTester tester = (PropertyTester)this.tester;
            this.nodeExists |= tester.doesNodeAlreadyExist();
            String nodeName = this.getNodeName();
            Assert.assertNotNull((String)"The node name cannot be null", (Object)nodeName);
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child count is incorrect"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
            Node childNode = this.getNode(holder.node);
            if (this.nodeExists) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The node should not be null"), (Object)childNode);
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The node should be null"), (Object)childNode);
            }
        }

        @Override
        void testReading(ExternalFormHolder holder) {
            PropertyTester tester = (PropertyTester)this.tester;
            Object result = tester.getValue(holder.form);
            if (this.nodeExists) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The element's value should not be null"), result);
                Assert.assertSame((String)(String.valueOf(this.displayString()) + " : The element's value was not retrived correctly"), tester.getDefaultValue(), result);
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The element's value should be null"), result);
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
            Node childNode = this.getNode(holder.node);
            if (this.nodeExists) {
                Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The node should not be null"), (Object)childNode);
            } else {
                Assert.assertNull((String)(String.valueOf(this.displayString()) + " : The node should be null"), (Object)childNode);
            }
            Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The element should not have any children"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
        }

        @Override
        void testRemoving(ExternalFormHolder holder) {
            PropertyTester tester = (PropertyTester)this.tester;
            if (tester.isNullAllowed()) {
                tester.setValue(holder.form, null);
                if (this.nodeExists) {
                    this.nodeExists = false;
                    --this.currentChildrenCount;
                }
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The child count does not match the current state"), (long)this.currentChildrenCount, (long)this.getChildrenCount(holder.node));
            }
        }
    }

    private static interface PropertyTester<FORM extends ExternalForm, VALUE>
    extends NodeTester<FORM, VALUE> {
        public boolean doesNodeAlreadyExist();

        public VALUE getDefaultValue();

        public VALUE getValue(FORM var1);

        public VALUE getValue1();

        public VALUE getValue2();

        public boolean isNodeDeletedWithNullValue();

        public boolean isNullAllowed();

        public void setValue(FORM var1, VALUE var2);

        public String toString(VALUE var1);
    }

    public final class RootNodeTester {
        private List<AttributeNodeTesterRunner> attributes = new ArrayList<AttributeNodeTesterRunner>();
        private ExternalFormBuilder<FORM> builder;
        private List<NodeTesterRunner> children = new ArrayList<NodeTesterRunner>();

        private RootNodeTester() {
        }

        public void addAttribute(AttributeNodeTester<FORM, ?> tester) {
            this.attributes.add(new AttributeNodeTesterRunner(tester));
        }

        public void addBooleanNode(BooleanChildNodeTester<FORM> tester) {
            this.children.add(new BooleanChildNodeTesterRunner(tester));
        }

        public void addChildAttribute(ChildAttributeTester<FORM, ?> tester) {
            this.children.add(new ChildAttributeTesterRunner(tester));
        }

        public void addChoiceNodes(ChildNodeTester<?, ?>[] testers) {
            this.children.add(new ChoiceChildNodeTesterRunner(testers));
        }

        public void addContainerListNodes(ContainerChildListNodeTester<FORM, ?, ?> tester) {
            this.children.add(new ContainerChildListNodeTesterRunner(tester));
        }

        public void addListNodes(ChildListNodeTester<FORM, ?, ?> tester) {
            this.children.add(new ChildListNodeTesterRunner(tester));
        }

        public void addNode(ChildNodeTester<FORM, ?> tester) {
            this.children.add(new ChildNodeTesterRunner(tester));
        }

        public void addTextNode(TextNodeTester<FORM, ?> tester) {
            this.children.add(new TextNodeTesterRunner(tester));
        }

        public void addUnsupportedAttribute(String attributeName) {
            this.attributes.add(new NotSupportedAttributeTesterRunner(attributeName));
        }

        public void addUnsupportedNode(String nodeName) {
            this.children.add(new NotSupportedNodeTesterRunner(nodeName));
        }

        private Map<Class<NodeTesterRunner>, Class<Controller>[]> buildAttributeControllerTypes() {
            HashMap<Class<NodeTesterRunner>, Class<Controller>[]> classes = new HashMap<Class<NodeTesterRunner>, Class<Controller>[]>();
            classes.put(AttributeNodeTesterRunner.class, new Class[]{AttributeNodeRunnerAddingController.class, AttributeNodeRunnerReadingController.class, AttributeNodeRunnerRemovingController.class});
            return classes;
        }

        private NodeCountRetriever buildAttributeCountRetriever() {
            return new NodeCountRetriever(){

                @Override
                public int getCount(Node node) {
                    return node.getAttributes().getLength();
                }
            };
        }

        private Map<Class<NodeTesterRunner>, Class<Controller>[]> buildChildrenControllerTypes() {
            HashMap<Class<NodeTesterRunner>, Class<Controller>[]> classes = new HashMap<Class<NodeTesterRunner>, Class<Controller>[]>();
            classes.put(ChildAttributeTesterRunner.class, new Class[]{ChildAttributeRunnerAddingController.class, ChildAttributeRunnerReadingController.class, ChildAttributeRunnerRemovingController.class});
            classes.put(BooleanChildNodeTesterRunner.class, new Class[]{BooleanChildNodeRunnerAddingController.class, BooleanChildNodeRunnerReadingController.class, BooleanChildNodeRunnerRemovingController.class});
            classes.put(ChildNodeTesterRunner.class, new Class[]{ChildNodeRunnerAddingController.class, ChildNodeRunnerReadingController.class, ChildNodeRunnerRemovingController.class});
            classes.put(TextNodeTesterRunner.class, new Class[]{TextNodeRunnerAddingController.class, TextNodeRunnerReadingController.class, TextNodeRunnerRemovingController.class});
            classes.put(ChildListNodeTesterRunner.class, new Class[]{ChildListNodeRunnerAddingController.class, ChildListNodeRunnerReadingController.class, ChildListNodeRunnerRemovingController.class});
            classes.put(ContainerChildListNodeTesterRunner.class, new Class[]{ContainerChildListNodeRunnerAddingController.class, ContainerChildListNodeRunnerReadingController.class, ContainerChildListNodeRunnerRemovingController.class});
            classes.put(ChoiceChildNodeTesterRunner.class, new Class[]{ChoiceChildNodeRunnerAddingController.class, ChoiceChildNodeRunnerReadingController.class, ChoiceChildNodeRunnerRemovingController.class});
            return classes;
        }

        private NodeCountRetriever buildChildrenCountRetriever() {
            return new NodeCountRetriever(){

                @Override
                public int getCount(Node node) {
                    return node.getChildNodes().getLength();
                }
            };
        }

        private ExternalFormHolder buildExternalFormHolder() {
            return new ExternalFormHolder(AbstractExternalFormTests.this){

                @Override
                void rebuild() {
                    this.form = (ExternalForm)ObjectTools.execute((Object)this.form, (String)"getParent");
                    this.form = RootNodeTester.this.builder.buildExternalForm(this.form);
                    this.node = (Node)ObjectTools.execute((Object)this.form, (String)"getElement");
                }
            };
        }

        private String displayString() {
            return "<" + this.builder.getNodeName() + ">";
        }

        private Node getNode(Node node) {
            if (node.getNodeName().equals(this.builder.getNodeName())) {
                return node;
            }
            return this.getNode(node, this.builder.getTreeNodeNames());
        }

        private Node getNode(Node node, List<String> nodeNames) {
            String nodeName = nodeNames.get(0);
            node = node.getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals(nodeName)) {
                    if (nodeNames.size() == 1) {
                        return node;
                    }
                    return this.getNode(node, nodeNames.subList(1, nodeNames.size()));
                }
                node = node.getNextSibling();
            }
            return null;
        }

        private int getNodePositionOfInsertion(Node node) {
            String nodeName = node.getNodeName();
            int index = 0;
            int count = this.children.size();
            while (index < count) {
                NodeTesterRunner runner = this.children.get(index);
                if (runner.getActualNodeName().equals(nodeName)) {
                    return index;
                }
                ++index;
            }
            Assert.fail((String)("The child node named <" + nodeName + "> is not included into the test"));
            return -1;
        }

        public void setBuilder(ExternalFormBuilder<? extends FORM> builder) {
            this.builder = builder;
        }

        void test() throws Exception {
            Object form = this.builder.buildExternalForm();
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The external form cannot be null"), form);
            Node node = this.builder.getNode(form);
            Assert.assertNotNull((String)(String.valueOf(this.displayString()) + " : The node cannot be null"), (Object)node);
            Node expectedNode = this.getNode(node.getOwnerDocument());
            Assert.assertSame((String)(String.valueOf(this.displayString()) + " : The node was not retrieved correctly"), (Object)expectedNode, (Object)node);
            ExternalFormHolder holder = this.buildExternalFormHolder();
            holder.form = form;
            holder.node = node;
            this.testAttributes(holder);
            this.testChildren(holder);
            this.testAttributesRandomly(holder);
            this.testChildNodesRandomly(holder);
        }

        private void testAttributes(ExternalFormHolder holder) {
            int defaultAttributeCount = this.builder.getDefaultAttributeCount();
            for (AttributeNodeTesterRunner runner : this.attributes) {
                runner.currentChildrenCount = defaultAttributeCount;
                runner.parentNodeName = this.builder.getNodeName();
                runner.test(holder);
                if (runner.isNodeDeletedWithNullValue()) {
                    holder.rebuild();
                }
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of attributes is inconsistent"), (long)defaultAttributeCount, (long)holder.node.getAttributes().getLength());
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : The number of children is inconsistent"), (long)0L, (long)holder.node.getChildNodes().getLength());
            }
        }

        private void testAttributesRandomly(ExternalFormHolder holder) throws Exception {
            this.testNodesRandomly(holder, this.attributes, this.buildAttributeCountRetriever(), this.buildAttributeControllerTypes());
        }

        private void testChildNodesRandomly(ExternalFormHolder holder) throws Exception {
            this.testNodesRandomly(holder, this.children, this.buildChildrenCountRetriever(), this.buildChildrenControllerTypes());
        }

        private void testChildren(ExternalFormHolder holder) {
            for (NodeTesterRunner runner : this.children) {
                runner.parentNodeName = this.builder.getNodeName();
                runner.test(holder);
                Assert.assertEquals((String)(String.valueOf(this.displayString()) + " : No child nodes should have been left after a test"), (long)0L, (long)holder.node.getChildNodes().getLength());
                if (!runner.isNodeDeletedWithNullValue()) continue;
                holder.rebuild();
            }
        }

        private void testNodesRandomly(ExternalFormHolder holder, List<? extends NodeTesterRunner> runners, NodeCountRetriever countRetriever, Map<Class<NodeTesterRunner>, Class<Controller>[]> controllerClasses) throws Exception {
            ArrayList<Controller> controllers = new ArrayList<Controller>();
            Random random = new Random();
            int childrenCount = runners.size();
            int controllerTypeCount = controllerClasses.size();
            int executionCount = childrenCount * controllerTypeCount * 20;
            int index = 0;
            while (index < executionCount) {
                int childIndex = random.nextInt(childrenCount);
                NodeTesterRunner runner = runners.get(childIndex);
                Class<Controller>[] controllerTypes = controllerClasses.get(runner.getClass());
                if (controllerTypes != null) {
                    int controllerIndex = random.nextInt(controllerTypes.length);
                    Class<Controller> controllerType = controllerTypes[controllerIndex];
                    Controller controller = (Controller)ClassTools.newInstance(controllerType, AbstractExternalFormTests.class, (Object)AbstractExternalFormTests.this);
                    controller.runner = runner;
                    controllers.add(controller);
                }
                ++index;
            }
            for (Controller controller : controllers) {
                controller.currentChildrenCount = countRetriever.getCount(holder.node);
                controller.test(holder);
                this.testOrdinalPosition(holder.node);
            }
        }

        private void testOrdinalPosition(Node parent) {
            Node childNode = parent.getFirstChild();
            if (childNode != null) {
                ArrayList<Integer> nodePositions = new ArrayList<Integer>();
                do {
                    int nodePosition = this.getNodePositionOfInsertion(childNode);
                    nodePositions.add(nodePosition);
                } while ((childNode = childNode.getNextSibling()) != null);
                int previousPosition = -1;
                Iterator iterator = nodePositions.iterator();
                while (iterator.hasNext()) {
                    int nodePosition = (Integer)iterator.next();
                    if (previousPosition > nodePosition) {
                        Assert.fail((String)"The insertion was not performed following the ordering.");
                    }
                    previousPosition = nodePosition;
                }
            }
        }
    }

    private class TextNodeRunnerAddingController
    extends Controller {
        private TextNodeRunnerAddingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            TextNodeTesterRunner runner = (TextNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testAdding(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    private class TextNodeRunnerReadingController
    extends Controller {
        private TextNodeRunnerReadingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            TextNodeTesterRunner runner = (TextNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testReading(holder);
        }
    }

    private class TextNodeRunnerRemovingController
    extends Controller {
        private TextNodeRunnerRemovingController() {
        }

        @Override
        void log(Logger logger) {
            logger.log(Level.FINE, "<" + this.runner.parentNodeName + "><" + this.runner.tester.getNodeName() + "> : addition");
        }

        @Override
        void test(ExternalFormHolder holder) {
            TextNodeTesterRunner runner = (TextNodeTesterRunner)this.runner;
            runner.currentChildrenCount = this.currentChildrenCount;
            runner.testInitialState(holder);
            runner.testRemoving(holder);
            this.currentChildrenCount = runner.currentChildrenCount;
        }
    }

    public static interface TextNodeTester<FORM extends ExternalForm, VALUE>
    extends PropertyTester<FORM, VALUE> {
    }

    private class TextNodeTesterRunner
    extends PropertyNodeTesterRunner {
        TextNodeTesterRunner(TextNodeTester<FORM, ?> tester) {
            super(tester);
        }

        @Override
        String displayString() {
            return "<" + this.parentNodeName + "><" + this.getNodeName() + "></>";
        }

        @Override
        int getChildrenCount(Node parentNode) {
            return parentNode.getChildNodes().getLength();
        }

        @Override
        Node getNode(Node node) {
            node = node.getFirstChild();
            while (node != null) {
                if (this.getNodeName().equals(node.getNodeName())) {
                    return node;
                }
                node = node.getNextSibling();
            }
            return null;
        }

        @Override
        String getNodeValue(Node node) {
            return node.getTextContent();
        }

        @Override
        boolean isNodeDeletedWithNullValue() {
            return ((TextNodeTester)this.tester).isNodeDeletedWithNullValue();
        }
    }
}

