/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceUnit;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class Property
extends AbstractExternalForm
implements ExternalProperty {
    private int index;

    Property(PersistenceUnit parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public Element addSelf(String elementName, List<String> elementNamesOrder) {
        Element element = this.getParent().getChild("properties");
        if (element == null) {
            element = this.getParent().addChild("properties");
        }
        return this.addChild(element, elementName, Collections.<String>emptyList());
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public Element getElement() {
        Element element = this.getChild(this.getParent(), "properties");
        if (element != null) {
            return this.getChild(element, "property", this.index);
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "property";
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public TextRange getValueTextRange() {
        return this.getAttributeTextRange("value");
    }

    @Override
    public String getValueType() {
        return this.getAttribute("value-type");
    }

    @Override
    public void removeSelf() {
        Element element = this.getChild(this.getParent(), "properties");
        if (element != null) {
            this.removeChild(element, "property", this.index);
            if (!this.hasAnyChildren(element)) {
                this.remove(this.getParentElement(), element);
            }
        }
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    public void setValueType(String valueType) {
        this.setAttribute("value-type", valueType);
    }
}

