/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalOrderColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.OrderColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.RelationshipMapping;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

abstract class ObjectCollectionMapping
extends RelationshipMapping
implements ExternalObjectCollectionMapping {
    ObjectCollectionMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public ExternalAssociationOverride addMapKeyAssociationOverride() {
        AssociationOverride associationOverride = this.buildMapKeyAssociationOverride(-1);
        associationOverride.addSelf();
        return associationOverride;
    }

    @Override
    public ExternalAttributeOverride addMapKeyAttributeOverride() {
        AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(-1);
        attributeOverride.addSelf();
        return attributeOverride;
    }

    @Override
    public ExternalEntityColumn addMapKeyColumn() {
        EntityColumn column = this.buildColumn("map-key-column");
        column.addSelf();
        return column;
    }

    @Override
    public ExternalJoinColumn addMapKeyJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn("map-key-join-column", -1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    public ExternalOrderColumn addOrderColumn() {
        OrderColumn orderColumn = this.buildOrderColumn();
        orderColumn.addSelf();
        return orderColumn;
    }

    private EntityColumn buildColumn(String elementName) {
        return new EntityColumn(this, elementName, -1);
    }

    final JoinColumn buildJoinColumn(String elementName, int index) {
        return new JoinColumn(this, elementName, index);
    }

    private AssociationOverride buildMapKeyAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    private AttributeOverride buildMapKeyAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    private OrderColumn buildOrderColumn() {
        return new OrderColumn(this);
    }

    @Override
    public String getMapKey() {
        return this.getChildAttribute("map-key", "name");
    }

    @Override
    public ExternalAssociationOverride getMapKeyAssociationOverride(int index) {
        if (this.hasChild("map-key-association-override", index)) {
            return this.buildMapKeyAssociationOverride(index);
        }
        return null;
    }

    @Override
    public ExternalAttributeOverride getMapKeyAttributeOverride(int index) {
        if (this.hasChild("map-key-attribute-override", index)) {
            return this.buildMapKeyAttributeOverride(index);
        }
        return null;
    }

    @Override
    public String getMapKeyClassName() {
        return this.getChildAttribute("map-key-class", "class");
    }

    @Override
    public TextRange getMapKeyClassNameTextRange() {
        return this.getChildAttributeTextRange("map-key-class", "class");
    }

    @Override
    public ExternalEntityColumn getMapKeyColumn() {
        if (this.hasChild("map-key-column")) {
            return this.buildColumn("map-key-column");
        }
        return null;
    }

    @Override
    public String getMapKeyConverterName() {
        return this.getChildTextNode("map-key-convert");
    }

    @Override
    public TextRange getMapKeyConverterNameTextRange() {
        return this.getChildTextNodeTextRange("map-key-convert");
    }

    @Override
    public EnumType getMapKeyEnumeratedType() {
        return this.getChildEnumNode("map-key-enumerated", EnumType.class);
    }

    @Override
    public TextRange getMapKeyEnumeratedTypeTextRange() {
        return this.getChildTextNodeTextRange("map-key-enumerated");
    }

    @Override
    public ExternalJoinColumn getMapKeyJoinColumn(int index) {
        if (this.hasChild("map-key-join-column", index)) {
            return this.buildJoinColumn("map-key-join-column", index);
        }
        return null;
    }

    @Override
    public TemporalType getMapKeyTemporalType() {
        return this.getChildEnumNode("map-key-temporal", TemporalType.class);
    }

    @Override
    public TextRange getMapKeyTemporalTypeTextRange() {
        return this.getChildTextNodeTextRange("map-key-temporal");
    }

    @Override
    public TextRange getMapKeyTextRange() {
        return this.getChildAttributeTextRange("map-key", "name");
    }

    @Override
    public String getOrderByFieldName() {
        return this.getChildTextNode("order-by");
    }

    @Override
    public TextRange getOrderByFieldNameTextRange() {
        return this.getChildTextNodeTextRange("order-by");
    }

    @Override
    public ExternalOrderColumn getOrderColumn() {
        if (this.hasChild("order-column")) {
            return this.buildOrderColumn();
        }
        return null;
    }

    @Override
    public boolean hasOrderByClause() {
        return this.hasChild("order-by");
    }

    @Override
    public List<ExternalAssociationOverride> mapKeyAssociationOverrides() {
        int count = this.mapKeyAssociationOverridesSize();
        ArrayList<ExternalAssociationOverride> associationOverrides = new ArrayList<ExternalAssociationOverride>(count);
        int index = 0;
        while (index < count) {
            associationOverrides.add(this.buildMapKeyAssociationOverride(index));
            ++index;
        }
        return associationOverrides;
    }

    @Override
    public int mapKeyAssociationOverridesSize() {
        return this.getChildrenSize("map-key-association-override");
    }

    @Override
    public List<ExternalAttributeOverride> mapKeyAttributeOverrides() {
        int count = this.mapKeyAttributeOverridesSize();
        ArrayList<ExternalAttributeOverride> attributeOverrides = new ArrayList<ExternalAttributeOverride>(count);
        int index = 0;
        while (index < count) {
            attributeOverrides.add(this.buildMapKeyAttributeOverride(index));
            ++index;
        }
        return attributeOverrides;
    }

    @Override
    public int mapKeyAttributeOverridesSize() {
        return this.getChildrenSize("map-key-attribute-override");
    }

    @Override
    public List<ExternalJoinColumn> mapKeyJoinColumns() {
        int count = this.mapKeyJoinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn("map-key-join-column", index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int mapKeyJoinColumnsSize() {
        return this.getChildrenSize("map-key-join-column");
    }

    @Override
    public void removeMapKeyAssociationOverride(int index) {
        AssociationOverride joinColumn = this.buildMapKeyAssociationOverride(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeMapKeyAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public void removeMapKeyColumn() {
        EntityColumn column = this.buildColumn("map-key-column");
        column.removeSelf();
    }

    @Override
    public void removeMapKeyJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn("map-key-join-column", index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeOrderColumn() {
        OrderColumn orderColumn = this.buildOrderColumn();
        orderColumn.removeSelf();
    }

    @Override
    public void setMapKey(String mapKey) {
        if (mapKey == null) {
            this.removeChild("map-key");
        } else {
            Element element = this.getChild("map-key");
            if (element == null) {
                element = this.addChild("map-key");
            }
            this.setAttribute(element, "name", mapKey);
        }
    }

    @Override
    public void setMapKeyClassName(String className) {
        if (className == null) {
            this.removeChild("map-key-class");
        } else {
            Element element = this.getChild("map-key-class");
            if (element == null) {
                element = this.addChild("map-key-class");
            }
            this.setAttribute(element, "class", className);
        }
    }

    @Override
    public void setMapKeyConverterName(String converterName) {
        this.updateChildTextNode("map-key-convert", converterName);
    }

    @Override
    public void setMapKeyEnumeratedType(EnumType enumType) {
        this.updateChildTextNode("map-key-enumerated", (Enum<?>)enumType);
    }

    @Override
    public void setMapKeyTemporalType(TemporalType temporalType) {
        this.updateChildTextNode("map-key-temporal", (Enum<?>)temporalType);
    }

    @Override
    public void setOrderByFieldName(String name) {
        this.updateChildTextNode("order-by", name);
    }
}

