/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectCollectionMapping;
import org.eclipse.persistence.tools.utility.TextRange;

final class ManyToManyMapping
extends ObjectCollectionMapping
implements ExternalManyToManyMapping {
    ManyToManyMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalNoSqlJoinField addJoinField(String name) {
        NoSqlJoinField joinField = this.buildJoinField(-1);
        joinField.addSelf();
        joinField.setName(name);
        return joinField;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("access");
        names.add("mapped-by-id");
        names.add("attribute-type");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("order-by");
        names.add("order-column");
        names.add("map-key");
        names.add("map-key-class");
        names.add("map-key-temporal");
        names.add("map-key-enumerated");
        names.add("map-key-convert");
        names.add("map-key-attribute-override");
        names.add("map-key-association-override");
        names.add("map-key-column");
        names.add("map-key-join-column");
        names.add("join-table");
        names.add("cascade");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private NoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    @Override
    protected String getElementName() {
        return "many-to-many";
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute("mapped-by-id");
    }

    @Override
    public TextRange getMappedByMappingNameTextRange() {
        return this.getAttributeTextRange("mapped-by-id");
    }

    @Override
    public List<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = 0;
        while (index < count) {
            joinFields.add(this.buildJoinField(index));
            ++index;
        }
        return joinFields;
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute("mapped-by-id", name);
    }
}

