/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.ClassConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.CollectionTable;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;
import org.eclipse.persistence.tools.utility.TextRange;

final class BasicMapMapping
extends ConvertibleMapping
implements ExternalBasicMapMapping {
    BasicMapMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalBatchFetch addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
        return batchFetch;
    }

    @Override
    public ExternalCollectionTable addCollectionTable(String name) {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.addSelf();
        collectionTable.setName(name);
        return collectionTable;
    }

    @Override
    public ExternalEntityColumn addKeyColumn(String columnName) {
        EntityColumn column = this.buildColumn("key-column");
        column.addSelf();
        column.setName(columnName);
        return column;
    }

    @Override
    public void addKeyConverterString(String converter) {
        this.updateChildTextNode("key-converter", converter);
    }

    @Override
    public ExternalEntityColumn addValueColumn(String columnName) {
        EntityColumn column = this.buildColumn("value-column");
        column.addSelf();
        column.setName(columnName);
        return column;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("fetch");
        names.add("access");
        return names;
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private CollectionTable buildCollectionTable() {
        return new CollectionTable(this);
    }

    private EntityColumn buildColumn(String elementName) {
        return new EntityColumn(this, elementName, -1);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("key-column");
        names.add("key-converter");
        names.add("value-column");
        names.add("value-converter");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("collection-table");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ClassConverter buildKeyConverter() {
        return new ClassConverter(this, -1);
    }

    private ObjectTypeConverter buildKeyObjectTypeConverter() {
        return new ObjectTypeConverter(this, -1);
    }

    private StructConverter buildKeyStructConverter() {
        return new StructConverter(this, -1);
    }

    private TypeConverter buildKeyTypeConverter() {
        return new TypeConverter(this, -1);
    }

    @Override
    public ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public ExternalCollectionTable getCollectionTable() {
        if (this.hasChild("collection-table")) {
            return this.buildCollectionTable();
        }
        return null;
    }

    @Override
    public String getConvert() {
        return this.getChildTextNode("value-converter");
    }

    @Override
    protected String getElementName() {
        return "basic-map";
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute("fetch", FetchType.class);
    }

    @Override
    public TextRange getFetchTypeTextRange() {
        return this.getAttributeTextRange("fetch");
    }

    @Override
    public JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode("join-fetch", JoinFetchType.class);
    }

    @Override
    public TextRange getJoinFetchTypeTextRange() {
        return this.getChildTextNodeTextRange("join-fetch");
    }

    @Override
    public ExternalEntityColumn getKeyColumn() {
        if (this.hasChild("key-column")) {
            return this.buildColumn("key-column");
        }
        return null;
    }

    @Override
    public ExternalClassConverter getKeyConverter() {
        if (this.hasChild("key-converter")) {
            return this.buildKeyConverter();
        }
        return null;
    }

    @Override
    public TextRange getKeyConveterTextRange() {
        return this.getChildTextNodeTextRange("key-converter");
    }

    @Override
    public ExternalObjectTypeConverter getKeyObjectTypeConverter() {
        if (this.hasChild("object-type-converter")) {
            return this.buildKeyObjectTypeConverter();
        }
        return null;
    }

    @Override
    public ExternalStructConverter getKeyStructConverter() {
        if (this.hasChild("key-converter")) {
            return this.buildKeyStructConverter();
        }
        return null;
    }

    @Override
    public ExternalTypeConverter getKeyTypeConverter() {
        if (this.hasChild("type-converter")) {
            return this.buildKeyTypeConverter();
        }
        return null;
    }

    @Override
    public ExternalEntityColumn getValueColumn() {
        if (this.hasChild("value-column")) {
            return this.buildColumn("value-column");
        }
        return null;
    }

    @Override
    public void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public void removeCollectionTable() {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.removeSelf();
    }

    @Override
    public void removeKeyColumn() {
        EntityColumn column = this.buildColumn("key-column");
        column.removeSelf();
    }

    @Override
    public void removeKeyConverter() {
        this.removeChild("converter");
    }

    @Override
    public void removeKeyConverterString() {
        EntityColumn column = this.buildColumn("key-converter");
        column.removeSelf();
    }

    @Override
    public void removeKeyObjectTypeConverter() {
        this.removeChild("object-type-converter");
    }

    @Override
    public void removeKeyStructConverter() {
        this.removeChild("struct-converter");
    }

    @Override
    public void removeKeyTypeConverter() {
        this.removeChild("type-converter");
    }

    @Override
    public void removeValueColumn() {
        EntityColumn column = this.buildColumn("value-column");
        column.removeSelf();
    }

    @Override
    public void setAsKeyConverter(String name, String className) {
        this.removeChild("type-converter");
        this.removeChild("object-type-converter");
        this.removeChild("struct-converter");
        ClassConverter valueConverter = this.buildKeyConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
        valueConverter.setClassName(className);
    }

    @Override
    public void setAsKeyObjectTypeConverter(String name) {
        this.removeChild("type-converter");
        this.removeChild("converter");
        this.removeChild("struct-converter");
        ObjectTypeConverter valueConverter = this.buildKeyObjectTypeConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
    }

    @Override
    public void setAsKeyStructConverter(String name, String converter) {
        this.removeChild("type-converter");
        this.removeChild("object-type-converter");
        this.removeChild("converter");
        StructConverter valueConverter = this.buildKeyStructConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
        valueConverter.setConverter(converter);
    }

    @Override
    public void setAsKeyTypeConverter(String name) {
        this.removeChild("converter");
        this.removeChild("object-type-converter");
        this.removeChild("struct-converter");
        TypeConverter valueConverter = this.buildKeyTypeConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
    }

    @Override
    public void setConvert(String value) {
        this.updateChildTextNode("value-converter", value);
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute("fetch", (Enum<?>)type);
    }

    @Override
    public void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode("join-fetch", (Enum<?>)type);
    }

    @Override
    public void setKeyConverter(String value) {
        this.updateChildTextNode("key-converter", value);
    }
}

