/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.eclipse.persistence.tools.utility.iterable.SingleElementListIterable;
import org.eclipse.persistence.tools.utility.iterable.TransformationListIterable;
import org.eclipse.persistence.tools.utility.iterator.CompositeListIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationListIterator;

public class CompositeListIterable<E>
implements ListIterable<E> {
    private final ListIterable<? extends ListIterable<E>> iterables;

    public <L extends List<E>> CompositeListIterable(List<L> lists) {
        this(new TransformationListIterable<L, ListIterable<E>>(lists){

            @Override
            protected ListIterable<E> transform(L list) {
                return new ListListIterable(list);
            }
        });
    }

    public CompositeListIterable(ListIterable<? extends ListIterable<E>> iterables) {
        if (iterables == null) {
            throw new NullPointerException();
        }
        this.iterables = iterables;
    }

    public CompositeListIterable(E object, List<E> list) {
        this(object, new ListListIterable<E>(list));
    }

    public CompositeListIterable(E object, ListIterable<E> iterable) {
        this(new ListIterable[]{new SingleElementListIterable<E>(object), iterable});
    }

    public CompositeListIterable(List<E> list, E object) {
        this(new ListListIterable<E>(list), object);
    }

    public CompositeListIterable(ListIterable<E> iterable, E object) {
        this(new ListIterable[]{iterable, new SingleElementListIterable<E>(object)});
    }

    public CompositeListIterable(ListIterable<E> ... iterables) {
        this((ListIterable<ListIterable<E>>)new ArrayListIterable<ListIterable<E>>(iterables));
    }

    public CompositeListIterable(List<E> ... lists) {
        this(new TransformationListIterable<List<E>, ListIterable<E>>(new ArrayListIterable<List<E>>(lists)){

            @Override
            protected ListIterable<E> transform(List<E> list) {
                return new ListListIterable(list);
            }
        });
    }

    @Override
    public ListIterator<E> iterator() {
        return new CompositeListIterator<E>(this.iterators());
    }

    protected ListIterator<? extends ListIterator<E>> iterators() {
        return new TransformationListIterator<ListIterable<E>, ListIterator<E>>(this.iterables()){

            @Override
            protected ListIterator<E> transform(ListIterable<E> next) {
                return next.iterator();
            }
        };
    }

    protected ListIterator<? extends ListIterable<E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return ListTools.list(this).toString();
    }
}

