/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import org.eclipse.persistence.tools.utility.AssertionFailedException;

public final class Assert {
    public static boolean UNIT_TESTS = Boolean.getBoolean("unit-tests");

    private Assert() {
        throw new UnsupportedOperationException("Assert cannot be instantiated");
    }

    public static void fail() {
        Assert.fail("fail");
    }

    public static void fail(String description) {
        throw new AssertionFailedException(description);
    }

    public static boolean isFalse(boolean expression) {
        return Assert.isFalse(expression, "");
    }

    public static boolean isFalse(boolean expression, String message) {
        if (expression) {
            Assert.fail(message);
        }
        return expression;
    }

    public static boolean isLegal(boolean expression) {
        return Assert.isLegal(expression, "");
    }

    public static boolean isLegal(boolean expression, String message) {
        if (!expression) {
            Assert.fail(message);
        }
        return expression;
    }

    public static void isNotNull(Object object) {
        Assert.isNotNull(object, "");
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            Assert.fail(message);
        }
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(expression, "");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            Assert.fail(message);
        }
        return expression;
    }
}

