/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.testing.framework.TestModel;

public class TestRunModel
extends TestModel {
    protected DatabaseLogin login;
    protected DatabaseLogin oldLogin;
    protected boolean usesNativeMode = false;
    protected boolean isLight = true;
    protected boolean isAll = false;
    protected Vector testList;

    public TestRunModel() {
        this.setName("LRGTestModel");
        this.setDescription("This model runs all of the LRG tests.");
    }

    public void addTests() {
        if (!this.getTests().isEmpty()) {
            return;
        }
        Vector<String> tests = new Vector<String>();
        if (this.isLight) {
            tests.add("org.eclipse.persistence.testing.tests.helper.HelperTestModel");
            tests.add("org.eclipse.persistence.testing.tests.workbenchintegration.MappingWMIntegrationStoredProcedureTestModel");
            tests.add("org.eclipse.persistence.testing.tests.workbenchintegration.MappingWorkbenchIntegrationTestModel");
            tests.add("org.eclipse.persistence.testing.tests.mapping.MappingTestModel");
            tests.add("org.eclipse.persistence.testing.tests.directmap.DirectMapMappingModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.FeatureTestModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.FeatureTestModelWithoutBinding");
            tests.add("org.eclipse.persistence.testing.tests.feature.TopLinkBatchUpdatesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.JDBCBatchUpdatesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.ParameterizedBatchUpdatesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.NativeBatchWritingTestModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.EmployeeJoinFetchTestModel");
            tests.add("org.eclipse.persistence.testing.tests.types.TypeTestModelWithAccessors");
            tests.add("org.eclipse.persistence.testing.tests.types.TypeTestModelWithOutAccessors");
            tests.add("org.eclipse.persistence.testing.tests.conversion.ConversionManagerTestModel");
            tests.add("org.eclipse.persistence.testing.tests.conversion.ConversionManagerTestModelWithoutBinding");
            tests.add("org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unidirectional.UnidirectionalEmployeeBasicTestModel");
            tests.add("org.eclipse.persistence.testing.tests.onetoonejointable.OneToOneJoinTableEmployeeBasicTestModel");
            tests.add("org.eclipse.persistence.testing.tests.orderedlist.OrderListTestModel");
            tests.add("org.eclipse.persistence.testing.tests.insurance.InsuranceBasicTestModel");
            tests.add("org.eclipse.persistence.testing.tests.insurance.InsuranceObjectRelationalTestModel");
            tests.add("org.eclipse.persistence.testing.tests.legacy.LegacyTestModel");
            tests.add("org.eclipse.persistence.testing.tests.aggregate.AggregateTestModel");
            tests.add("org.eclipse.persistence.testing.tests.inheritance.InheritanceTestModel");
            tests.add("org.eclipse.persistence.testing.tests.ownership.OwnershipTestModel");
            tests.add("org.eclipse.persistence.testing.tests.mapping.OuterJoinWithMultipleTablesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.interfaces.InterfaceWithTablesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.interfaces.InterfaceWithoutTablesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingTestModel");
            tests.add("org.eclipse.persistence.testing.tests.relationshipmaintenance.RelationshipsTestModel");
            tests.add("org.eclipse.persistence.testing.tests.jpql.JPQLTestModel");
            tests.add("org.eclipse.persistence.testing.tests.simultaneous.SimultaneousTestsModel");
            tests.add("org.eclipse.persistence.testing.tests.writing.ComplexUpdateAndUnitOfWorkTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkClientSessionTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.ProtectedUnitOfWorkTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkIsolatedClientSessionTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkIsolatedAlwaysTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkSynchNewObjectsClientSessionTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkPartitionedTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkPartitionedIsolatedAlwaysTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.transactionisolation.UnitOfWorkTransactionIsolationTestModel");
            tests.add("org.eclipse.persistence.testing.tests.transparentindirection.TransparentIndirectionModel");
            tests.add("org.eclipse.persistence.testing.tests.collections.CollectionsTestModel");
            tests.add("org.eclipse.persistence.testing.tests.collections.map.MapCollectionsTestModel");
            tests.add("org.eclipse.persistence.testing.tests.customsqlstoredprocedures.CustomSQLTestModel");
            tests.add("org.eclipse.persistence.testing.tests.validation.ValidationModel");
            tests.add("org.eclipse.persistence.testing.tests.readonly.ReadOnlyTestModel");
            tests.add("org.eclipse.persistence.testing.tests.forceupdate.FUVLTestModel");
            tests.add("org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLBasicTestModel");
            tests.add("org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.changeflag.EmployeeChangeTrackingTestModel");
            tests.add("org.eclipse.persistence.testing.tests.helper.HelperTestModel");
            tests.add("org.eclipse.persistence.testing.tests.schemaframework.AutoTableGeneratorBasicTestModel");
            tests.add("org.eclipse.persistence.testing.tests.schemaframework.StoredProcedureGeneratorModel");
            tests.add("org.eclipse.persistence.testing.tests.proxyindirection.ProxyIndirectionTestModel");
            tests.add("org.eclipse.persistence.testing.tests.localization.LocalizationTestModel");
            tests.add("org.eclipse.persistence.testing.tests.history.HistoryTestRunModel");
            tests.add("org.eclipse.persistence.testing.tests.isolatedsession.IsolatedSessionTestModel");
            tests.add("org.eclipse.persistence.testing.tests.unitofwork.writechanges.UnitOfWorkWriteChangesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryModel");
            tests.add("org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.EmployeeTimeToLiveTestModel");
            tests.add("org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.EmployeeDailyExpiryTestModel");
            tests.add("org.eclipse.persistence.testing.tests.nondeferredwrites.NonDeferredWritesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.multipletable.MultipleTableModel");
            tests.add("org.eclipse.persistence.testing.tests.distributedcache.DistributedCacheModel");
            tests.add("org.eclipse.persistence.testing.tests.tableswithspacesmodel.EmployeeWithSpacesTestModel");
            tests.add("org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QueryAndSQLCountingTestModel");
            tests.add("org.eclipse.persistence.testing.tests.identitymaps.cache.CacheIdentityMapTestModel");
            tests.add("org.eclipse.persistence.testing.tests.failover.FailoverTestModel");
        }
        if (this.isAll) {
            tests.add("org.eclipse.persistence.testing.tests.classpath.ClassPathTestModel");
            tests.add("org.eclipse.persistence.testing.tests.feature.NativeModeCreatorTestModel");
            tests.add("org.eclipse.persistence.testing.tests.nls.japanese.NLSMappingWorkbenchIntegrationTestModel");
            tests.add("org.eclipse.persistence.testing.tests.sessionbroker.BrokerTestModel");
            tests.add("org.eclipse.persistence.testing.tests.sessionbroker.MultipleClientBrokersTestModel");
            tests.add("org.eclipse.persistence.testing.tests.sessionbroker.RMISessionBrokerRemoteModel");
            tests.add("org.eclipse.persistence.testing.tests.sessionbroker.ServerBrokerTestModel");
            tests.add("org.eclipse.persistence.testing.tests.remote.RMIRemoteModel");
            tests.add("org.eclipse.persistence.testing.tests.remote.rmi.IIOP.RMIIIOPRemoteModel");
            tests.add("org.eclipse.persistence.testing.tests.remote.suncorba.SunCORBARemoteModel");
            tests.add("org.eclipse.persistence.testing.tests.distributedservers.DistributedSessionBrokerServersModel");
            tests.add("org.eclipse.persistence.testing.tests.distributedservers.rcm.RCMDistributedServersModel");
            tests.add("org.eclipse.persistence.testing.tests.distributedservers.rcm.jgroups.JGroupsDistributedServersModel");
            tests.add("org.eclipse.persistence.testing.tests.clientserver.ClientServerTestModel");
            tests.add("org.eclipse.persistence.testing.tests.plsql.PLSQLTestModel");
            tests.add("org.eclipse.persistence.testing.tests.plsql.PLSQLXMLTestModel");
        }
        for (int index = 0; index < tests.size(); ++index) {
            try {
                this.addTest((Test)((TestModel)Class.forName((String)tests.elementAt(index)).newInstance()));
                continue;
            }
            catch (Throwable exception) {
                System.out.println("Failed to set up " + tests.elementAt(index) + " \n" + exception);
            }
        }
        Collections.sort(this.getTests(), new Comparator(){

            public int compare(Object left, Object right) {
                return Helper.getShortClassName(left.getClass()).compareTo(Helper.getShortClassName(right.getClass()));
            }
        });
        this.testList = tests;
    }

    public static Vector buildAllModels() {
        Vector<Object> models = new Vector<Object>();
        try {
            models.add(Class.forName("org.eclipse.persistence.testing.tests.SRGTestModel").newInstance());
        }
        catch (Exception exception) {
            System.out.println("Failed to set up org.eclipse.persistence.testing.tests.SRGTestModel \n" + exception);
        }
        models.add((Object)TestRunModel.buildLRGTestModel());
        models.add((Object)TestRunModel.buildNonLRGTestModel());
        models.add(TestRunModel.buildOracleTestModel());
        models.add(TestRunModel.buildOracleNoSQLTestModel());
        models.add(TestRunModel.buildNoSQLTestModel());
        models.add(TestRunModel.buildJPATestModel());
        models.add(TestRunModel.buildPerformanceTestModel());
        models.add(TestRunModel.buildJPAPerformanceTestModel());
        Vector<String> manualTest = new Vector<String>();
        manualTest.add("org.eclipse.persistence.testing.tests.stress.StressTestModel");
        manualTest.add("org.eclipse.persistence.testing.tests.manual.ManualVerificationModel");
        TestModel manual = new TestModel();
        manual.setName("Manual Tests");
        for (int index = 0; index < manualTest.size(); ++index) {
            try {
                manual.addTest((Test)((TestModel)Class.forName((String)manualTest.elementAt(index)).newInstance()));
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to set up " + manualTest.elementAt(index) + " \n" + exception);
            }
        }
        models.add(manual);
        return models;
    }

    public static TestModel buildJPATestModel() {
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("org.eclipse.persistence.testing.tests.jpa.AllJPATests");
        TestModel model = new TestModel();
        model.setName("JPA Tests");
        for (int index = 0; index < tests.size(); ++index) {
            try {
                model.addTest((Test)((TestModel)Class.forName((String)tests.get(index)).newInstance()));
                continue;
            }
            catch (Throwable exception) {
                System.out.println("Failed to set up " + tests.get(index) + " \n" + exception);
            }
        }
        return model;
    }

    public static TestModel buildOracleTestModel() {
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("org.eclipse.persistence.testing.tests.OracleTestModel");
        tests.add("org.eclipse.persistence.testing.tests.OracleJPATestSuite");
        tests.add("org.eclipse.persistence.testing.tests.xdb.XDBTestModel");
        tests.add("org.eclipse.persistence.testing.tests.xdb.XDBTestModelMWIntegration");
        tests.add("org.eclipse.persistence.testing.tests.unwrappedconnection.UnwrapConnectionXDBTestModel");
        TestModel model = new TestModel();
        model.setName("Oracle Tests");
        for (int index = 0; index < tests.size(); ++index) {
            try {
                Class<?> cls = Class.forName((String)tests.get(index));
                if (TestModel.class.isAssignableFrom(cls)) {
                    model.addTest((Test)((TestModel)cls.newInstance()));
                    continue;
                }
                Method suite = cls.getDeclaredMethod("suite", new Class[0]);
                model.addTest((Test)suite.invoke(null, new Object[0]));
                continue;
            }
            catch (Throwable exception) {
                System.out.println("Failed to set up " + tests.get(index) + " \n" + exception);
            }
        }
        return model;
    }

    public static TestModel buildOracleNoSQLTestModel() {
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("org.eclipse.persistence.testing.tests.eis.nosql.NoSQLTestModel");
        tests.add("org.eclipse.persistence.testing.tests.jpa.nosql.NoSQLTestSuite");
        tests.add("org.eclipse.persistence.testing.tests.jpa.nosql.NoSQLMappedTestSuite");
        tests.add("org.eclipse.persistence.testing.tests.eis.aq.AQTestModel");
        TestModel model = new TestModel();
        model.setName("Oracle NoSQL Tests");
        for (int index = 0; index < tests.size(); ++index) {
            try {
                Class<?> cls = Class.forName((String)tests.get(index));
                if (TestModel.class.isAssignableFrom(cls)) {
                    model.addTest((Test)((TestModel)cls.newInstance()));
                    continue;
                }
                Method suite = cls.getDeclaredMethod("suite", new Class[0]);
                model.addTest((Test)suite.invoke(null, new Object[0]));
                continue;
            }
            catch (Throwable exception) {
                System.out.println("Failed to set up " + tests.get(index) + " \n" + exception);
            }
        }
        return model;
    }

    public static TestModel buildNoSQLTestModel() {
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("org.eclipse.persistence.testing.tests.NoSQLJPATestSuite");
        tests.add("org.eclipse.persistence.testing.tests.eis.cobol.CobolTestModel");
        tests.add("org.eclipse.persistence.testing.tests.eis.xmlfile.XMLFileTestModel");
        TestModel model = new TestModel();
        model.setName("NoSQL Tests");
        for (int index = 0; index < tests.size(); ++index) {
            try {
                Class<?> cls = Class.forName((String)tests.get(index));
                if (TestModel.class.isAssignableFrom(cls)) {
                    model.addTest((Test)((TestModel)cls.newInstance()));
                    continue;
                }
                Method suite = cls.getDeclaredMethod("suite", new Class[0]);
                model.addTest((Test)suite.invoke(null, new Object[0]));
                continue;
            }
            catch (Throwable exception) {
                System.out.println("Failed to set up " + tests.get(index) + " \n" + exception);
            }
        }
        return model;
    }

    public static TestSuite suite() {
        return TestRunModel.buildLRGTestModel();
    }

    public static TestRunModel buildLRGTestModel() {
        TestRunModel model = new TestRunModel();
        model.setName("LRGTestModel");
        model.setDescription("This model runs all of the LRG tests.");
        model.isLight = true;
        model.addTests();
        return model;
    }

    public static TestRunModel buildAllTestModels() {
        TestRunModel model = new TestRunModel();
        model.setName("AllTestModels");
        model.setDescription("This model runs all of the tests under a single database, without client/server and JTS.");
        model.isLight = true;
        model.isAll = true;
        model.addTests();
        return model;
    }

    public static TestRunModel buildNonLRGTestModel() {
        TestRunModel model = new TestRunModel();
        model.setName("NonLRGTestModel");
        model.setDescription("This model includes all of the tests not in the LRG.");
        model.isLight = false;
        model.isAll = true;
        model.addTests();
        return model;
    }

    public static Vector buildLRGTestList() {
        TestRunModel model = new TestRunModel();
        model.isLight = true;
        model.addTests();
        return model.testList;
    }

    public static Vector buildAllTestModelsList() {
        TestRunModel model = new TestRunModel();
        model.isLight = true;
        model.isAll = true;
        model.addTests();
        return model.testList;
    }

    public static Vector buildNonLRGTestList() {
        TestRunModel model = new TestRunModel();
        model.isLight = false;
        model.isAll = true;
        model.addTests();
        return model.testList;
    }

    public static TestModel buildPerformanceTestModel() {
        Vector<String> performanceTests = new Vector<String>();
        performanceTests.add("org.eclipse.persistence.testing.tests.performance.PerformanceComparisonModel");
        performanceTests.add("org.eclipse.persistence.testing.tests.performance.PerformanceTestModel");
        performanceTests.add("org.eclipse.persistence.testing.tests.performance.PerformanceTestModelRun");
        performanceTests.add("org.eclipse.persistence.testing.tests.performance.ConcurrencyComparisonTestModel");
        performanceTests.add("org.eclipse.persistence.testing.tests.performance.ConcurrencyRegressionTestModel");
        performanceTests.add("org.eclipse.persistence.testing.tests.performance.JavaPerformanceComparisonModel");
        TestModel performanceModel = new TestModel();
        performanceModel.setName("Performance Tests");
        for (int index = 0; index < performanceTests.size(); ++index) {
            try {
                performanceModel.addTest((Test)((TestModel)Class.forName((String)performanceTests.elementAt(index)).newInstance()));
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to set up " + performanceTests.elementAt(index) + " \n" + exception);
            }
        }
        return performanceModel;
    }

    public static TestModel buildJPAPerformanceTestModel() {
        Vector<String> performanceTests = new Vector<String>();
        performanceTests.add("org.eclipse.persistence.testing.tests.jpa.performance.JPAPerformanceTestModel");
        performanceTests.add("org.eclipse.persistence.testing.tests.jpa.memory.JPAMemoryTestModel");
        TestModel performanceModel = new TestModel();
        performanceModel.setName("JPA Performance Tests");
        for (int index = 0; index < performanceTests.size(); ++index) {
            try {
                performanceModel.addTest((Test)((TestModel)Class.forName((String)performanceTests.elementAt(index)).newInstance()));
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to set up " + performanceTests.elementAt(index) + " \n" + exception);
            }
        }
        return performanceModel;
    }

    public void reset() {
        if (this.login != null) {
            this.getDatabaseSession().logout();
            this.getDatabaseSession().login((Login)this.oldLogin);
        }
        this.getExecutor().initializeConfiguredSystems();
    }

    public void setup() {
        if (this.login != null) {
            this.oldLogin = this.getSession().getLogin();
            DatabaseLogin newLogin = (DatabaseLogin)this.login.clone();
            this.getDatabaseSession().logout();
            this.getDatabaseSession().login((Login)newLogin.clone());
        }
        if (this.usesNativeMode) {
            this.getSession().getLogin().setUsesNativeSQL(true);
            this.getSession().getLogin().useNativeSequencing();
        }
    }
}

