/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.iterable.ListIterable;


/**
 * This interface and describes the configurable properties defined for a entity result in the ORM
 * xml. An entity result is used in a sql result set mapping to define how the raw, jdbc data
 * conforms to a targeted entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.EntityResult
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalEntityResult extends ExternalForm {

	/**
	 * Adds a field result with the given name.
	 */
	void addFieldResult(int index, String name);

	/**
	 * Returns a list of field result mappings.
	 */
	ListIterable<ExternalFieldResult> fieldResults();

	/**
	 * Returns the count of all the field result mappings.
	 */
	int fieldResultsSize();

	/**
	 * Returns the discriminator column name that identifies this result.
	 */
	String getDiscriminatorColumnName();

	/**
	 * Returns the name of the targeted entity class.
	 */
	String getEntityClassName();

	/**
	 * Returns the field result at the specified position.
	 */
	ExternalFieldResult getFieldResult(int index);

	/**
	 * Returns the position of this entity result within the list of entity results owned by the parent.
	 */
	int getIndex();

	/**
	 * Removes the field result at the specified position.
	 */
	void removeFieldResult(int index);

	/**
	 * Set the discriminator column name that identifies this result.
	 */
	void setDiscriminatorColumnName(String name);

	/**
	 * Set the name of the targeted entity class.
	 */
	void setEntityClassName(String className);
}