/*******************************************************************************
 * Copyright (c) 2008, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.db;

import org.eclipse.persistence.tools.utility.JavaType;

/**
 * Database column
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @version 2.5
 */
public interface Column extends DatabaseObject {

	/**
	 * Returns the column's table.
	 */
	Table getTable();


	// ********** constraints **********

	/**
	 * Returns whether the column is part of its table's primary key.
	 */
	boolean isPartOfPrimaryKey();

	/**
	 * Returns whether the column is part of one of its table's foreign keys.
	 */
	boolean isPartOfForeignKey();

	/**
	 * Returns whether the column is part of a unique constraint defined for its
	 * table.
	 */
	boolean isPartOfUniqueConstraint();

	/**
	 * Returns whether the column is nullable.
	 */
	boolean isNullable();


	// ********** data type **********

	/**
	 * Returns the name of the column's datatype.
	 */
	String getDataTypeName();

	/**
	 * Returns whether the column's type is numeric.
	 */
	boolean isNumeric();

	/**
	 * Returns -1.
	 */
	public int getPrecision();

	/**
	 * Returns -1.
	 */
	public int getScale();

	/**
	 * Returns -1.
	 */
	public int getLength();

	/**
	 * Returns whether the column's datatype is a LOB type (i.e. BLOB, CLOB, or NCLOB).
	 */
	boolean isLOB();


	// ********** Java type **********

	/**
	 * Returns a Java type declaration that is reasonably similar to the column's data type.
	 */
	String getJavaTypeDeclaration();

	/**
	 * Returns a Java type that is reasonably similar to the column's data type.
	 */
	JavaType getJavaType();

	/**
	 * Returns a Java type declaration that is reasonably similar to the column's data type and
	 * suitable for use as a primary key field.
	 */
	String getPrimaryKeyJavaTypeDeclaration();

	/**
	 * Returns a Java type that is reasonably similar to the column's data type and suitable for use
	 * as a primary key field.
	 */
	JavaType getPrimaryKeyJavaType();
}