/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.gen.db.ForeignKey;
import org.eclipse.persistence.tools.gen.db.Schema;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.gen.internal.BaseEntityGenCustomizer;
import org.eclipse.persistence.tools.gen.internal.DatabaseAnnotationNameBuilder;
import org.eclipse.persistence.tools.gen.internal.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.persistence.tools.gen.internal.GenericEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.persistence.tools.gen.internal.MappingFileGenerator;
import org.eclipse.persistence.tools.gen.internal.ORMGenCustomizer;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;

public class RelationalEntityGenerator {
    private Database database;

    public RelationalEntityGenerator(Database database) {
        this.database = database;
    }

    private DatabaseAnnotationNameBuilder buildDatabaseAnnotationNameBuilder() {
        return new LocalDatabaseAnnotationNameBuilder(GenericEntityGeneratorDatabaseAnnotationNameBuilder.instance());
    }

    private ORMGenCustomizer createORMGenCustomizer(Schema schema, List<String> tableNames) {
        BaseEntityGenCustomizer customizer = new BaseEntityGenCustomizer();
        ((ORMGenCustomizer)customizer).init(null, schema);
        customizer.setTableNames(tableNames);
        return customizer;
    }

    public String generateMappings(String schemaName) {
        Schema schema = this.database.getSchemaNamed(schemaName);
        ORMGenCustomizer ormGenCustomizer = this.createORMGenCustomizer(schema, this.transformToTableNames(schema.getTables()));
        ormGenCustomizer.setDatabaseAnnotationNameBuilder(this.buildDatabaseAnnotationNameBuilder());
        return MappingFileGenerator.generate(ormGenCustomizer);
    }

    public String generateMappings(String schemaName, List<String> tableNames) {
        ORMGenCustomizer ormGenCustomizer = this.createORMGenCustomizer(this.database.getSchemaNamed(schemaName), tableNames);
        ormGenCustomizer.setDatabaseAnnotationNameBuilder(this.buildDatabaseAnnotationNameBuilder());
        return MappingFileGenerator.generate(ormGenCustomizer);
    }

    public List<String> getSchemaNames() {
        return ListTools.list((Iterator)new TransformationIterator<Schema, String>(this.database.getSchemata()){

            protected String transform(Schema next) {
                return next.getName();
            }
        });
    }

    public List<String> getTableNames(String schemaName) {
        return this.transformToTableNames(this.database.getSchemaNamed(schemaName).getTables());
    }

    private List<String> transformToTableNames(Iterable<Table> tables) {
        return ListTools.list((Iterable)new TransformationIterable<Table, String>(tables){

            protected String transform(Table table) {
                return table.getName();
            }
        });
    }

    private class LocalDatabaseAnnotationNameBuilder
    implements DatabaseAnnotationNameBuilder {
        private EntityGeneratorDatabaseAnnotationNameBuilder builder;

        LocalDatabaseAnnotationNameBuilder(EntityGeneratorDatabaseAnnotationNameBuilder builder) {
            this.builder = builder;
        }

        @Override
        public String buildColumnAnnotationName(String attributeName, Column column) {
            return this.builder.buildColumnAnnotationName(attributeName, column);
        }

        @Override
        public String buildJoinColumnAnnotationName(Column column) {
            return this.builder.buildJoinColumnAnnotationName(column);
        }

        @Override
        public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
            return this.builder.buildJoinColumnAnnotationName(attributeName, foreignKey);
        }

        @Override
        public String buildJoinTableAnnotationName(Table table) {
            return this.builder.buildJoinTableAnnotationName(table);
        }

        @Override
        public String buildTableAnnotationName(String entityName, Table table) {
            return this.builder.buildTableAnnotationName(entityName, table);
        }
    }
}

