/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceUnit;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class PersistenceConfiguration
extends AbstractExternalForm
implements ExternalPersistenceConfiguration {
    private Document document;
    static final String NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence";
    static final String PERSISTENCE = "persistence";
    private static final String PERSISTENCE_XSD_URI_1_0 = "http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd";
    private static final String PERSISTENCE_XSD_URI_2_0 = "http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd";
    private static final String PERSISTENCE_XSD_URI_2_1 = "http://java.sun.com/xml/ns/persistence/persistence_2_1.xsd";
    static final String VERSION = "version";

    PersistenceConfiguration(Document document) {
        super(null);
        this.document = document;
    }

    @Override
    public void addPersistenceUnit(int index, String name) {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit(index);
        persistenceUnit.addSelf();
        persistenceUnit.setName(name);
    }

    @Override
    protected Element addSelf(String elementName) {
        return this.addSelf(elementName, Collections.<String>emptyList());
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        Element element = this.document.createElementNS(NAMESPACE_URI, elementName);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE_URI);
        this.addXmlns(element, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", this.buildSchemaLocation(PersistenceDocumentType.JPA_2_0));
        element.setAttribute(VERSION, this.getBuildVersion());
        this.document.appendChild(element);
        return element;
    }

    private PersistenceUnit buildPersistenceUnit(int index) {
        return new PersistenceUnit(this, index);
    }

    private String buildSchemaLocation(PersistenceDocumentType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(NAMESPACE_URI);
        sb.append(" ");
        switch (type) {
            case JPA_1_0: {
                sb.append(PERSISTENCE_XSD_URI_1_0);
                break;
            }
            case JPA_2_0: {
                sb.append(PERSISTENCE_XSD_URI_2_0);
                break;
            }
            case JPA_2_1: {
                sb.append(PERSISTENCE_XSD_URI_2_1);
            }
        }
        return sb.toString();
    }

    @Override
    public String getBuildVersion() {
        return PersistenceDocumentType.JPA_2_0.getVersion();
    }

    @Override
    public Element getElement() {
        return this.getRootElement();
    }

    @Override
    protected String getElementName() {
        return PERSISTENCE;
    }

    @Override
    public ExternalPersistenceUnit getPersistenceUnit(int index) {
        Element element = this.getChild("persistence-unit", index);
        if (element == null) {
            return null;
        }
        return this.buildPersistenceUnit(index);
    }

    @Override
    public PersistenceDocumentType getDocumentType() {
        return PersistenceDocumentType.value(this.getNamespace(), this.getVersion(), this.getSchemaLocation());
    }

    @Override
    public ListIterable<ExternalPersistenceUnit> persistenceUnits() {
        int count = this.getChildrenSize("persistence-unit");
        ArrayList<PersistenceUnit> persistenceUnits = new ArrayList<PersistenceUnit>(count);
        int index = count;
        while (--index >= 0) {
            PersistenceUnit persistenceUnit = this.buildPersistenceUnit(index);
            persistenceUnits.add(0, persistenceUnit);
        }
        return new ListListIterable(persistenceUnits);
    }

    @Override
    public int persistenceUnitsSize() {
        return this.getChildrenSize("persistence-unit");
    }

    @Override
    public void removePersistenceUnit(int index) {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit(index);
        persistenceUnit.removeSelf();
    }

    @Override
    public void setDocumentType(PersistenceDocumentType type) {
        this.setAttribute(VERSION, type.getVersion());
        this.setSchemaLocation(this.buildSchemaLocation(type));
    }
}

