/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneListIterable;
import org.eclipse.persistence.tools.utility.tests.iterable.LiveCloneIterableTests;

public class LiveCloneListIterableTests
extends LiveCloneIterableTests {
    public LiveCloneListIterableTests(String name) {
        super(name);
    }

    public void testAdd() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildRemovingIterable(collection);
        String added = "xxxx";
        LiveCloneListIterableTests.assertFalse((boolean)IterableTools.contains((Iterable)this.iterable, (Object)added));
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("two")) continue;
            iterator.add(added);
        }
        LiveCloneListIterableTests.assertTrue((boolean)collection.contains(added));
        LiveCloneListIterableTests.assertTrue((boolean)IterableTools.contains((Iterable)this.iterable, (Object)added));
    }

    public void testMissingMutatorAdd() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterable(collection);
        LiveCloneListIterableTests.assertNotNull((Object)this.iterable.toString());
        String added = "xxxx";
        LiveCloneListIterableTests.assertFalse((boolean)IterableTools.contains((Iterable)this.iterable, (Object)added));
        boolean exCaught = false;
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("three")) continue;
            try {
                iterator.add(added);
                LiveCloneListIterableTests.fail();
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
        }
        LiveCloneListIterableTests.assertTrue((boolean)exCaught);
    }

    public void testSet() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildRemovingIterable(collection);
        String added = "xxxx";
        LiveCloneListIterableTests.assertFalse((boolean)IterableTools.contains((Iterable)this.iterable, (Object)added));
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("two")) continue;
            iterator.set(added);
        }
        LiveCloneListIterableTests.assertTrue((boolean)collection.contains(added));
        LiveCloneListIterableTests.assertFalse((boolean)collection.contains("two"));
        LiveCloneListIterableTests.assertTrue((boolean)IterableTools.contains((Iterable)this.iterable, (Object)added));
        LiveCloneListIterableTests.assertFalse((boolean)IterableTools.contains((Iterable)this.iterable, (Object)"two"));
    }

    public void testMissingMutatorSet() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterable(collection);
        LiveCloneListIterableTests.assertNotNull((Object)this.iterable.toString());
        String added = "xxxx";
        LiveCloneListIterableTests.assertFalse((boolean)IterableTools.contains((Iterable)this.iterable, (Object)added));
        boolean exCaught = false;
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("three")) continue;
            try {
                iterator.set(added);
                LiveCloneListIterableTests.fail();
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
        }
        LiveCloneListIterableTests.assertTrue((boolean)exCaught);
    }

    @Override
    Iterable<String> buildIterable(List<String> c) {
        return new LiveCloneListIterable(c);
    }

    @Override
    Iterable<String> buildRemovingIterable(final List<String> c) {
        return new LiveCloneListIterable<String>(c){

            protected void add(int index, String element) {
                c.add(index, element);
            }

            protected void remove(int index) {
                c.remove(index);
            }

            protected void set(int index, String element) {
                c.set(index, element);
            }
        };
    }

    @Override
    Iterable<String> buildIterableWithRemover(List<String> c) {
        return new LiveCloneListIterable(c, this.buildMutator(c));
    }
}

