/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.filter;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.BitTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.FilterAdapter;
import org.eclipse.persistence.tools.utility.filter.ORFilter;
import org.eclipse.persistence.tools.utility.filter.SimpleFilter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ORFilterTests
extends TestCase {
    private ORFilter<Number> orFilter;

    public ORFilterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.orFilter = new ORFilter(new Filter[]{this.buildMinFilter(1.0), this.buildMaxFilter(10.0)});
    }

    private Filter<Number> buildMinFilter(double min) {
        return new MinFilter(min);
    }

    private Filter<Number> buildMaxFilter(double max) {
        return new MaxFilter(max);
    }

    private Filter<Number> buildEvenFilter() {
        return new EvenFilter();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testFiltering2() {
        ORFilterTests.assertFalse((boolean)this.orFilter.accept((Object)new Integer(7)));
        ORFilterTests.assertFalse((boolean)this.orFilter.accept((Object)new Integer(2)));
        ORFilterTests.assertFalse((boolean)this.orFilter.accept((Object)new Double(6.666)));
        ORFilterTests.assertTrue((boolean)this.orFilter.accept((Object)new Double(-99.0)));
        ORFilterTests.assertTrue((boolean)this.orFilter.accept((Object)new Double(-1.0)));
        ORFilterTests.assertTrue((boolean)this.orFilter.accept((Object)new Double(11.0)));
        ORFilterTests.assertTrue((boolean)this.orFilter.accept((Object)new Double(111.0)));
    }

    public void testFiltering3() {
        ORFilter orFilter2 = new ORFilter(new Filter[]{this.orFilter, this.buildEvenFilter()});
        ORFilterTests.assertFalse((boolean)orFilter2.accept((Object)new Integer(7)));
        ORFilterTests.assertFalse((boolean)orFilter2.accept((Object)new Integer(3)));
        ORFilterTests.assertFalse((boolean)orFilter2.accept((Object)new Integer(9)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Integer(2)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(6.1)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-99.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-1.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(11.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(111.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-98.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(0.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-2.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(12.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(222.0)));
    }

    public void testFilteringComposite() {
        ORFilter orFilter2 = new ORFilter(new Filter[]{this.buildMinFilter(1.0), this.buildMaxFilter(10.0), this.buildEvenFilter()});
        ORFilterTests.assertFalse((boolean)orFilter2.accept((Object)new Integer(7)));
        ORFilterTests.assertFalse((boolean)orFilter2.accept((Object)new Integer(3)));
        ORFilterTests.assertFalse((boolean)orFilter2.accept((Object)new Integer(9)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Integer(2)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(6.1)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-99.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-1.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(11.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(111.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-98.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(0.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(-2.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(12.0)));
        ORFilterTests.assertTrue((boolean)orFilter2.accept((Object)new Double(222.0)));
    }

    public void testClone() {
        ORFilter orFilter2 = (ORFilter)this.orFilter.clone();
        ORFilterTests.assertEquals((Object)this.orFilter.getFilters()[0], (Object)orFilter2.getFilters()[0]);
        ORFilterTests.assertEquals((Object)this.orFilter.getFilters()[1], (Object)orFilter2.getFilters()[1]);
        ORFilterTests.assertNotSame(this.orFilter, (Object)orFilter2);
    }

    public void testEquals() {
        ORFilter orFilter2 = new ORFilter(new Filter[]{this.buildMinFilter(1.0), this.buildMaxFilter(10.0)});
        ORFilterTests.assertEquals(this.orFilter, (Object)orFilter2);
        ORFilterTests.assertEquals((int)this.orFilter.hashCode(), (int)orFilter2.hashCode());
    }

    public void testSerialization() throws Exception {
        ORFilter<Number> orFilter2 = TestTools.serialize(this.orFilter);
        ORFilterTests.assertEquals((Object)this.orFilter.getFilters()[0], (Object)orFilter2.getFilters()[0]);
        ORFilterTests.assertEquals((Object)this.orFilter.getFilters()[1], (Object)orFilter2.getFilters()[1]);
        ORFilterTests.assertNotSame(this.orFilter, orFilter2);
    }

    static class EvenFilter
    extends FilterAdapter<Number> {
        EvenFilter() {
        }

        public boolean accept(Number number) {
            return BitTools.isEven((int)number.intValue());
        }
    }

    static class MaxFilter
    extends SimpleFilter<Number, Number> {
        private static final long serialVersionUID = 1L;

        MaxFilter(double min) {
            super((Object)new Double(min));
        }

        public boolean accept(Number number) {
            return number.doubleValue() >= ((Number)this.criterion).doubleValue();
        }
    }

    static class MinFilter
    extends SimpleFilter<Number, Number> {
        private static final long serialVersionUID = 1L;

        MinFilter(double min) {
            super((Object)new Double(min));
        }

        public boolean accept(Number number) {
            return number.doubleValue() <= ((Number)this.criterion).doubleValue();
        }
    }
}

