/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.ChainIterator;

public class ChainIterable<E>
implements Iterable<E> {
    private final E startLink;
    private final ChainIterator.Linker<E> linker;

    public ChainIterable(E startLink) {
        this.startLink = startLink;
        this.linker = this.buildDefaultLinker();
    }

    public ChainIterable(E startLink, ChainIterator.Linker<E> linker) {
        if (linker == null) {
            throw new NullPointerException();
        }
        this.startLink = startLink;
        this.linker = linker;
    }

    protected ChainIterator.Linker<E> buildDefaultLinker() {
        return new DefaultLinker();
    }

    @Override
    public Iterator<E> iterator() {
        return new ChainIterator<E>(this.startLink, this.linker);
    }

    protected E nextLink(E currentLink) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return ListTools.list(this).toString();
    }

    protected class DefaultLinker
    implements ChainIterator.Linker<E> {
        protected DefaultLinker() {
        }

        @Override
        public E nextLink(E currentLink) {
            return ChainIterable.this.nextLink(currentLink);
        }
    }
}

