/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class RemoteSessionReadTimeTransferTest
extends TestCase {
    protected Employee employee = null;

    public RemoteSessionReadTimeTransferTest() {
        this.setDescription("Test to ensure read times are transferred into the remote session from the server session");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
    }

    public void verify() {
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee).getReadTime() == 0L) {
            throw new TestErrorException("Read time was not properly transferred to the remote session.");
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

