/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.RelationalTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class CollectionTableMetadata
extends RelationalTableMetadata {
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();

    public CollectionTableMetadata() {
        super("<collection-table>");
    }

    public CollectionTableMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public CollectionTableMetadata(MetadataAnnotation collectionTable, MetadataAccessor accessor) {
        super(collectionTable, accessor);
        if (collectionTable != null) {
            Object[] objectArray = collectionTable.getAttributeArray("primaryKeyJoinColumns");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object primaryKeyJoinColumn = objectArray[n2];
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn, accessor));
                ++n2;
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CollectionTableMetadata) {
            CollectionTableMetadata collectionTable = (CollectionTableMetadata)objectToCompare;
            return this.valuesMatch(this.m_primaryKeyJoinColumns, collectionTable.getPrimaryKeyJoinColumns());
        }
        return false;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_collection_table_catalog";
    }

    @Override
    public String getNameContext() {
        return "metadata_default_collection_table_name";
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_collection_table_schema";
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

