/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;

public class TableNameDialog
extends AbstractDialog {
    private JLabel messageLabel;
    private JTextField catalogTextField;
    private JTextField schemaTextField;
    private JTextField shortNameTextField;

    TableNameDialog(WorkbenchContext context, String title, String message) {
        this(context, title, message, null);
    }

    TableNameDialog(WorkbenchContext context, String title, String message, String initialShortName) {
        this(context, title, message, null, null, initialShortName);
    }

    TableNameDialog(WorkbenchContext context, String title, String message, String initialCatalog, String initialSchema, String initialShortName) {
        super(context);
        this.setTitle(title);
        this.messageLabel = new JLabel(message);
        this.catalogTextField = new JTextField(initialCatalog, 30);
        this.schemaTextField = new JTextField(initialSchema, 30);
        this.shortNameTextField = new JTextField(initialShortName, 30);
    }

    @Override
    protected Component initialFocusComponent() {
        return this.catalogTextField;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.newTable";
    }

    @Override
    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.messageLabel, constraints);
        JLabel catalogLabel = SwingComponentFactory.buildLabel("NEW_CATALOG_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)catalogLabel, constraints);
        this.helpManager().addTopicID(this.catalogTextField, this.helpTopicId() + ".catalog");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.catalogTextField, constraints);
        catalogLabel.setLabelFor(this.catalogTextField);
        JLabel schemaLabel = SwingComponentFactory.buildLabel("NEW_SCHEMA_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)schemaLabel, constraints);
        this.helpManager().addTopicID(this.schemaTextField, this.helpTopicId() + ".schema");
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.schemaTextField, constraints);
        schemaLabel.setLabelFor(this.schemaTextField);
        JLabel shortNameLabel = SwingComponentFactory.buildLabel("NEW_TABLE_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)shortNameLabel, constraints);
        this.helpManager().addTopicID(this.shortNameTextField, this.helpTopicId() + ".name");
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.shortNameTextField, constraints);
        this.shortNameTextField.getDocument().addDocumentListener(this.buildDocumentListener());
        shortNameLabel.setLabelFor(this.shortNameTextField);
        return panel;
    }

    private DocumentListener buildDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableNameDialog.this.getOKAction().setEnabled(e.getDocument().getLength() != 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableNameDialog.this.getOKAction().setEnabled(e.getDocument().getLength() != 0);
            }
        };
    }

    @Override
    protected Action getOKAction() {
        return super.getOKAction();
    }

    String catalog() {
        String catalog = this.catalogTextField.getText();
        return catalog.length() == 0 ? null : catalog;
    }

    String schema() {
        String schema = this.schemaTextField.getText();
        return schema.length() == 0 ? null : schema;
    }

    String shortName() {
        String shortName = this.shortNameTextField.getText();
        return shortName.length() == 0 ? null : shortName;
    }
}

