/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface and inherited behavior describe the configurable properties defined for a named,
 * native query in the ORM xml. A named, native query may be declared at the root level of the ORM
 * xml or on an individual entity basis.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.NamedNativeQuery
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalNativeQuery extends ExternalNamedQuery {

	/**
	 * Returns the name of the class that will represent the result of this query.
	 */
	String getResultClassName();

	/**
	 * Returns a string representing how the result set from this mapping will be mapped to the give
	 * result class type.
	 */
	String getResultSetMapping();

	/**
	 * Sets the name of the class that will represent the result of this query.
	 */
	void setResultClassName(String name);

	/**
	 * Sets the result set from this mapping.
	 */
	void setResultSetMapping(String mappingName);
}