/*******************************************************************************
 * Copyright (c) 2008, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ExceptionHandler;

public class ExceptionHandlerTests extends TestCase {

	public ExceptionHandlerTests(String name) {
		super(name);
	}

	public void testNullExceptionHandler() {
		ExceptionHandler exceptionHandler = ExceptionHandler.Null.instance();
		exceptionHandler.handleException(new NullPointerException());  // just make sure it doesn't blow up?
	}

	public void testNullExceptionHandlerToString() {
		ExceptionHandler exceptionHandler = ExceptionHandler.Null.instance();
		assertNotNull(exceptionHandler.toString());
	}

	public void testRuntimeExceptionHandler1() {
		Exception npe = new Exception();
		ExceptionHandler exceptionHandler = ExceptionHandler.Runtime.instance();
		boolean exCaught = false;
		try {
			exceptionHandler.handleException(npe);
			fail();
		} catch (RuntimeException ex) {
			assertSame(npe, ex.getCause());
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testRuntimeExceptionHandler2() {
		Exception npe = new NullPointerException();
		ExceptionHandler exceptionHandler = ExceptionHandler.Runtime.instance();
		boolean exCaught = false;
		try {
			exceptionHandler.handleException(npe);
			fail();
		} catch (RuntimeException ex) {
			assertSame(npe, ex);
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testRuntimeExceptionHandlerToString() {
		ExceptionHandler exceptionHandler = ExceptionHandler.Runtime.instance();
		assertNotNull(exceptionHandler.toString());
	}
}