/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.db.model.ELDatabase;
import org.eclipse.persistence.tools.db.model.ELModel;
import org.eclipse.persistence.tools.db.model.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;
import org.eclipse.persistence.tools.utility.iterator.CloneListIterator;
import org.eclipse.persistence.tools.utility.iterator.EmptyIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.node.Node;

public final class ELLoginSpec
extends ELModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile String driverClassName;
    public static final String DRIVER_CLASS_NAME_PROPERTY = "driverClassName";
    public static final String CANDIDATE_URLS_COLLECTION = "candidateURLs";
    private volatile String url;
    public static final String URL_PROPERTY = "url";
    private volatile String userName;
    public static final String USER_NAME_PROPERTY = "userName";
    private volatile String password;
    public static final String PASSWORD_PROPERTY = "password";
    private volatile boolean savePassword;
    public static final String SAVE_PASSWORD_PROPERTY = "savePassword";
    private List<String> driverClasspathEntries;
    public static final String DRIVER_CLASSPATH_ENTRIES_LIST = "driverClasspathEntries";
    private static Collection<DriverSpec> driverSpecs;
    private static JCEEncryptor encryptor;
    public static final String DB_DRIVER_CLASS_PREFERENCE = "database driver class";
    public static final String DB_CONNECTION_URL_PREFERENCE = "database connection url";

    public static Iterator<String> commonDriverClassNames() {
        return new TransformationIterator<DriverSpec, String>(ELLoginSpec.driverSpecs()){

            protected String transform(DriverSpec next) {
                return next.getDriverClassName();
            }
        };
    }

    public static int commonDriverClassNamesSize() {
        return ELLoginSpec.getDriverSpecs().size();
    }

    private static Iterator<String> urlsForDriverClassNamed(String driverClassName) {
        DriverSpec ds = ELLoginSpec.driverSpecFor(driverClassName);
        return ds == null ? EmptyIterator.instance() : ds.urls();
    }

    private static int urlsForDriverClassNamedSize(String driverClassName) {
        DriverSpec ds = ELLoginSpec.driverSpecFor(driverClassName);
        return ds == null ? 0 : ds.urlsSize();
    }

    private static boolean urlsForDriverClassNamedContains(String driverClassName, String url) {
        DriverSpec ds = ELLoginSpec.driverSpecFor(driverClassName);
        return ds == null ? false : ds.containsURL(url);
    }

    private static String defaultURLForDriverClassNamed(String driverClassName) {
        DriverSpec ds = ELLoginSpec.driverSpecFor(driverClassName);
        return ds == null ? null : ds.defaultURL();
    }

    private static DriverSpec driverSpecFor(String driverClassName) {
        Iterator<DriverSpec> stream = ELLoginSpec.driverSpecs();
        while (stream.hasNext()) {
            DriverSpec ds = stream.next();
            if (!ds.getDriverClassName().equals(driverClassName)) continue;
            return ds;
        }
        return null;
    }

    private static Iterator<DriverSpec> driverSpecs() {
        return ELLoginSpec.getDriverSpecs().iterator();
    }

    private static synchronized Collection<DriverSpec> getDriverSpecs() {
        if (driverSpecs == null) {
            driverSpecs = ELLoginSpec.buildDriverSpecs();
        }
        return driverSpecs;
    }

    private static Collection<DriverSpec> buildDriverSpecs() {
        ArrayList<DriverSpec> specs = new ArrayList<DriverSpec>(30);
        specs.add(new DriverSpec("com.neon.jdbc.Driver", "jdbc:neon:"));
        specs.add(new DriverSpec("com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase:"));
        specs.add(new DriverSpec("com.sybase.jdbc3.jdbc.SybDriver", "jdbc:sybase:Tds:"));
        specs.add(new DriverSpec("com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds:"));
        specs.add(new DriverSpec("com.sybase.jdbc.SybDriver", "jdbc:sybase:Tds:"));
        specs.add(new DriverSpec("COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:"));
        specs.add(new DriverSpec("COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2:"));
        specs.add(new DriverSpec("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://"));
        specs.add(new DriverSpec("com.mysql.jdbc.Driver", "jdbc:mysql://"));
        specs.add(new DriverSpec("borland.jdbc.Bridge.LocalDriver", "jdbc:BorlandBridge:"));
        specs.add(new DriverSpec("borland.jdbc.Broker.RemoteDriver", "jdbc:BorlandBridge:"));
        specs.add(new DriverSpec("intersolv.jdbc.sequelink.SequeLinkDriver", "jdbc:sequelink:"));
        String[] oracleURLs = new String[]{"jdbc:oracle:thin:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci7:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci8:@<HOST>:<PORT>:<SID>"};
        specs.add(new DriverSpec("oracle.jdbc.OracleDriver", oracleURLs));
        specs.add(new DriverSpec("oracle.jdbc.driver.OracleDriver", oracleURLs));
        specs.add(new DriverSpec("com.oracle.ias.jdbc.db2.DB2Driver", "jdbc:oracle:db2://"));
        specs.add(new DriverSpec("com.oracle.ias.jdbc.sqlserver.SQLServerDriver", "jdbc:oracle:sqlserver://"));
        specs.add(new DriverSpec("com.oracle.ias.jdbc.sybase.SybaseDriver", "jdbc:oracle:sybase://"));
        specs.add(new DriverSpec("org.hsqldb.jdbcDriver", "jdbc:hsqldb:"));
        specs.add(new DriverSpec("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:"));
        specs.add(new DriverSpec("weblogic.jdbc.oci.Driver", "jdbc:weblogic:oracle:"));
        specs.add(new DriverSpec("weblogic.jdbc.dblib.Driver", new String[]{"jdbc:weblogic:mssqlserver:", "jdbc:weblogic:sybase"}));
        specs.add(new DriverSpec("weblogic.jdbc.informix4.Driver", "jdbc:weblogic:informix4:"));
        specs.add(new DriverSpec("weblogic.jdbc.jts.Driver", "jdbc:weblogic:jts:"));
        specs.add(new DriverSpec("weblogic.jdbc.mssqlserver4.Driver", "jdbc:weblogic:mssqlserver4:"));
        specs.add(new DriverSpec("weblogic.jdbc.pool.Driver", "jdbc:weblogic:pool:"));
        specs.add(new DriverSpec("weblogic.jdbc.t3client.Driver", "jdbc:weblogic:t3Client:"));
        specs.add(new DriverSpec("weblogic.jdbc.t3.Driver", "jdbc:weblogic:t3:"));
        specs.add(new DriverSpec("com.timesten.jdbc.TimesTenDriver", "jdbc:timesten:direct:<SID>"));
        return specs;
    }

    private static JCEEncryptor getEncryptor() {
        if (encryptor == null) {
            try {
                encryptor = new JCEEncryptor();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return encryptor;
    }

    ELLoginSpec(ELDatabase database, String name) {
        super(database);
        this.name = name;
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.savePassword = false;
        this.driverClasspathEntries = new Vector<String>();
    }

    public final ELDatabase getParent() {
        return (ELDatabase)super.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        String old = this.driverClassName;
        this.driverClassName = driverClassName;
        this.firePropertyChanged(DRIVER_CLASS_NAME_PROPERTY, old, driverClassName);
        if (this.attributeValueHasChanged(old, driverClassName) && (this.url == null || ELLoginSpec.urlsForDriverClassNamedContains(old, this.url))) {
            this.setURL(ELLoginSpec.defaultURLForDriverClassNamed(driverClassName));
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        String old = this.url;
        this.url = url;
        this.firePropertyChanged(URL_PROPERTY, old, url);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        String old = this.userName;
        this.userName = userName;
        this.firePropertyChanged(USER_NAME_PROPERTY, old, userName);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String old = this.password;
        this.password = password;
        this.firePropertyChanged(PASSWORD_PROPERTY, old, password);
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        boolean old = this.savePassword;
        this.savePassword = savePassword;
        this.firePropertyChanged(SAVE_PASSWORD_PROPERTY, old, savePassword);
    }

    public ListIterator<String> driverClasspathEntries() {
        return new CloneListIterator(this.driverClasspathEntries);
    }

    public int driverClasspathEntriesSize() {
        return this.driverClasspathEntries.size();
    }

    public String getDriverClasspathEntry(int index) {
        return this.driverClasspathEntries.get(index);
    }

    public void addDriverClasspathEntry(int index, String entry) {
        this.addItemToList(index, entry, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public void addDriverClasspathEntry(String entry) {
        this.addDriverClasspathEntry(this.driverClasspathEntriesSize(), entry);
    }

    public void addDriverClasspathEntries(int index, List<String> entries) {
        this.addItemsToList(index, entries, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public void addDriverClasspathEntries(List<String> entries) {
        this.addDriverClasspathEntries(this.driverClasspathEntriesSize(), entries);
    }

    public void addDriverClasspathEntries(ListIterator<String> entries) {
        this.addDriverClasspathEntries(ListTools.list(entries));
    }

    public String removeDriverClasspathEntry(int index) {
        return (String)this.removeItemFromList(index, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public List<String> removeDriverClasspathEntries(int index, int length) {
        return this.removeItemsFromList(index, length, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public String replaceDriverClasspathEntry(int index, String newEntry) {
        return (String)this.setItemInList(index, newEntry, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public String defaultURL() {
        return ELLoginSpec.defaultURLForDriverClassNamed(this.driverClassName);
    }

    public Iterator<String> candidateURLs() {
        return ELLoginSpec.urlsForDriverClassNamed(this.driverClassName);
    }

    public int candidateURLsSize() {
        return ELLoginSpec.urlsForDriverClassNamedSize(this.driverClassName);
    }

    Driver buildDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.driverClassName == null || this.driverClassName.length() == 0) {
            throw new IllegalStateException("missing database driver class name");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> driverClass = Class.forName(this.driverClassName, true, classLoader);
        return (Driver)driverClass.newInstance();
    }

    public Connector buildConnector() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new MWConnector(this.buildDriver(), this.getURL());
    }

    private DatabasePlatform databasePlatform() {
        return this.getParent().getDatabasePlatform();
    }

    DatabaseLogin buildDevelopmentRuntimeDatabaseLogin() {
        DatabaseLogin login = this.buildRuntimeDatabaseLogin();
        login.setConnector(this.getParent().buildRuntimeConnector());
        return login;
    }

    DatabaseLogin buildDeploymentRuntimeDatabaseLogin() {
        DatabaseLogin login = this.buildRuntimeDatabaseLogin();
        if (!this.savePassword) {
            login.setPassword(null);
        }
        return login;
    }

    private DatabaseLogin buildRuntimeDatabaseLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.setDriverClassName(this.driverClassName);
        login.setDriverURLHeader("");
        login.setDatabaseURL(this.url);
        login.setUserName(this.userName);
        login.setPassword(this.password);
        login.setPlatformClassName(this.databasePlatform().getRuntimePlatformClassName());
        return login;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }

    @Override
    public String displayString() {
        return this.name;
    }

    private String getPasswordForTopLink() {
        return this.savePassword ? this.encryptedPassword() : null;
    }

    private String encryptedPassword() {
        return this.password == null ? null : ELLoginSpec.getEncryptor().encryptPassword(this.password);
    }

    private void setPasswordForTopLink(String password) {
        this.password = password == null ? null : ELLoginSpec.getEncryptor().decryptPassword(password);
    }

    private void legacySetPasswordForTopLink(String password) {
        this.password = password;
    }

    private static final class DriverSpec {
        private String driverClassName;
        private String[] urls;

        DriverSpec(String driverClassName, String[] urls) {
            if (driverClassName == null || driverClassName.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.driverClassName = driverClassName;
            if (urls == null || urls.length == 0) {
                throw new IllegalArgumentException();
            }
            this.urls = urls;
        }

        DriverSpec(String driverClassName, String url) {
            this(driverClassName, new String[]{url});
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public Iterator<String> urls() {
            return new ArrayIterator((Object[])this.urls);
        }

        public int urlsSize() {
            return this.urls.length;
        }

        public boolean containsURL(String url) {
            int i = this.urls.length;
            while (i-- > 0) {
                if (!this.urls[i].equals(url)) continue;
                return true;
            }
            return false;
        }

        public String defaultURL() {
            return this.urls[0];
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (String)this.driverClassName);
        }
    }

    private static class MWConnector
    implements Connector {
        private Driver driver;
        private String url;

        public MWConnector(Driver driver, String url) {
            this.driver = driver;
            this.url = url;
        }

        public Connection connect(Properties properties, Session session) {
            try {
                return this.driver.connect(this.url, properties);
            }
            catch (SQLException ex) {
                throw DatabaseException.sqlException((SQLException)ex);
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                throw new InternalError("clone failed");
            }
        }

        public String getConnectionDetails() {
            return "MWConnector: " + this.url;
        }

        public void toString(PrintWriter writer) {
            writer.println(this.getConnectionDetails());
        }
    }
}

