/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;

public class IndirectSetTestAPI
extends ZTestCase {
    Vector list;
    IndirectSet testList;

    public IndirectSetTestAPI(String name) {
        super(name);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        HashSet temp = new HashSet(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        this.testList = new IndirectSet();
        this.testList.setValueHolder((ValueHolderInterface)vh);
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void testAdd() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testAddAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
    }

    public void testClear() {
        this.list.clear();
        this.testList.clear();
        IndirectSetTestAPI.assertEquals((Object)this.list, new Vector(this.testList));
        IndirectSetTestAPI.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
    }

    public void testContains() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.contains(this.list.elementAt(1)));
    }

    public void testContainsAll() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
    }

    public void testEquals() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.equals(new HashSet(this.list)));
    }

    public void testIsEmpty() {
        IndirectSetTestAPI.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
    }

    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectSetTestAPI.assertEquals((int)this.list.size(), (int)i);
    }

    public void testRemove() {
        String temp = "one";
        IndirectSetTestAPI.assertTrue((boolean)this.list.remove(temp));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.remove((Object)temp));
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        IndirectSetTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
    }

    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectSetTestAPI.assertTrue((boolean)this.list.removeAll(temp));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.removeAll(temp));
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        IndirectSetTestAPI.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
    }

    public void testRetainAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectSetTestAPI.assertTrue((boolean)this.list.retainAll(temp));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.retainAll(temp));
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        IndirectSetTestAPI.assertEquals((int)temp.size(), (int)this.testList.size());
    }

    public void testSize() {
        IndirectSetTestAPI.assertEquals((int)this.list.size(), (int)this.testList.size());
    }

    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        this.assertUnorderedElementsEqual(v1, v2);
    }

    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        this.assertUnorderedElementsEqual(v1, v2);
    }
}

