/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockFineGrainedTest;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PessimisticLockOutsideUnitOfWorkTest
extends PessimisticLockFineGrainedTest {
    public PessimisticLockOutsideUnitOfWorkTest(short lockMode) {
        super(lockMode);
        this.setDescription("This test verifies the pessimistic locking feature works properly when set on the descriptor.  And especially only for queries  executed inside a UnitOfWork, not outside.  Outside the query should  be a regular NO_LOCK query.");
    }

    @Override
    public void test() throws Exception {
        this.checkSelectForUpateSupported();
        if (this.lockMode == 2) {
            this.checkNoWaitSupported();
        }
        if (this.getSession().getPlatform().isPostgreSQL()) {
            this.throwWarning("Postgres aborts transaction after lock error.");
        }
        ReadObjectQuery query = new ReadObjectQuery(Address.class);
        Address address = (Address)this.getSession().executeQuery((DatabaseQuery)query);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        query.setSelectionObject((Object)address);
        address = (Address)this.getSession().executeQuery((DatabaseQuery)query);
        this.uow = this.getSession().acquireUnitOfWork();
        address = (Address)this.uow.executeQuery((DatabaseQuery)query);
        DatabaseSession session2 = null;
        UnitOfWork uow2 = null;
        try {
            session2 = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getProject().createDatabaseSession() : this.getSession().getProject().createDatabaseSession();
            session2.setLog(this.getSession().getLog());
            session2.setLogLevel(this.getSession().getLogLevel());
            session2.login();
            uow2 = session2.acquireUnitOfWork();
            boolean isLocked = false;
            try {
                Address lockedAddress = (Address)uow2.executeQuery((DatabaseQuery)query);
                lockedAddress.toString();
            }
            catch (EclipseLinkException exeception) {
                session2.logMessage(exeception.toString());
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestErrorException("Select for update does not acquire a lock");
            }
            session2.executeQuery((DatabaseQuery)query);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
            if (session2 != null) {
                session2.logout();
            }
        }
        query.checkCacheOnly();
        address = (Address)this.getSession().executeQuery((DatabaseQuery)query);
        this.strongAssert(address != null, "Did not get a cache hit when executing lock query outside a UOW");
    }
}

