/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWTransactionalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWTransactionalProjectCachingPolicy
extends MWModel
implements MWCachingPolicy {
    private volatile MWCachingPolicy.CacheCoordinationOption cacheCoordination;
    private static TopLinkOptionSet cacheCoordinationOptions;
    private volatile MWCachingPolicy.CacheIsolationOption cacheIsolation;
    private static TopLinkOptionSet cacheIsolationOptions;
    private volatile int cacheSize;
    private volatile MWCachingPolicy.CacheTypeOption cacheType;
    private static TopLinkOptionSet cacheTypeOptions;
    private volatile MWCachingPolicy.ExistenceCheckingOption existenceChecking;
    private static TopLinkOptionSet existenceCheckingOptions;
    private volatile MWCacheExpiry cacheExpiry;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTransactionalProjectCachingPolicy.class);
        XMLDirectMapping cacheSizeMapping = (XMLDirectMapping)descriptor.addDirectMapping("cacheSize", "caching-size/text()");
        cacheSizeMapping.setNullValue((Object)new Integer(100));
        XMLDirectMapping cacheTypeMapping = (XMLDirectMapping)descriptor.addDirectMapping("cacheType", "cache-type/text()");
        ObjectTypeConverter cacheTypeConverter = new ObjectTypeConverter();
        MWTransactionalProjectCachingPolicy.cacheTypeOptions().addConversionValuesForTopLinkTo(cacheTypeConverter);
        cacheTypeMapping.setConverter((Converter)cacheTypeConverter);
        cacheTypeMapping.setNullValue((Object)MWTransactionalProjectCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption("Weak with Soft subcache"));
        ObjectTypeConverter existenceCheckingConverter = new ObjectTypeConverter();
        MWTransactionalProjectCachingPolicy.existenceCheckingOptions().addConversionValuesForTopLinkTo(existenceCheckingConverter);
        XMLDirectMapping existenceCheckingMapping = new XMLDirectMapping();
        existenceCheckingMapping.setAttributeName("existenceChecking");
        existenceCheckingMapping.setNullValue((Object)MWTransactionalProjectCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption("Check cache"));
        existenceCheckingMapping.setXPath("existence-checking/text()");
        existenceCheckingMapping.setConverter((Converter)existenceCheckingConverter);
        descriptor.addMapping((DatabaseMapping)existenceCheckingMapping);
        ObjectTypeConverter cacheCoordinationConverter = new ObjectTypeConverter();
        MWTransactionalProjectCachingPolicy.cacheCoordinationOptions().addConversionValuesForTopLinkTo(cacheCoordinationConverter);
        XMLDirectMapping cacheCoordinationMapping = new XMLDirectMapping();
        cacheCoordinationMapping.setAttributeName("cacheCoordination");
        cacheCoordinationMapping.setXPath("cache-coordination/text()");
        cacheCoordinationMapping.setNullValue((Object)MWTransactionalProjectCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("Synchronize Changes"));
        cacheCoordinationMapping.setConverter((Converter)cacheCoordinationConverter);
        descriptor.addMapping((DatabaseMapping)cacheCoordinationMapping);
        ObjectTypeConverter cacheIsolationConverter = new ObjectTypeConverter();
        MWTransactionalProjectCachingPolicy.cacheIsolationOptions().addConversionValuesForTopLinkTo(cacheIsolationConverter);
        XMLDirectMapping cacheIsolationMapping = new XMLDirectMapping();
        cacheIsolationMapping.setAttributeName("cacheIsolation");
        cacheIsolationMapping.setXPath("cache-isolation/text()");
        cacheIsolationMapping.setConverter((Converter)cacheIsolationConverter);
        cacheIsolationMapping.setNullValue((Object)MWTransactionalProjectCachingPolicy.cacheIsolationOptions().topLinkOptionForMWModelOption("Shared"));
        descriptor.addMapping((DatabaseMapping)cacheIsolationMapping);
        XMLCompositeObjectMapping cacheExpiryMapping = new XMLCompositeObjectMapping();
        cacheExpiryMapping.setAttributeName("cacheExpiry");
        cacheExpiryMapping.setReferenceClass(MWDescriptorCacheExpiry.class);
        cacheExpiryMapping.setXPath("cache-expiry");
        descriptor.addMapping((DatabaseMapping)cacheExpiryMapping);
        return descriptor;
    }

    public static synchronized TopLinkOptionSet cacheCoordinationOptions() {
        if (cacheCoordinationOptions == null) {
            ArrayList<MWCachingPolicy.CacheCoordinationOption> list = new ArrayList<MWCachingPolicy.CacheCoordinationOption>();
            list.add(new MWCachingPolicy.CacheCoordinationOption("None", "CACHING_POLICY_CACHE_COORDINATION_NONE", 4));
            list.add(new MWCachingPolicy.CacheCoordinationOption("Synchronize Changes", "CACHING_POLICY_CACHE_COORDINATION_SYNCHRONIZE_CHANGES", 1));
            list.add(new MWCachingPolicy.CacheCoordinationOption("Synchronize Changes and New Objects", "CACHING_POLICY_CACHE_COORDINATION_SYNCHRONIZE_CHANGES_AND_NEW_OBJECTS", 3));
            list.add(new MWCachingPolicy.CacheCoordinationOption("Invalidate Changed Objects", "CACHING_POLICY_CACHE_COORDINATION_INVALIDATE_CHANGED_OBJECTS", 2));
            cacheCoordinationOptions = new TopLinkOptionSet(list);
        }
        return cacheCoordinationOptions;
    }

    public static synchronized TopLinkOptionSet cacheIsolationOptions() {
        if (cacheIsolationOptions == null) {
            ArrayList<MWCachingPolicy.CacheIsolationOption> list = new ArrayList<MWCachingPolicy.CacheIsolationOption>();
            list.add(new MWCachingPolicy.CacheIsolationOption("Isolated", "CACHING_POLICY_CACHE_ISOLATION_ISOLATED"));
            list.add(new MWCachingPolicy.CacheIsolationOption("Shared", "CACHING_POLICY_CACHE_ISOLATION_SHARED"));
            cacheIsolationOptions = new TopLinkOptionSet(list);
        }
        return cacheIsolationOptions;
    }

    public static synchronized TopLinkOptionSet cacheTypeOptions() {
        if (cacheTypeOptions == null) {
            ArrayList<MWCachingPolicy.CacheTypeOption> list = new ArrayList<MWCachingPolicy.CacheTypeOption>();
            list.add(new MWCachingPolicy.CacheTypeOption("Weak with Soft subcache", "ORACLE_TOPLINK_INTERNAL_IDENTITYMAPS_SOFTCACHEWEAKIDENTITYMAP", SoftCacheWeakIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Weak with Hard Subcache", "ORACLE_TOPLINK_INTERNAL_IDENTITYMAPS_HARDCACHEWEAKIDENTITYMAP", HardCacheWeakIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Weak", "ORACLE_TOPLINK_INTERNAL_IDENTITYMAPS_WEAKIDENTITYMAP", WeakIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Soft", "ORACLE_TOPLINK_INTERNAL_IDENTITYMAPS_SOFTIDENTITYMAP", SoftIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Full", "ORACLE_TOPLINK_INTERNAL_IDENTITYMAPS_FULLIDENTITYMAP", FullIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("None", "ORACLE_TOPLINK_INTERNAL_IDENTITYMAPS_NOIDENTITYMAP", NoIdentityMap.class.getName()));
            cacheTypeOptions = new TopLinkOptionSet(list);
        }
        return cacheTypeOptions;
    }

    public static synchronized TopLinkOptionSet existenceCheckingOptions() {
        if (existenceCheckingOptions == null) {
            ArrayList<MWCachingPolicy.ExistenceCheckingOption> list = new ArrayList<MWCachingPolicy.ExistenceCheckingOption>();
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Check cache", "CACHING_POLICY_EXISTENCE_CHECKING_CHECK_CACHE", 3));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Check database", "CACHING_POLICY_EXISTENCE_CHECKING_CHECK_DATABASE", 4));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Assume existence", "CACHING_POLICY_EXISTENCE_CHECKING_ASSUME_EXISTENCE", 2));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Assume non-existence", "CACHING_POLICY_EXISTENCE_CHECKING_ASSUME_NON_EXISTENCE", 1));
            existenceCheckingOptions = new TopLinkOptionSet(list);
        }
        return existenceCheckingOptions;
    }

    private MWTransactionalProjectCachingPolicy() {
    }

    MWTransactionalProjectCachingPolicy(MWTransactionalProjectDefaultsPolicy parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.cacheCoordination = (MWCachingPolicy.CacheCoordinationOption)MWTransactionalProjectCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("Synchronize Changes");
        this.cacheIsolation = (MWCachingPolicy.CacheIsolationOption)MWTransactionalProjectCachingPolicy.cacheIsolationOptions().topLinkOptionForMWModelOption("Shared");
        this.cacheSize = 100;
        this.cacheType = (MWCachingPolicy.CacheTypeOption)MWTransactionalProjectCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption("Weak with Soft subcache");
        this.cacheExpiry = new MWDescriptorCacheExpiry(this);
        this.existenceChecking = (MWCachingPolicy.ExistenceCheckingOption)MWTransactionalProjectCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption("Check cache");
    }

    @Override
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.cacheExpiry);
    }

    @Override
    public void initializeFrom(MWCachingPolicy otherPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MWCachingPolicy.CacheCoordinationOption getCacheCoordination() {
        return this.cacheCoordination;
    }

    @Override
    public MWCachingPolicy.CacheIsolationOption getCacheIsolation() {
        return this.cacheIsolation;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public MWCachingPolicy.CacheTypeOption getCacheType() {
        return this.cacheType;
    }

    @Override
    public MWCachingPolicy.ExistenceCheckingOption getExistenceChecking() {
        return this.existenceChecking;
    }

    @Override
    public void setCacheCoordination(MWCachingPolicy.CacheCoordinationOption cacheCoordination) {
        MWCachingPolicy.CacheCoordinationOption oldCacheCoordination = this.cacheCoordination;
        this.cacheCoordination = cacheCoordination;
        this.firePropertyChanged("cacheCoordination", oldCacheCoordination, cacheCoordination);
    }

    @Override
    public void setCacheIsolation(MWCachingPolicy.CacheIsolationOption cacheIsolation) {
        MWCachingPolicy.CacheIsolationOption oldCacheIsolation = this.cacheIsolation;
        this.cacheIsolation = cacheIsolation;
        this.firePropertyChanged("cacheIsolation", oldCacheIsolation, cacheIsolation);
        if (cacheIsolation.getMWModelOption() == "Isolated") {
            this.setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)MWTransactionalProjectCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("None"));
        }
    }

    @Override
    public void setCacheSize(int cacheSize) {
        int oldCacheSize = this.cacheSize;
        this.cacheSize = cacheSize;
        this.firePropertyChanged("cacheSize", oldCacheSize, cacheSize);
    }

    @Override
    public void setCacheType(MWCachingPolicy.CacheTypeOption cacheType) {
        MWCachingPolicy.CacheTypeOption oldCacheType = this.cacheType;
        this.cacheType = cacheType;
        this.firePropertyChanged("cacheType", oldCacheType, cacheType);
    }

    @Override
    public void setCacheType(String cacheTypeString) {
        this.setCacheType((MWCachingPolicy.CacheTypeOption)MWTransactionalProjectCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption(cacheTypeString));
    }

    @Override
    public void setExistenceChecking(MWCachingPolicy.ExistenceCheckingOption newExistenceChecking) {
        MWCachingPolicy.ExistenceCheckingOption oldValue = this.existenceChecking;
        this.existenceChecking = newExistenceChecking;
        this.firePropertyChanged("existenceChecking", oldValue, this.existenceChecking);
    }

    @Override
    public void setExistenceChecking(String existenceChecking) {
        this.setExistenceChecking((MWCachingPolicy.ExistenceCheckingOption)MWTransactionalProjectCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption(existenceChecking));
    }

    @Override
    public MWCacheExpiry getCacheExpiry() {
        return this.cacheExpiry;
    }

    @Override
    public void setUseProjectDefaultCacheExpiry(boolean useProjectCacheExpiry) {
        throw new UnsupportedOperationException("Does not apply for Project caching policy");
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MWMappingDescriptor getOwningDescriptor() {
        return null;
    }

    @Override
    public boolean usesProjectDefaultCacheSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void descriptorInheritanceChanged() {
    }

    @Override
    public MWCachingPolicy getPersistedPolicy() {
        return this;
    }
}

